/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.testobject.api.InvalidUserInputServerException;
import org.testobject.api.ProxySettings;
import org.testobject.api.TestObjectClient;
import org.testobject.external.apache.http.config.Registry;
import org.testobject.external.apache.http.config.RegistryBuilder;
import org.testobject.external.apache.http.conn.socket.ConnectionSocketFactory;
import org.testobject.external.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.testobject.external.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.testobject.external.apache.http.conn.ssl.X509HostnameVerifier;
import org.testobject.external.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.testobject.rest.api.model.DeviceDescriptor;
import org.testobject.rest.api.model.DynamicInstrumentationRequestData;
import org.testobject.rest.api.model.InstrumentationReport;
import org.testobject.rest.api.model.PaginationObject;
import org.testobject.rest.api.model.SessionReport;
import org.testobject.rest.api.model.StartInstrumentationResponse;
import org.testobject.rest.api.model.StaticInstrumentationRequestData;
import org.testobject.rest.api.model.TestReportWithDevice;
import org.testobject.rest.api.model.TestSuiteReport;
import org.testobject.rest.api.resource.ApiSessionReportResource;
import org.testobject.rest.api.resource.DeviceDescriptorsResource;
import org.testobject.rest.api.resource.QualityReportResource;
import org.testobject.rest.api.resource.TestReportResource;
import org.testobject.rest.api.resource.VideoResource;
import org.testobject.rest.api.resource.v2.ApiBatchReportResource;
import org.testobject.rest.api.resource.v2.ApiBatchResource;
import org.testobject.rest.api.resource.v2.ApiUploadResource;
import org.testobject.rest.api.resource.v2.AppStorageResource;
import org.testobject.rest.api.resource.v2.InstrumentationResource;

public class TestObjectClientImpl
implements TestObjectClient {
    private final ApiBatchReportResource apiBatchReportResource;
    private final ApiBatchResource apiBatchResource;
    private final ApiUploadResource apiUploadResource;
    private final AppStorageResource appStorageResource;
    private final InstrumentationResource instrumentationResource;
    private final ApiSessionReportResource apiSessionReportResource;
    private final DeviceDescriptorsResource deviceDescriptorsResource;
    private final QualityReportResource qualityReportResource;
    private final TestReportResource testReportResource;
    private final VideoResource videoResource;
    private final Client client;

    public TestObjectClientImpl(String baseUrl, ProxySettings proxySettings) {
        this.client = this.buildClient(proxySettings);
        WebTarget target = this.client.target(baseUrl);
        this.apiBatchReportResource = new ApiBatchReportResource(target);
        this.apiBatchResource = new ApiBatchResource(target);
        this.apiUploadResource = new ApiUploadResource(target);
        this.appStorageResource = new AppStorageResource(target);
        this.instrumentationResource = new InstrumentationResource(target);
        this.apiSessionReportResource = new ApiSessionReportResource(target);
        this.deviceDescriptorsResource = new DeviceDescriptorsResource(target);
        this.qualityReportResource = new QualityReportResource(target);
        this.testReportResource = new TestReportResource(target);
        this.videoResource = new VideoResource(target);
    }

    @Override
    public TestSuiteReport waitForSuiteReport(long suiteReportId, long waitTimeoutMs, long sleepTimeMs, String apiKey) {
        long start = this.now();
        while (this.now() - start < waitTimeoutMs) {
            TestSuiteReport testSuiteReport = this.apiBatchReportResource.getReport(suiteReportId, apiKey);
            if (!testSuiteReport.isRunning()) {
                return testSuiteReport;
            }
            this.sleep(sleepTimeMs);
        }
        throw new IllegalStateException("Failed to get test suite report result in 60 minutes.");
    }

    @Override
    public TestSuiteReport waitForSuiteReport(long suiteReportId, String apiKey) {
        return this.waitForSuiteReport(suiteReportId, TimeUnit.MINUTES.toMillis(60L), TimeUnit.SECONDS.toMillis(30L), apiKey);
    }

    @Override
    public String readTestSuiteXMLReport(long suiteReportId, String apiKey) {
        return this.apiBatchReportResource.getXMLReport(suiteReportId, apiKey);
    }

    @Override
    public long startInstrumentationTestSuite(long suiteId, String apiKey) {
        return this.apiBatchResource.startInstrumentationSuite(suiteId, apiKey);
    }

    @Override
    public void updateInstrumentationTestSuite(long suiteId, File appApk, File instrumentationApk, ApiBatchResource.InstrumentationTestSuiteRequest request, String apiKey) {
        String testUploadId;
        String appUploadId = this.apiUploadResource.uploadFile(apiKey, appApk).replace("\"", "");
        request.testUploadId = testUploadId = this.apiUploadResource.uploadFile(apiKey, instrumentationApk).replace("\"", "");
        request.appUploadId = appUploadId;
        this.apiBatchResource.updateInstrumentationSuite(suiteId, request, apiKey);
    }

    @Override
    public String uploadFile(String apiKey, File apk) {
        return this.apiUploadResource.uploadFile(apiKey, apk);
    }

    @Override
    public long uploadRunnerIpa(String apiKey, File ipa) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppXcuiTest(apiKey, ipa));
    }

    @Override
    public long uploadAppIpa(String apiKey, File ipa) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppXcuiApp(apiKey, ipa));
    }

    @Override
    public long uploadRunnerApk(String apiKey, File apk) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppAndroidTest(apiKey, apk));
    }

    @Override
    public long uploadAppApk(String apiKey, File apk) throws InvalidUserInputServerException {
        return Long.parseLong(this.appStorageResource.uploadAppAndroidApp(apiKey, apk));
    }

    @Override
    public StartInstrumentationResponse startXcuiTestSuite(String apiKey, StaticInstrumentationRequestData requestData) {
        return this.instrumentationResource.createAndStartXCUITestInstrumentation(apiKey, requestData);
    }

    @Override
    public StartInstrumentationResponse startXcuiTestSuite(String apiKey, DynamicInstrumentationRequestData requestData) {
        return this.instrumentationResource.createAndStartXCUITestInstrumentation(apiKey, requestData);
    }

    @Override
    public StartInstrumentationResponse startAndroidSuite(String apiKey, StaticInstrumentationRequestData requestData) {
        return this.instrumentationResource.createAndStartAndroidInstrumentation(apiKey, requestData);
    }

    @Override
    public StartInstrumentationResponse startAndroidSuite(String apiKey, DynamicInstrumentationRequestData requestData) {
        return this.instrumentationResource.createAndStartAndroidInstrumentation(apiKey, requestData);
    }

    @Override
    public String readJunitReport(String apiKey, long testReportId) {
        return this.instrumentationResource.getJUnitReport(apiKey, testReportId);
    }

    @Override
    public InstrumentationReport waitForInstrumentationReport(String apiKey, long testSuiteReportId, long waitTimeoutMs, long sleepTimeMs) throws TimeoutException {
        boolean timeoutTooLong;
        long waitTimeoutMinutes = TimeUnit.MILLISECONDS.toMinutes(waitTimeoutMs);
        boolean bl = timeoutTooLong = waitTimeoutMinutes <= TimeUnit.HOURS.toMinutes(2L);
        if (!timeoutTooLong) {
            String errorMessage = "Timeout should be a reasonable value: no more than 120 minutes. Got " + waitTimeoutMinutes + " minutes.";
            throw new IllegalArgumentException(errorMessage);
        }
        long start = this.now();
        while (this.now() - start < waitTimeoutMs) {
            InstrumentationReport testSuiteReport = this.instrumentationResource.getTestReport(apiKey, testSuiteReportId);
            if (!testSuiteReport.isRunning()) {
                return testSuiteReport;
            }
            this.sleep(sleepTimeMs);
        }
        String exceptionMessage = String.format("Failed to get a test suite report result in %d minutes.", waitTimeoutMinutes);
        throw new TimeoutException(exceptionMessage);
    }

    @Override
    public PaginationObject<SessionReport> getSessionReports(String userId, long offset, int limit, int lastDays, String apiKey) {
        return this.apiSessionReportResource.getSessionReports(userId, offset, limit, lastDays, apiKey);
    }

    @Override
    public List<DeviceDescriptor> getAvailableDeviceDescriptors() {
        return this.deviceDescriptorsResource.getAvailableDeviceDescriptors();
    }

    @Override
    public List<String> getAvailableDeviceDescriptorIds() {
        return this.deviceDescriptorsResource.getAvailableDeviceDescriptorIds();
    }

    @Override
    public long startQualityReport(String userId, String projectId, String apiKey) {
        return this.qualityReportResource.startQualityReport(userId, projectId, apiKey);
    }

    @Override
    public TestReportWithDevice getTestReport(String userId, String projectId, long reportId, String apiKey) {
        return this.testReportResource.getTestReport(userId, projectId, reportId, apiKey);
    }

    @Override
    public File saveScreenRecording(String userId, String projectId, String videoId, String apiKey, File file) {
        try (InputStream inputStream = this.videoResource.getScreenRecording(userId, projectId, videoId, apiKey).readEntity(InputStream.class);
             FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save video", e);
        }
        return file;
    }

    private void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private Client buildClient(ProxySettings proxySettings) {
        X509HostnameVerifier defaultHostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslConfig.createSSLContext(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, defaultHostnameVerifier);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.apache.client.connectionManager", new PoolingHttpClientConnectionManager(registry));
        ApacheConnectorProvider connector = new ApacheConnectorProvider();
        config.connectorProvider(connector);
        config.register((Class)MultiPartFeature.class);
        config.register((Class)JacksonFeature.class);
        if (proxySettings != null) {
            config.property("jersey.config.client.proxy.uri", "http://" + proxySettings.getHost() + ":" + proxySettings.getPort());
            if (proxySettings.getUsername() != null) {
                config.property("jersey.config.client.proxy.username", proxySettings.getUsername());
                config.property("jersey.config.client.proxy.password", proxySettings.getPassword());
            }
        }
        SSLContext sslContext = sslConfig.createSSLContext();
        ClientBuilder.newBuilder().sslContext(sslContext);
        return ClientBuilder.newClient(config);
    }

    @Override
    public void close() {
        this.client.close();
    }
}

