/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import org.utplsql.api.Version;
import org.utplsql.api.db.DefaultDatabaseInformation;

public final class DBHelper {
    private DBHelper() {
    }

    public static String newSysGuid(Connection conn) throws SQLException {
        try (CallableStatement callableStatement = conn.prepareCall("BEGIN ? := sys_guid(); END;");){
            callableStatement.registerOutParameter(1, -2);
            callableStatement.executeUpdate();
            String string = callableStatement.getString(1);
            return string;
        }
    }

    @Deprecated
    public static String getCurrentSchema(Connection conn) throws SQLException {
        try (CallableStatement callableStatement = conn.prepareCall("BEGIN ? := sys_context('userenv', 'current_schema'); END;");){
            callableStatement.registerOutParameter(1, 12);
            callableStatement.executeUpdate();
            String string = callableStatement.getString(1);
            return string;
        }
    }

    @Deprecated
    public static Version getDatabaseFrameworkVersion(Connection conn) throws SQLException {
        DefaultDatabaseInformation databaseInformation = new DefaultDatabaseInformation();
        return databaseInformation.getUtPlsqlFrameworkVersion(conn);
    }

    @Deprecated
    public static String getOracleDatabaseVersion(Connection conn) throws SQLException {
        DefaultDatabaseInformation databaseInformation = new DefaultDatabaseInformation();
        return databaseInformation.getOracleVersion(conn);
    }

    public static void enableDBMSOutput(Connection conn) {
        try (CallableStatement call = conn.prepareCall("BEGIN dbms_output.enable(NULL); END;");){
            call.execute();
        }
        catch (SQLException e) {
            System.out.println("Failed to enable dbms_output.");
        }
    }

    public static void disableDBMSOutput(Connection conn) {
        try (CallableStatement call = conn.prepareCall("BEGIN dbms_output.disable(); END;");){
            call.execute();
        }
        catch (SQLException e) {
            System.out.println("Failed to disable dbms_output.");
        }
    }
}

