/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.stream.plugin.python.api;

import java.net.URI;
import java.time.Duration;
import org.voltdb.stream.processor.VoltSP;

@VoltSP.Documentation(description="This plugin allows execution of Python code on streamed data using the GraalVM Python engine.\n\n## Features\n\n- Execute Python code on input data\n- Load Python code from a file or provide it inline\n- Set a timeout for Python execution\n- Access input data from Python\n- Emit output data from Python\n\nThe Python processor can also be configured to limit script execution time.\n\n## Python API\n\nThe JavaScript code can access the `input` data passed to the processor.\n\nThe Python code should define a `process` function that takes the input data and returns the output data:\n\n```python\ndef process(input):\n  # Process the input data\n  return output\n```\n\n## Security Considerations\n\nThe Python processor runs with limited permissions by default. It cannot access the file system, network, or other system resources unless explicitly allowed.\n", examples={@VoltSP.Documentation.Example(language=VoltSP.ConfigurationLanguage.YAML, inline="Capitalise all strings.\n\n```yaml\nversion: 1\nname: PythonProcessorExample\n\nsource:\n  file:\n    path: \"input.txt\"\n\nprocessors:\n  - python:\n      name: \"python-processor\"\n      script: |\n        def process(input):\n          if isinstance(input, str):\n            return input.upper()\n          return input\n\nsink:\n  stdout: {}\n```\n")})
@VoltSP.Processor(name="python", implementation="org.voltdb.stream.plugin.python.PythonProcessor")
public record PythonProcessorConfig(@VoltSP.Documentation.Field(description="Python code to execute") String script, @VoltSP.Documentation.Field(description="URL to a Python file to execute") URI scriptUrl, @VoltSP.Documentation.Field(description="Maximum execution time in milliseconds", defaultValue="1s") Duration timeout) {
    public PythonProcessorConfig {
        if (script == null && scriptUrl == null) {
            throw new IllegalArgumentException("Either script or scriptUrl must be provided");
        }
    }
}

