/*
 * Decompiled with CFR 0.152.
 */
package struct;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import struct.StructData;
import struct.StructException;
import struct.StructFieldData;
import struct.StructUtils;

public abstract class StructInput
extends InputStream {
    public void readObject(Object obj) throws StructException {
        Field[] fields;
        if (obj == null) {
            throw new StructException("Struct objects cannot be null.");
        }
        StructData info = StructUtils.getStructInfo(obj);
        for (Field currentField : fields = info.getFields()) {
            StructFieldData fieldData = info.getFieldData(currentField.getName());
            if (fieldData == null) {
                throw new StructException("Field Data not found for field: " + currentField.getName());
            }
            int arrayLength = -1;
            boolean lengthArray = false;
            try {
                if (info.isLenghtedArray(currentField)) {
                    Field f = info.getLenghtedArray(currentField.getName());
                    StructFieldData lengthMarker = info.getFieldData(f.getName());
                    arrayLength = lengthMarker.requiresGetterSetter() ? ((Number)lengthMarker.getGetter().invoke(obj, (Object[])null)).intValue() : ((Number)lengthMarker.getField().get(obj)).intValue();
                    lengthArray = true;
                }
                if (fieldData.requiresGetterSetter()) {
                    Method getter = fieldData.getGetter();
                    Method setter = fieldData.getSetter();
                    if (getter == null || setter == null) {
                        throw new StructException(" getter/setter required for : " + currentField.getName());
                    }
                    if (lengthArray && arrayLength >= 0) {
                        Object ret = Array.newInstance(currentField.getType().getComponentType(), arrayLength);
                        setter.invoke(obj, ret);
                        if (!currentField.getType().getComponentType().isPrimitive()) {
                            for (int j = 0; j < arrayLength; ++j) {
                                ((Object[])ret)[j] = currentField.getType().getComponentType().newInstance();
                            }
                        }
                    }
                    if (!lengthArray && currentField.getType().isArray() && getter.invoke(obj, (Object[])null) == null) {
                        throw new StructException("Arrays can not be null :" + currentField.getName());
                    }
                    this.readField(fieldData, getter, setter, obj);
                    continue;
                }
                if (lengthArray && arrayLength >= 0) {
                    Object ret = Array.newInstance(currentField.getType().getComponentType(), arrayLength);
                    currentField.set(obj, ret);
                    if (!currentField.getType().getComponentType().isPrimitive()) {
                        for (int j = 0; j < arrayLength; ++j) {
                            ((Object[])ret)[j] = currentField.getType().getComponentType().newInstance();
                        }
                    }
                }
                if (!lengthArray && currentField.getType().isArray() && currentField.get(obj) == null) {
                    throw new StructException("Arrays can not be null. : " + currentField.getName());
                }
                if (arrayLength < 0) continue;
                this.readField(fieldData, null, null, obj);
            }
            catch (Exception e) {
                throw new StructException(e);
            }
        }
    }

    public void readField(StructFieldData fieldData, Method getter, Method setter, Object obj) throws IOException, InvocationTargetException, InstantiationException, IllegalAccessException, StructException {
        Field field = fieldData.getField();
        if (!field.getType().isArray()) {
            switch (fieldData.getType()) {
                case BOOLEAN: {
                    if (setter != null) {
                        setter.invoke(obj, this.readBoolean());
                        break;
                    }
                    field.setBoolean(obj, this.readBoolean());
                    break;
                }
                case BYTE: {
                    if (setter != null) {
                        setter.invoke(obj, this.readByte());
                        break;
                    }
                    field.setByte(obj, this.readByte());
                    break;
                }
                case SHORT: {
                    if (setter != null) {
                        setter.invoke(obj, this.readShort());
                        break;
                    }
                    field.setShort(obj, this.readShort());
                    break;
                }
                case INT: {
                    if (setter != null) {
                        setter.invoke(obj, this.readInt());
                        break;
                    }
                    field.setInt(obj, this.readInt());
                    break;
                }
                case LONG: {
                    if (setter != null) {
                        setter.invoke(obj, this.readLong());
                        break;
                    }
                    field.setLong(obj, this.readLong());
                    break;
                }
                case CHAR: {
                    if (setter != null) {
                        setter.invoke(obj, Character.valueOf(this.readChar()));
                        break;
                    }
                    field.setChar(obj, this.readChar());
                    break;
                }
                case FLOAT: {
                    if (setter != null) {
                        setter.invoke(obj, Float.valueOf(this.readFloat()));
                        break;
                    }
                    field.setFloat(obj, this.readFloat());
                    break;
                }
                case DOUBLE: {
                    if (setter != null) {
                        setter.invoke(obj, this.readDouble());
                        break;
                    }
                    field.setDouble(obj, this.readDouble());
                    break;
                }
                default: {
                    if (setter != null) {
                        Object object = getter.invoke(obj, (Object[])null);
                        if (object == null) {
                            if (field.getName().endsWith("CString")) {
                                throw new StructException("CString objects should be initialized :" + field.getName());
                            }
                            object = field.getType().newInstance();
                        }
                        this.readObject(object);
                        setter.invoke(obj, object);
                        break;
                    }
                    this.handleObject(field, obj);
                    break;
                }
            }
        } else {
            if (getter != null && getter.invoke(obj, (Object[])null) == null) {
                throw new StructException("Arrays can not be null : " + field.getName());
            }
            switch (fieldData.getType()) {
                case BOOLEAN: {
                    if (getter != null) {
                        this.readBooleanArray((boolean[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readBooleanArray((boolean[])field.get(obj));
                    break;
                }
                case BYTE: {
                    if (getter != null) {
                        this.readByteArray((byte[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readByteArray((byte[])field.get(obj));
                    break;
                }
                case SHORT: {
                    if (getter != null) {
                        this.readShortArray((short[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readShortArray((short[])field.get(obj));
                    break;
                }
                case INT: {
                    if (getter != null) {
                        this.readIntArray((int[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readIntArray((int[])field.get(obj));
                    break;
                }
                case LONG: {
                    if (getter != null) {
                        this.readLongArray((long[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readLongArray((long[])field.get(obj));
                    break;
                }
                case CHAR: {
                    if (getter != null) {
                        this.readCharArray((char[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readCharArray((char[])field.get(obj));
                    break;
                }
                case FLOAT: {
                    if (getter != null) {
                        this.readFloatArray((float[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readFloatArray((float[])field.get(obj));
                    break;
                }
                case DOUBLE: {
                    if (getter != null) {
                        this.readDoubleArray((double[])getter.invoke(obj, (Object[])null));
                        break;
                    }
                    this.readDoubleArray((double[])field.get(obj));
                    break;
                }
                default: {
                    if (getter != null) {
                        this.readObjectArray(new Object[]{getter.invoke(obj, (Object[])null)});
                        break;
                    }
                    this.readObjectArray(new Object[]{field.get(obj)});
                }
            }
        }
    }

    public void handleObject(Field field, Object obj) throws IllegalArgumentException, StructException, InstantiationException, IllegalAccessException {
        if (field.get(obj) == null) {
            if (field.getType().getName().endsWith("CString")) {
                throw new StructException("CString objects should be initialized before unpacking :" + field.getName());
            }
            field.set(obj, field.getType().newInstance());
        }
        this.readObject(field.get(obj));
    }

    @Override
    public void close() {
    }

    @Override
    public int read() {
        return -1;
    }

    protected abstract boolean readBoolean() throws IOException;

    protected abstract byte readByte() throws IOException;

    protected abstract short readShort() throws IOException;

    protected abstract int readInt() throws IOException;

    protected abstract long readLong() throws IOException;

    protected abstract char readChar() throws IOException;

    protected abstract float readFloat() throws IOException;

    protected abstract double readDouble() throws IOException;

    protected abstract void readBooleanArray(boolean[] var1) throws IOException;

    protected abstract void readByteArray(byte[] var1) throws IOException;

    protected abstract void readCharArray(char[] var1) throws IOException;

    protected abstract void readShortArray(short[] var1) throws IOException;

    protected abstract void readIntArray(int[] var1) throws IOException;

    protected abstract void readLongArray(long[] var1) throws IOException;

    protected abstract void readFloatArray(float[] var1) throws IOException;

    protected abstract void readDoubleArray(double[] var1) throws IOException;

    protected abstract void readObjectArray(Object[] var1) throws IOException, StructException;
}

