/*
 * Decompiled with CFR 0.152.
 */
package struct;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import struct.LEDataInputStream;
import struct.StructData;
import struct.StructException;
import struct.StructFieldData;
import struct.StructInput;
import struct.StructUtils;

public class StructUnpacker
extends StructInput {
    DataInput dataInput;

    protected void init(InputStream inStream, ByteOrder order) {
        this.dataInput = order == ByteOrder.LITTLE_ENDIAN ? new LEDataInputStream(inStream) : new DataInputStream(inStream);
    }

    public StructUnpacker(byte[] bufferToUnpack) {
        this(new ByteArrayInputStream(bufferToUnpack), ByteOrder.BIG_ENDIAN);
    }

    public StructUnpacker(byte[] bufferToUnpack, ByteOrder order) {
        this(new ByteArrayInputStream(bufferToUnpack), order);
    }

    public StructUnpacker(InputStream is, ByteOrder order) {
        this.init(is, order);
    }

    public void unpack(Object objectToUnpack) throws StructException {
        this.readObject(objectToUnpack);
    }

    @Override
    public void readObject(Object obj) throws StructException {
        Field[] fields;
        if (obj == null) {
            throw new StructException("Struct objects cannot be null.");
        }
        StructData info = StructUtils.getStructInfo(obj);
        for (Field currentField : fields = info.getFields()) {
            StructFieldData fieldData = info.getFieldData(currentField.getName());
            if (fieldData == null) {
                throw new StructException("Field Data not found for field: " + currentField.getName());
            }
            int arrayLength = -1;
            boolean lengthedArray = false;
            try {
                if (info.isLenghtedArray(currentField)) {
                    Field f = info.getLenghtedArray(currentField.getName());
                    StructFieldData lengthMarker = info.getFieldData(f.getName());
                    arrayLength = lengthMarker.requiresGetterSetter() ? ((Number)lengthMarker.getGetter().invoke(obj, (Object[])null)).intValue() : ((Number)lengthMarker.getField().get(obj)).intValue();
                    lengthedArray = true;
                }
                if (fieldData.requiresGetterSetter()) {
                    Method getter = fieldData.getGetter();
                    Method setter = fieldData.getSetter();
                    if (getter == null || setter == null) {
                        throw new StructException(" getter/setter required for : " + currentField.getName());
                    }
                    if (lengthedArray && arrayLength >= 0) {
                        Object ret = Array.newInstance(currentField.getType().getComponentType(), arrayLength);
                        setter.invoke(obj, ret);
                        if (!currentField.getType().getComponentType().isPrimitive()) {
                            Object[] array = (Object[])ret;
                            for (int j = 0; j < arrayLength; ++j) {
                                array[j] = currentField.getType().getComponentType().newInstance();
                            }
                        }
                    }
                    if (!lengthedArray && currentField.getType().isArray() && getter.invoke(obj, (Object[])null) == null) {
                        throw new StructException("Arrays can not be null :" + currentField.getName());
                    }
                    this.readField(fieldData, getter, setter, obj);
                    continue;
                }
                if (lengthedArray && arrayLength >= 0) {
                    Object ret = Array.newInstance(currentField.getType().getComponentType(), arrayLength);
                    currentField.set(obj, ret);
                    if (!currentField.getType().getComponentType().isPrimitive()) {
                        Object[] array = (Object[])ret;
                        for (int j = 0; j < arrayLength; ++j) {
                            array[j] = currentField.getType().getComponentType().newInstance();
                        }
                    }
                }
                if (!lengthedArray && currentField.getType().isArray() && currentField.get(obj) == null) {
                    throw new StructException("Arrays can not be null. : " + currentField.getName());
                }
                if (lengthedArray && (!lengthedArray || arrayLength < 0)) continue;
                this.readField(fieldData, null, null, obj);
            }
            catch (Exception e) {
                throw new StructException(e);
            }
        }
    }

    @Override
    protected boolean readBoolean() throws IOException {
        return this.dataInput.readBoolean();
    }

    @Override
    protected byte readByte() throws IOException {
        return this.dataInput.readByte();
    }

    @Override
    protected short readShort() throws IOException {
        return this.dataInput.readShort();
    }

    @Override
    protected int readInt() throws IOException {
        return this.dataInput.readInt();
    }

    @Override
    protected long readLong() throws IOException {
        return this.dataInput.readLong();
    }

    @Override
    protected char readChar() throws IOException {
        return this.dataInput.readChar();
    }

    @Override
    protected float readFloat() throws IOException {
        return this.dataInput.readFloat();
    }

    @Override
    protected double readDouble() throws IOException {
        return this.dataInput.readDouble();
    }

    @Override
    protected void readBooleanArray(boolean[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.readBoolean();
        }
    }

    @Override
    protected void readByteArray(byte[] buffer) throws IOException {
        this.dataInput.readFully(buffer);
    }

    @Override
    protected void readCharArray(char[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.readChar();
        }
    }

    @Override
    protected void readShortArray(short[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.readShort();
        }
    }

    @Override
    protected void readIntArray(int[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.readInt();
        }
    }

    @Override
    protected void readLongArray(long[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.readLong();
        }
    }

    @Override
    protected void readFloatArray(float[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.readFloat();
        }
    }

    @Override
    protected void readDoubleArray(double[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.readDouble();
        }
    }

    @Override
    protected void readObjectArray(Object[] objects) throws IOException, StructException {
        for (int i = 0; i < objects.length; ++i) {
            this.readObject(objects[i]);
        }
    }
}

