/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="What type of device the user is on when in the live stream session.")
public class LiveStreamSessionDevice
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VENDOR = "vendor";
    @SerializedName(value="vendor")
    private String vendor;
    public static final String SERIALIZED_NAME_MODEL = "model";
    @SerializedName(value="model")
    private String model;

    public LiveStreamSessionDevice type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="desktop", value="What the type is like desktop, laptop, mobile.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LiveStreamSessionDevice vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Dell", value="If known, what the brand of the device is, like Apple, Dell, etc.")
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public LiveStreamSessionDevice model(String model) {
        this.model = model;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="unknown", value="The specific model of the device, if known.")
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStreamSessionDevice liveStreamSessionDevice = (LiveStreamSessionDevice)o;
        return Objects.equals(this.type, liveStreamSessionDevice.type) && Objects.equals(this.vendor, liveStreamSessionDevice.vendor) && Objects.equals(this.model, liveStreamSessionDevice.model);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.vendor, this.model);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStreamSessionDevice {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString(this.vendor)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

