/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv1;

import cloud.localstack.awssdkv1.PowerMockLocalStack;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.CreateKeyRequest;
import com.amazonaws.services.kms.model.CreateKeyResult;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@LocalstackDockerProperties(ignoreDockerRunErrors=true)
public class KMSTest
extends PowerMockLocalStack {
    private AWSKMS awskms;
    private String keyId = "";

    @Before
    public void mock() {
        PowerMockLocalStack.mockKMS();
        this.awskms = AWSKMSClientBuilder.defaultClient();
    }

    @Test
    public void createKeyTest() throws Exception {
        CreateKeyRequest request = new CreateKeyRequest().withDescription("test key");
        CreateKeyResult result = this.awskms.createKey(request);
        this.keyId = result.getKeyMetadata().getKeyId();
        Assert.assertNotNull((Object)this.keyId);
    }

    @Test
    public void stringEncriptionTest() throws Exception {
        if (this.keyId.isEmpty()) {
            this.createKeyTest();
        }
        String testMessage = "hey, this is a test of encryption";
        byte[] encodedMessage = this.encrypt(testMessage.getBytes());
        byte[] decodedMessage = this.decrypt(encodedMessage);
        String resultMessage = new String(decodedMessage);
        Assert.assertEquals((Object)testMessage, (Object)resultMessage);
    }

    public byte[] encrypt(byte[] input) {
        ByteBuffer buffer = ByteBuffer.wrap(input);
        EncryptResult result = this.awskms.encrypt(new EncryptRequest().withKeyId(this.keyId).withPlaintext(buffer));
        return result.getCiphertextBlob().array();
    }

    public byte[] decrypt(byte[] input) {
        ByteBuffer buffer = ByteBuffer.wrap(input);
        DecryptResult result = this.awskms.decrypt(new DecryptRequest().withCiphertextBlob(buffer));
        return result.getPlaintext().array();
    }
}

