/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.LocalTestUtilSDKV2;
import cloud.localstack.awssdkv2.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import cloud.localstack.sample.LambdaHandler;
import io.thundra.jexter.junit4.core.sysprop.SystemPropertySandboxRule;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.testcontainers.utility.ThrowingFunction;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.services.iam.model.CreateUserResponse;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;

@RunWith(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(ignoreDockerRunErrors=true)
public class BasicFeaturesSDKV2Test {
    @ClassRule
    public static SystemPropertySandboxRule systemPropertySandboxRule = new SystemPropertySandboxRule();

    @BeforeClass
    public static void beforeAll() {
        System.setProperty(SdkSystemSetting.CBOR_ENABLED.property(), "false");
    }

    @Test
    public void testCreateSqsQueueAsyncV2() throws Exception {
        SqsAsyncClient sqsAsyncClient = TestUtils.getClientSQSAsyncV2();
        BasicFeaturesSDKV2Test.validateCreateSqsQueueV2((ThrowingFunction<CreateQueueRequest, CreateQueueResponse>)((ThrowingFunction)createReq -> (CreateQueueResponse)sqsAsyncClient.createQueue(createReq).get()));
    }

    @Test
    public void testCreateSqsQueueV2() throws Exception {
        SqsClient sqsClient = TestUtils.getClientSQSV2();
        BasicFeaturesSDKV2Test.validateCreateSqsQueueV2((ThrowingFunction<CreateQueueRequest, CreateQueueResponse>)((ThrowingFunction)createReq -> sqsClient.createQueue(createReq)));
    }

    protected static void validateCreateSqsQueueV2(ThrowingFunction<CreateQueueRequest, CreateQueueResponse> createAction) throws Exception {
        String queueName = "test-q-" + UUID.randomUUID().toString();
        CreateQueueRequest request = (CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build();
        CreateQueueResponse queue = (CreateQueueResponse)createAction.apply((Object)request);
        Assert.assertTrue((boolean)queue.queueUrl().contains("000000000000/" + queueName));
    }

    @Test
    public void testCreateKinesisStreamAsyncV2() throws Exception {
        KinesisAsyncClient kinesisAsyncClient = TestUtils.getClientKinesisAsyncV2();
        BasicFeaturesSDKV2Test.validateCreateKinesisStreamV2((ThrowingFunction<CreateStreamRequest, CreateStreamResponse>)((ThrowingFunction)createReq -> (CreateStreamResponse)kinesisAsyncClient.createStream(createReq).get()));
    }

    @Test
    public void testCreateKinesisStreamV2() throws Exception {
        KinesisClient kinesisClient = TestUtils.getClientKinesisV2();
        BasicFeaturesSDKV2Test.validateCreateKinesisStreamV2((ThrowingFunction<CreateStreamRequest, CreateStreamResponse>)((ThrowingFunction)createReq -> kinesisClient.createStream(createReq)));
    }

    protected static void validateCreateKinesisStreamV2(ThrowingFunction<CreateStreamRequest, CreateStreamResponse> createAction) throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)createAction.apply((Object)request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCreateKinesisRecordAsyncV2() throws Exception {
        KinesisAsyncClient kinesisAsyncClient = TestUtils.getClientKinesisAsyncV2();
        BasicFeaturesSDKV2Test.validateCreateKinesisRecordV2((ThrowingFunction<CreateStreamRequest, CreateStreamResponse>)((ThrowingFunction)createReq -> (CreateStreamResponse)kinesisAsyncClient.createStream(createReq).get()), (ThrowingFunction<PutRecordRequest, PutRecordResponse>)((ThrowingFunction)putReq -> (PutRecordResponse)kinesisAsyncClient.putRecord(putReq).get()));
    }

    @Test
    public void testCreateKinesisRecordV2() throws Exception {
        KinesisClient kinesisClient = TestUtils.getClientKinesisV2();
        BasicFeaturesSDKV2Test.validateCreateKinesisRecordV2((ThrowingFunction<CreateStreamRequest, CreateStreamResponse>)((ThrowingFunction)createReq -> kinesisClient.createStream(createReq)), (ThrowingFunction<PutRecordRequest, PutRecordResponse>)((ThrowingFunction)putReq -> kinesisClient.putRecord(putReq)));
    }

    protected static void validateCreateKinesisRecordV2(ThrowingFunction<CreateStreamRequest, CreateStreamResponse> createAction, ThrowingFunction<PutRecordRequest, PutRecordResponse> putAction) throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)createAction.apply((Object)request);
        Assert.assertNotNull((Object)response);
        SdkBytes payload = SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(String.format("testData-%d", 1).getBytes()));
        PutRecordRequest.Builder putRecordRequest = PutRecordRequest.builder();
        putRecordRequest.streamName(streamName);
        putRecordRequest.data(payload);
        putRecordRequest.partitionKey(String.format("partitionKey-%d", 1));
        Assert.assertNotNull((Object)putAction.apply((Object)((PutRecordRequest)putRecordRequest.build())));
    }

    @Test
    public void testCreateDynamoDBTableAsync() throws Exception {
        DynamoDbAsyncClient dynamoDbAsyncClient = TestUtils.getClientDyanamoAsyncV2();
        BasicFeaturesSDKV2Test.validateCreateDynamoDBTable((ThrowingFunction<CreateTableRequest, CreateTableResponse>)((ThrowingFunction)createReq -> (CreateTableResponse)dynamoDbAsyncClient.createTable(createReq).get()), (ThrowingFunction<DeleteTableRequest, DeleteTableResponse>)((ThrowingFunction)deleteReq -> (DeleteTableResponse)dynamoDbAsyncClient.deleteTable(deleteReq).get()));
    }

    @Test
    public void testCreateDynamoDBTable() throws Exception {
        DynamoDbClient dynamoDbClient = TestUtils.getClientDyanamoV2();
        BasicFeaturesSDKV2Test.validateCreateDynamoDBTable((ThrowingFunction<CreateTableRequest, CreateTableResponse>)((ThrowingFunction)createReq -> dynamoDbClient.createTable(createReq)), (ThrowingFunction<DeleteTableRequest, DeleteTableResponse>)((ThrowingFunction)deleteReq -> dynamoDbClient.deleteTable(deleteReq)));
    }

    protected static void validateCreateDynamoDBTable(ThrowingFunction<CreateTableRequest, CreateTableResponse> createAction, ThrowingFunction<DeleteTableRequest, DeleteTableResponse> deleteAction) throws Exception {
        String tableName = "test-s-" + UUID.randomUUID().toString();
        CreateTableRequest createTableRequest = (CreateTableRequest)CreateTableRequest.builder().keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().keyType(KeyType.HASH).attributeName("test").build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("test").attributeType(ScalarAttributeType.S).build()}).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(5L)).writeCapacityUnits(Long.valueOf(5L)).build()).tableName(tableName).build();
        CreateTableResponse response = (CreateTableResponse)createAction.apply((Object)createTableRequest);
        Assert.assertNotNull((Object)response);
        deleteAction.apply((Object)((DeleteTableRequest)DeleteTableRequest.builder().tableName(tableName).build()));
    }

    @Test
    public void testS3CreateListBucketsAsync() throws Exception {
        S3AsyncClient s3AsyncClient = TestUtils.getClientS3AsyncV2();
        BasicFeaturesSDKV2Test.validateS3CreateListBuckets((ThrowingFunction<CreateBucketRequest, CreateBucketResponse>)((ThrowingFunction)createReq -> (CreateBucketResponse)s3AsyncClient.createBucket(createReq).get()), (ThrowingFunction<ListBucketsRequest, ListBucketsResponse>)((ThrowingFunction)listReq -> (ListBucketsResponse)s3AsyncClient.listBuckets(listReq).get()));
    }

    @Test
    public void testS3CreateListBuckets() throws Exception {
        S3Client s3Client = TestUtils.getClientS3V2();
        BasicFeaturesSDKV2Test.validateS3CreateListBuckets((ThrowingFunction<CreateBucketRequest, CreateBucketResponse>)((ThrowingFunction)createReq -> s3Client.createBucket(createReq)), (ThrowingFunction<ListBucketsRequest, ListBucketsResponse>)((ThrowingFunction)listReq -> s3Client.listBuckets(listReq)));
    }

    protected static void validateS3CreateListBuckets(ThrowingFunction<CreateBucketRequest, CreateBucketResponse> createAction, ThrowingFunction<ListBucketsRequest, ListBucketsResponse> listAction) throws Exception {
        String bucketName = "test-b-" + UUID.randomUUID().toString();
        CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
        CreateBucketResponse response = (CreateBucketResponse)createAction.apply((Object)request);
        Assert.assertNotNull((Object)response);
        ListBucketsRequest listRequest = (ListBucketsRequest)ListBucketsRequest.builder().build();
        ListBucketsResponse buckets = (ListBucketsResponse)listAction.apply((Object)listRequest);
        Bucket bucket = buckets.buckets().stream().filter(b -> b.name().equals(bucketName)).findFirst().get();
        Assert.assertNotNull((Object)bucket);
    }

    @Test
    public void testSendSNSMessageAsync() throws Exception {
        SnsAsyncClient snsAsyncClient = TestUtils.getClientSNSAsyncV2();
        this.validateSendSNSMessage((ThrowingFunction<CreateTopicRequest, CreateTopicResponse>)((ThrowingFunction)createReq -> (CreateTopicResponse)snsAsyncClient.createTopic(createReq).get()), (ThrowingFunction<PublishRequest, PublishResponse>)((ThrowingFunction)publishReq -> (PublishResponse)snsAsyncClient.publish(publishReq).get()));
    }

    @Test
    public void testSendSNSMessage() throws Exception {
        SnsClient snsClient = TestUtils.getClientSNSV2();
        this.validateSendSNSMessage((ThrowingFunction<CreateTopicRequest, CreateTopicResponse>)((ThrowingFunction)createReq -> snsClient.createTopic(createReq)), (ThrowingFunction<PublishRequest, PublishResponse>)((ThrowingFunction)publishReq -> snsClient.publish(publishReq)));
    }

    protected void validateSendSNSMessage(ThrowingFunction<CreateTopicRequest, CreateTopicResponse> createAction, ThrowingFunction<PublishRequest, PublishResponse> publishAction) throws Exception {
        String topicName = "test-t-" + UUID.randomUUID().toString();
        CreateTopicResponse createTopicResponse = (CreateTopicResponse)createAction.apply((Object)((CreateTopicRequest)CreateTopicRequest.builder().name(topicName).build()));
        String topicArn = createTopicResponse.topicArn();
        Assert.assertNotNull((Object)topicArn);
        PublishRequest publishRequest = (PublishRequest)PublishRequest.builder().topicArn(topicArn).subject("test subject").message("message test.").build();
        PublishResponse publishResponse = (PublishResponse)publishAction.apply((Object)publishRequest);
        Assert.assertNotNull((Object)publishResponse.messageId());
    }

    @Test
    public void testGetSsmParameterAsync() throws Exception {
        SsmAsyncClient ssmAsyncClient = TestUtils.getClientSSMAsyncV2();
        BasicFeaturesSDKV2Test.validateGetSsmParameter((ThrowingFunction<PutParameterRequest, PutParameterResponse>)((ThrowingFunction)putReq -> (PutParameterResponse)ssmAsyncClient.putParameter(putReq).get()), (ThrowingFunction<GetParameterRequest, GetParameterResponse>)((ThrowingFunction)getReq -> (GetParameterResponse)ssmAsyncClient.getParameter(getReq).get()));
    }

    @Test
    public void testGetSsmParameter() throws Exception {
        SsmClient ssmClient = TestUtils.getClientSSMV2();
        BasicFeaturesSDKV2Test.validateGetSsmParameter((ThrowingFunction<PutParameterRequest, PutParameterResponse>)((ThrowingFunction)putReq -> ssmClient.putParameter(putReq)), (ThrowingFunction<GetParameterRequest, GetParameterResponse>)((ThrowingFunction)getReq -> ssmClient.getParameter(getReq)));
    }

    protected static void validateGetSsmParameter(ThrowingFunction<PutParameterRequest, PutParameterResponse> putAction, ThrowingFunction<GetParameterRequest, GetParameterResponse> getAction) throws Exception {
        String paramName = "param-" + UUID.randomUUID().toString();
        putAction.apply((Object)((PutParameterRequest)PutParameterRequest.builder().name(paramName).value("testvalue").build()));
        GetParameterResponse getParameterResponse = (GetParameterResponse)getAction.apply((Object)((GetParameterRequest)GetParameterRequest.builder().name(paramName).build()));
        String parameterValue = getParameterResponse.parameter().value();
        Assert.assertNotNull((Object)parameterValue);
        Assert.assertEquals((Object)"testvalue", (Object)parameterValue);
    }

    @Test
    public void testGetSecretsManagerSecretAsync() throws Exception {
        SecretsManagerAsyncClient secretsManagerAsync = TestUtils.getClientSecretsManagerAsyncV2();
        BasicFeaturesSDKV2Test.validateGetSecretsManagerSecret((ThrowingFunction<CreateSecretRequest, CreateSecretResponse>)((ThrowingFunction)createReq -> (CreateSecretResponse)secretsManagerAsync.createSecret(createReq).get()), (ThrowingFunction<GetSecretValueRequest, GetSecretValueResponse>)((ThrowingFunction)getReq -> (GetSecretValueResponse)secretsManagerAsync.getSecretValue(getReq).get()), (ThrowingFunction<DeleteSecretRequest, DeleteSecretResponse>)((ThrowingFunction)delReq -> (DeleteSecretResponse)secretsManagerAsync.deleteSecret(delReq).get()));
    }

    @Test
    public void testGetSecretsManagerSecret() throws Exception {
        SecretsManagerClient secretsManager = TestUtils.getClientSecretsManagerV2();
        BasicFeaturesSDKV2Test.validateGetSecretsManagerSecret((ThrowingFunction<CreateSecretRequest, CreateSecretResponse>)((ThrowingFunction)createReq -> secretsManager.createSecret(createReq)), (ThrowingFunction<GetSecretValueRequest, GetSecretValueResponse>)((ThrowingFunction)getReq -> secretsManager.getSecretValue(getReq)), (ThrowingFunction<DeleteSecretRequest, DeleteSecretResponse>)((ThrowingFunction)delReq -> secretsManager.deleteSecret(delReq)));
    }

    protected static void validateGetSecretsManagerSecret(ThrowingFunction<CreateSecretRequest, CreateSecretResponse> createAction, ThrowingFunction<GetSecretValueRequest, GetSecretValueResponse> getAction, ThrowingFunction<DeleteSecretRequest, DeleteSecretResponse> deleteAction) throws Exception {
        String secretName = "test-s-" + UUID.randomUUID().toString();
        createAction.apply((Object)((CreateSecretRequest)CreateSecretRequest.builder().name(secretName).secretString("secretcontent").build()));
        GetSecretValueResponse getSecretResponse = (GetSecretValueResponse)getAction.apply((Object)((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build()));
        String secretValue = getSecretResponse.secretString();
        Assert.assertNotNull((Object)secretValue);
        Assert.assertEquals((Object)"secretcontent", (Object)secretValue);
        deleteAction.apply((Object)((DeleteSecretRequest)DeleteSecretRequest.builder().secretId(secretName).build()));
    }

    @Test
    public void testGetSecretAsParamAsync() throws Exception {
        SsmAsyncClient ssmAsyncClient = TestUtils.getClientSSMAsyncV2();
        SecretsManagerAsyncClient secretsManagerAsyncClient = TestUtils.getClientSecretsManagerAsyncV2();
        BasicFeaturesSDKV2Test.validateGetSecretAsParam((ThrowingFunction<CreateSecretRequest, CreateSecretResponse>)((ThrowingFunction)createReq -> (CreateSecretResponse)secretsManagerAsyncClient.createSecret(createReq).get()), (ThrowingFunction<GetParameterRequest, GetParameterResponse>)((ThrowingFunction)getReq -> (GetParameterResponse)ssmAsyncClient.getParameter(getReq).get()), (ThrowingFunction<DeleteSecretRequest, DeleteSecretResponse>)((ThrowingFunction)delReq -> (DeleteSecretResponse)secretsManagerAsyncClient.deleteSecret(delReq).get()));
    }

    @Test
    public void testGetSecretAsParam() throws Exception {
        SsmClient ssmClient = TestUtils.getClientSSMV2();
        SecretsManagerClient secretsManagerClient = TestUtils.getClientSecretsManagerV2();
        BasicFeaturesSDKV2Test.validateGetSecretAsParam((ThrowingFunction<CreateSecretRequest, CreateSecretResponse>)((ThrowingFunction)createReq -> secretsManagerClient.createSecret(createReq)), (ThrowingFunction<GetParameterRequest, GetParameterResponse>)((ThrowingFunction)getReq -> ssmClient.getParameter(getReq)), (ThrowingFunction<DeleteSecretRequest, DeleteSecretResponse>)((ThrowingFunction)delReq -> secretsManagerClient.deleteSecret(delReq)));
    }

    protected static void validateGetSecretAsParam(ThrowingFunction<CreateSecretRequest, CreateSecretResponse> createAction, ThrowingFunction<GetParameterRequest, GetParameterResponse> getAction, ThrowingFunction<DeleteSecretRequest, DeleteSecretResponse> delAction) throws Exception {
        String secretName = "test-s-" + UUID.randomUUID().toString();
        createAction.apply((Object)((CreateSecretRequest)CreateSecretRequest.builder().name(secretName).secretString("secretcontent").build()));
        GetParameterResponse getParameterResponse = (GetParameterResponse)getAction.apply((Object)((GetParameterRequest)GetParameterRequest.builder().name("/aws/reference/secretsmanager/" + secretName).build()));
        String parameterValue = getParameterResponse.parameter().value();
        Assert.assertNotNull((Object)parameterValue);
        Assert.assertEquals((Object)"secretcontent", (Object)parameterValue);
        delAction.apply((Object)((DeleteSecretRequest)DeleteSecretRequest.builder().secretId(secretName).build()));
    }

    @Test
    public void testCWPutMetricsAsync() throws Exception {
        CloudWatchAsyncClient cwClientAsync = TestUtils.getClientCloudWatchAsyncV2();
        BasicFeaturesSDKV2Test.validateCWPutMetrics((ThrowingFunction<PutMetricDataRequest, PutMetricDataResponse>)((ThrowingFunction)putReq -> (PutMetricDataResponse)cwClientAsync.putMetricData(putReq).get()));
    }

    @Test
    public void testCWPutMetrics() throws Exception {
        CloudWatchClient cwClient = TestUtils.getClientCloudWatchV2();
        BasicFeaturesSDKV2Test.validateCWPutMetrics((ThrowingFunction<PutMetricDataRequest, PutMetricDataResponse>)((ThrowingFunction)putReq -> cwClient.putMetricData(putReq)));
    }

    protected static void validateCWPutMetrics(ThrowingFunction<PutMetricDataRequest, PutMetricDataResponse> putAction) throws Exception {
        Dimension dimension = (Dimension)Dimension.builder().name("UNIQUE_PAGES").value("URLS").build();
        String time = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Instant instant = Instant.parse(time);
        double dataPoint = 1.23423;
        MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName("PAGES_VISITED").unit(StandardUnit.NONE).value(Double.valueOf(dataPoint)).timestamp(instant).dimensions(new Dimension[]{dimension}).build();
        PutMetricDataRequest request = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace("SITE/TRAFFIC").metricData(new MetricDatum[]{datum}).build();
        PutMetricDataResponse response = (PutMetricDataResponse)putAction.apply((Object)request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCWMultipleDimentionsAndMetricsAsync() throws Exception {
        CloudWatchAsyncClient clientCWAsync = TestUtils.getClientCloudWatchAsyncV2();
        BasicFeaturesSDKV2Test.validateCWMultipleDimentionsAndMetrics((ThrowingFunction<PutMetricDataRequest, PutMetricDataResponse>)((ThrowingFunction)putReq -> (PutMetricDataResponse)clientCWAsync.putMetricData(putReq).get()));
    }

    @Test
    public void testCWMultipleDimentionsAndMetrics() throws Exception {
        CloudWatchClient clientCW = TestUtils.getClientCloudWatchV2();
        BasicFeaturesSDKV2Test.validateCWMultipleDimentionsAndMetrics((ThrowingFunction<PutMetricDataRequest, PutMetricDataResponse>)((ThrowingFunction)putReq -> clientCW.putMetricData(putReq)));
    }

    protected static void validateCWMultipleDimentionsAndMetrics(ThrowingFunction<PutMetricDataRequest, PutMetricDataResponse> putAction) throws Exception {
        ArrayList<Dimension> awsDimensionList = new ArrayList<Dimension>();
        for (int i = 0; i < 10; ++i) {
            awsDimensionList.add((Dimension)Dimension.builder().name("UNIQUE_PAGES" + i).value("URLS" + i).build());
        }
        String time = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Instant instant = Instant.parse(time);
        double dataPoint = 1.23423;
        ArrayList<MetricDatum> metrics = new ArrayList<MetricDatum>();
        for (int i = 0; i < 20; ++i) {
            metrics.add((MetricDatum)MetricDatum.builder().metricName("PAGES_VISITED").unit(StandardUnit.NONE).value(Double.valueOf(dataPoint)).timestamp(instant).dimensions(awsDimensionList).build());
        }
        PutMetricDataRequest request = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace("SITE/TRAFFIC").metricData(metrics).build();
        PutMetricDataResponse response = (PutMetricDataResponse)putAction.apply((Object)request);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testLambdaCreateListFunctionsAsync() throws Exception {
        LambdaAsyncClient lambdaClientAsync = TestUtils.getClientLambdaAsyncV2();
        BasicFeaturesSDKV2Test.validateLambdaCreateListFunctions((ThrowingFunction<CreateFunctionRequest, CreateFunctionResponse>)((ThrowingFunction)createReq -> (CreateFunctionResponse)lambdaClientAsync.createFunction(createReq).get()), (ThrowingFunction<Void, ListFunctionsResponse>)((ThrowingFunction)x -> (ListFunctionsResponse)lambdaClientAsync.listFunctions().get()));
    }

    @Test
    public void testLambdaCreateListFunctions() throws Exception {
        LambdaClient lambdaClient = TestUtils.getClientLambdaV2();
        BasicFeaturesSDKV2Test.validateLambdaCreateListFunctions((ThrowingFunction<CreateFunctionRequest, CreateFunctionResponse>)((ThrowingFunction)createReq -> lambdaClient.createFunction(createReq)), (ThrowingFunction<Void, ListFunctionsResponse>)((ThrowingFunction)x -> lambdaClient.listFunctions()));
    }

    protected static void validateLambdaCreateListFunctions(ThrowingFunction<CreateFunctionRequest, CreateFunctionResponse> createAction, ThrowingFunction<Void, ListFunctionsResponse> listAction) throws Exception {
        String functionName = "test-f-" + UUID.randomUUID().toString();
        CreateFunctionRequest createFunctionRequest = (CreateFunctionRequest)CreateFunctionRequest.builder().functionName(functionName).runtime(Runtime.JAVA8).role("r1").code(LocalTestUtilSDKV2.createFunctionCode(LambdaHandler.class)).handler(LambdaHandler.class.getName()).build();
        CreateFunctionResponse response = (CreateFunctionResponse)createAction.apply((Object)createFunctionRequest);
        Assert.assertNotNull((Object)response);
        ListFunctionsResponse functions = (ListFunctionsResponse)listAction.apply(null);
        FunctionConfiguration function = functions.functions().stream().filter(f -> f.functionName().equals(functionName)).findFirst().get();
        Assert.assertNotNull((Object)function);
    }

    @Test
    public void testIAMUserCreationAsync() throws Exception {
        IamAsyncClient iamClientAsync = TestUtils.getClientIamAsyncV2();
        BasicFeaturesSDKV2Test.validateIAMUserCreation((ThrowingFunction<CreateUserRequest, CreateUserResponse>)((ThrowingFunction)createReq -> (CreateUserResponse)iamClientAsync.createUser(createReq).get()), (ThrowingFunction<Void, ListUsersResponse>)((ThrowingFunction)x -> (ListUsersResponse)iamClientAsync.listUsers().get()));
    }

    @Test
    public void testIAMUserCreation() throws Exception {
        IamClient iamClient = TestUtils.getClientIamV2();
        BasicFeaturesSDKV2Test.validateIAMUserCreation((ThrowingFunction<CreateUserRequest, CreateUserResponse>)((ThrowingFunction)createReq -> iamClient.createUser(createReq)), (ThrowingFunction<Void, ListUsersResponse>)((ThrowingFunction)x -> iamClient.listUsers()));
    }

    protected static void validateIAMUserCreation(ThrowingFunction<CreateUserRequest, CreateUserResponse> createAction, ThrowingFunction<Void, ListUsersResponse> listAction) throws Exception {
        String username = UUID.randomUUID().toString();
        CreateUserRequest createUserRequest = (CreateUserRequest)CreateUserRequest.builder().userName(username).build();
        createAction.apply((Object)createUserRequest);
        boolean userFound = false;
        List users = ((ListUsersResponse)listAction.apply(null)).users();
        for (int i = 0; i < users.size(); ++i) {
            if (!((User)users.get(i)).userName().equals(username)) continue;
            userFound = true;
            break;
        }
        Assert.assertTrue((boolean)userFound);
    }

    @Test
    public void testIAMListUserPaginationAsync() throws Exception {
        IamAsyncClient iamClient = TestUtils.getClientIamAsyncV2();
        String username = UUID.randomUUID().toString();
        CreateUserRequest createUserRequest = (CreateUserRequest)CreateUserRequest.builder().userName(username).build();
        iamClient.createUser(createUserRequest).join();
        AtomicBoolean userFound = new AtomicBoolean(false);
        iamClient.listUsersPaginator().users().subscribe(user -> {
            if (user.userName().equals(username)) {
                userFound.set(true);
            }
        });
        TimeUnit.SECONDS.sleep(2L);
        Assert.assertTrue((boolean)userFound.get());
    }
}

