/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.docker.Container;
import cloud.localstack.docker.DockerExe;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class ContainerTest {
    public static final String EXTERNAL_HOST_NAME = "localhost";
    public static final String MY_PROPERTY = "MY_PROPERTY";
    public static final String MY_VALUE = "MyValue";
    public static final boolean pullNewImage = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.jupiter.api.Test
    @Test
    public void createLocalstackContainer() throws Exception {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put(MY_PROPERTY, MY_VALUE);
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, null, null, null, null, environmentVariables, null, null, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            ArrayList<String> echoDefaultEnv = this.buildEchoStatement("HOSTNAME_EXTERNAL");
            ArrayList<String> echoExternalEnv = this.buildEchoStatement(MY_PROPERTY);
            Assert.assertEquals((Object)EXTERNAL_HOST_NAME, (Object)localStackContainer.executeCommand(echoDefaultEnv));
            Assert.assertEquals((Object)MY_VALUE, (Object)localStackContainer.executeCommand(echoExternalEnv));
            Assert.assertEquals((long)4566L, (long)localStackContainer.getExternalPortFor(4566));
            Assert.assertEquals((long)4571L, (long)localStackContainer.getExternalPortFor(4571));
        }
        finally {
            localStackContainer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.jupiter.api.Test
    @Test
    public void createLocalstackContainerWithFullImage() {
        String customImageName = "localstack/localstack-full";
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, (String)customImageName, null, null, null, null, null, null, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            String imageName = new DockerExe().execute(Arrays.asList("container", "inspect", localStackContainer.getContainerId(), "--format", "{{.Config.Image}}"));
            Assert.assertEquals((Object)customImageName, (Object)imageName);
        }
        finally {
            localStackContainer.stop();
        }
    }

    @org.junit.jupiter.api.Test
    @Test
    public void createLocalstackContainerWithScriptMounted() {
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, null, null, null, null, null, null, Collections.singletonMap(ContainerTest.testFile("echo testmarker"), "/docker-entrypoint-initaws.d/test.sh"), null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            localStackContainer.waitForLogToken(Pattern.compile("testmarker"));
            Assert.assertEquals((Object)"echo testmarker", (Object)localStackContainer.executeCommand(Arrays.asList("cat", "/docker-entrypoint-initaws.d/test.sh")));
        }
        finally {
            localStackContainer.stop();
        }
    }

    static String testFile(String content) {
        try {
            File testFile = File.createTempFile("localstack", ".sh");
            FileUtils.writeStringToFile((File)testFile, (String)content, (Charset)StandardCharsets.UTF_8);
            testFile.deleteOnExit();
            return testFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @org.junit.jupiter.api.Test
    @Test
    public void createLocalstackContainerWithCustomPorts() throws Exception {
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, null, null, (String)"45660", (String)"45710", null, null, null, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            Assert.assertEquals((long)45660L, (long)localStackContainer.getExternalPortFor(4566));
            Assert.assertEquals((long)45710L, (long)localStackContainer.getExternalPortFor(4571));
        }
        finally {
            localStackContainer.stop();
        }
    }

    @org.junit.jupiter.api.Test
    @Test
    public void createLocalstackContainerWithRandomPorts() throws Exception {
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, null, null, (String)":4566", (String)":4571", null, null, null, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            Assert.assertNotEquals((long)4566L, (long)localStackContainer.getExternalPortFor(4566));
            Assert.assertNotEquals((long)4571L, (long)localStackContainer.getExternalPortFor(4571));
        }
        finally {
            localStackContainer.stop();
        }
    }

    private ArrayList<String> buildEchoStatement(String valueToEcho) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("bash");
        args.add("-c");
        args.add(String.format("echo $%s", valueToEcho));
        return args;
    }
}

