/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv1;

import cloud.localstack.Localstack;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.AmazonKinesisAsyncClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.AWSLambdaAsyncClientBuilder;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsync;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsyncClientBuilder;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSAsyncClientBuilder;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;

public class TestUtils {
    public static final AWSCredentials TEST_CREDENTIALS = new BasicAWSCredentials("test", "test");

    public static AmazonSQS getClientSQS() {
        return TestUtils.getClientSQS(null);
    }

    public static AmazonSQS getClientSQS(String endpoint) {
        endpoint = endpoint == null ? Localstack.INSTANCE.getEndpointSQS() : endpoint;
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfiguration(endpoint))).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSQSAsync getClientSQSAsync() {
        return (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSQS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSQSAsync getClientSQSAsync(ExecutorFactory executorFactory) {
        return (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSQS())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSimpleEmailService getClientSES() {
        return (AmazonSimpleEmailService)((AmazonSimpleEmailServiceClientBuilder)((AmazonSimpleEmailServiceClientBuilder)AmazonSimpleEmailServiceClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSimpleEmailServiceAsync getClientSESAsync() {
        return (AmazonSimpleEmailServiceAsync)((AmazonSimpleEmailServiceAsyncClientBuilder)((AmazonSimpleEmailServiceAsyncClientBuilder)AmazonSimpleEmailServiceAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSNS getClientSNS() {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSNSAsync getClientSNSAsync() {
        return (AmazonSNSAsync)((AmazonSNSAsyncClientBuilder)((AmazonSNSAsyncClientBuilder)AmazonSNSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSNSAsync getClientSNSAsync(ExecutorFactory executorFactory) {
        return (AmazonSNSAsync)((AmazonSNSAsyncClientBuilder)((AmazonSNSAsyncClientBuilder)((AmazonSNSAsyncClientBuilder)AmazonSNSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambda getClientLambda() {
        return (AWSLambda)((AWSLambdaClientBuilder)((AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationLambda())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambdaAsync getClientLambdaAsync() {
        return (AWSLambdaAsync)((AWSLambdaAsyncClientBuilder)((AWSLambdaAsyncClientBuilder)AWSLambdaAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationLambda())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambdaAsync getClientLambdaAsync(ExecutorFactory executorFactory) {
        return (AWSLambdaAsync)((AWSLambdaAsyncClientBuilder)((AWSLambdaAsyncClientBuilder)((AWSLambdaAsyncClientBuilder)AWSLambdaAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationLambda())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonS3 getClientS3() {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationS3())).withCredentials(TestUtils.getCredentialsProvider());
        builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        return (AmazonS3)builder.build();
    }

    public static AWSSecretsManager getClientSecretsManager() {
        return (AWSSecretsManager)((AWSSecretsManagerClientBuilder)((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSecretsManager())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonDynamoDB getClientDynamoDB() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationDynamoDB())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonDynamoDBStreams getClientDynamoDBStreams() {
        return (AmazonDynamoDBStreams)((AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationDynamoDBStreams())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonKinesis getClientKinesis() {
        return (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationKinesis())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonKinesisAsync getClientKinesisAsync() {
        return (AmazonKinesisAsync)((AmazonKinesisAsyncClientBuilder)((AmazonKinesisAsyncClientBuilder)AmazonKinesisAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationKinesis())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonKinesisAsync getClientKinesisAsync(ExecutorFactory executorFactory) {
        return (AmazonKinesisAsync)((AmazonKinesisAsyncClientBuilder)((AmazonKinesisAsyncClientBuilder)((AmazonKinesisAsyncClientBuilder)AmazonKinesisAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationKinesis())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonCloudWatch getClientCloudWatch() {
        return (AmazonCloudWatch)((AmazonCloudWatchClientBuilder)((AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationCloudWatch())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLogs getClientCloudWatchLogs() {
        return (AWSLogs)((AWSLogsClientBuilder)((AWSLogsClientBuilder)AWSLogsClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationCloudWatchLogs())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonIdentityManagement getClientIAM() {
        return (AmazonIdentityManagement)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationIAM())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationIAM() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointIAM());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationLambda() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointLambda());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationKinesis() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointKinesis());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationDynamoDB() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointDynamoDB());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationDynamoDBStreams() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointDynamoDBStreams());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSQS() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointSQS());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationS3() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointS3());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSNS() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointSNS());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationCloudWatch() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointCloudWatch());
    }

    private static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationCloudWatchLogs() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointCloudWatchLogs());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSecretsManager() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointSecretsmanager());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationStepFunctions() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointStepFunctions());
    }

    public static AWSCredentialsProvider getCredentialsProvider() {
        return new AWSStaticCredentialsProvider(TEST_CREDENTIALS);
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(String endpointURL) {
        return new AwsClientBuilder.EndpointConfiguration(endpointURL, "us-east-1");
    }
}

