/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.bytefish.fcmjava.client.exceptions.SerializationException;
import de.bytefish.fcmjava.client.serializer.IJsonSerializer;

public class JsonSerializer
implements IJsonSerializer {
    private final ObjectMapper objectMapper;

    public JsonSerializer() {
        this(new ObjectMapper());
    }

    public JsonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <TModel> String serialize(TModel model) {
        try {
            return this.objectMapper.writeValueAsString(model);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public <TModel> TModel deserialize(String content, Class<TModel> type) {
        try {
            return (TModel)this.objectMapper.readValue(content, type);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }
}

