/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.http.apache;

import de.bytefish.fcmjava.client.http.IHttpClient;
import de.bytefish.fcmjava.client.http.apache.utils.RetryHeaderUtils;
import de.bytefish.fcmjava.client.serializer.IJsonSerializer;
import de.bytefish.fcmjava.client.serializer.JsonSerializer;
import de.bytefish.fcmjava.client.utils.OutParameter;
import de.bytefish.fcmjava.exceptions.FcmAuthenticationException;
import de.bytefish.fcmjava.exceptions.FcmBadRequestException;
import de.bytefish.fcmjava.exceptions.FcmGeneralException;
import de.bytefish.fcmjava.exceptions.FcmRetryAfterException;
import de.bytefish.fcmjava.http.exceptions.HttpCommunicationException;
import de.bytefish.fcmjava.http.options.IFcmClientSettings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class DefaultHttpClient
implements IHttpClient {
    private final IFcmClientSettings settings;
    private final IJsonSerializer serializer;
    private final CloseableHttpClient client;

    public DefaultHttpClient(IFcmClientSettings settings) {
        this(settings, HttpClientBuilder.create());
    }

    public DefaultHttpClient(IFcmClientSettings settings, HttpClientBuilder httpClientBuilder) {
        this(settings, new JsonSerializer(), httpClientBuilder);
    }

    public DefaultHttpClient(IFcmClientSettings settings, IJsonSerializer serializer) {
        this(settings, serializer, HttpClientBuilder.create());
    }

    public DefaultHttpClient(IFcmClientSettings settings, IJsonSerializer serializer, HttpClientBuilder httpClientBuilder) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        if (httpClientBuilder == null) {
            throw new IllegalArgumentException("httpClientBuilder");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer");
        }
        this.settings = settings;
        this.serializer = serializer;
        this.client = httpClientBuilder.build();
    }

    private <TRequestMessage> void internalPost(TRequestMessage requestMessage) throws IOException {
        try (CloseableHttpResponse response = this.client.execute(this.buildPostRequest(requestMessage));){
            this.evaluateResponse((HttpResponse)response);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
    }

    private <TRequestMessage, TResponseMessage> TResponseMessage internalPost(TRequestMessage requestMessage, Class<TResponseMessage> responseType) throws IOException {
        try (CloseableHttpResponse response = this.client.execute(this.buildPostRequest(requestMessage));){
            this.evaluateResponse((HttpResponse)response);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                TResponseMessage TResponseMessage = null;
                return TResponseMessage;
            }
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
            TResponseMessage TResponseMessage = this.serializer.deserialize(responseBody, responseType);
            return TResponseMessage;
        }
    }

    private <TRequestMessage> HttpUriRequest buildPostRequest(TRequestMessage requestMessage) {
        String content = this.serializer.serialize(requestMessage);
        return RequestBuilder.post((String)this.settings.getFcmUrl()).addHeader("Authorization", String.format("key=%s", this.settings.getApiKey())).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(content, StandardCharsets.UTF_8)).build();
    }

    private void evaluateResponse(HttpResponse httpResponse) {
        OutParameter<Duration> result;
        if (httpResponse == null) {
            return;
        }
        if (httpResponse.getStatusLine() == null) {
            return;
        }
        int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
        if (httpStatusCode == 200) {
            return;
        }
        String reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
        if (httpStatusCode == 400) {
            throw new FcmBadRequestException(reasonPhrase);
        }
        if (httpStatusCode == 401) {
            throw new FcmAuthenticationException(reasonPhrase);
        }
        if (httpStatusCode >= 500 && httpStatusCode < 600 && RetryHeaderUtils.tryDetermineRetryDelay(httpResponse, result = new OutParameter<Duration>())) {
            throw new FcmRetryAfterException(httpStatusCode, reasonPhrase, result.get());
        }
        throw new FcmGeneralException(httpStatusCode, reasonPhrase);
    }

    @Override
    public <TRequestMessage> void post(TRequestMessage requestMessage) {
        try {
            this.internalPost(requestMessage);
        }
        catch (IOException e) {
            throw new HttpCommunicationException("Error making POST Request", (Throwable)e);
        }
    }

    @Override
    public <TRequestMessage, TResponseMessage> TResponseMessage post(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            return this.internalPost(requestMessage, responseType);
        }
        catch (IOException e) {
            throw new HttpCommunicationException("Error making POST Request", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

