/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.css;

import com.steadystate.css.parser.Token;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.AtRule;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.EOFToken;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.QualifiedRule;
import dev.amp.validator.css.Rule;
import dev.amp.validator.css.TokenStream;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.utils.CssSpecUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class Canonicalizer {
    private static final int K_MAXIMUM_CSS_RECURSION = 100;
    @Nonnull
    private final Map<String, CssSpecUtils.BlockType> atRuleSpec;
    @Nonnull
    private final CssSpecUtils.BlockType defaultAtRuleSpec;

    public Canonicalizer(@Nonnull Map<String, CssSpecUtils.BlockType> atRuleSpec, @Nonnull CssSpecUtils.BlockType defaultSpec) {
        this.atRuleSpec = atRuleSpec;
        this.defaultAtRuleSpec = defaultSpec;
    }

    public List<Rule> parseAListOfRules(@Nonnull List<Token> tokenList, boolean topLevel, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        TokenStream tokenStream = new TokenStream(tokenList);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        while (true) {
            tokenStream.consume();
            TokenType current = CssTokenUtil.getTokenType(tokenStream.current());
            if (current == TokenType.WHITESPACE) continue;
            if (current == TokenType.EOF_TOKEN) {
                return rules;
            }
            if (current == TokenType.CDO || current == TokenType.CDC) {
                if (topLevel) continue;
                this.parseAQualifiedRule(tokenStream, rules, errors);
                continue;
            }
            if (current == TokenType.AT_KEYWORD) {
                rules.add(this.parseAnAtRule(tokenStream, errors));
                continue;
            }
            this.parseAQualifiedRule(tokenStream, rules, errors);
        }
    }

    private AtRule parseAnAtRule(@Nonnull TokenStream tokenStream, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.AT_KEYWORD) {
            throw new CssValidationException("Internal Error: parseAnAtRule precondition not met");
        }
        Token startToken = tokenStream.current();
        AtRule rule = new AtRule(startToken.toString());
        CssTokenUtil.copyPosTo(startToken, rule);
        while (true) {
            tokenStream.consume();
            TokenType current = CssTokenUtil.getTokenType(tokenStream.current());
            if (current == TokenType.SEMICOLON || current == TokenType.EOF_TOKEN) {
                rule.getPrelude().add(tokenStream.current());
                return rule;
            }
            if (current == TokenType.OPEN_CURLY) {
                rule.getPrelude().add(CssTokenUtil.copyPosTo(tokenStream.current(), new EOFToken()));
                List<Token> contents = this.extractASimpleBlock(tokenStream, errors);
                switch (this.blockTypeFor(rule)) {
                    case PARSE_AS_RULES: {
                        rule.setRules(this.parseAListOfRules(contents, false, errors));
                        break;
                    }
                    case PARSE_AS_DECLARATIONS: {
                        rule.setDeclarations(this.parseAListOfDeclarations(contents, errors));
                        break;
                    }
                    case PARSE_AS_IGNORE: {
                        break;
                    }
                    default: {
                        throw new CssValidationException("Unrecognized blockType " + this.blockTypeFor(rule));
                    }
                }
                return rule;
            }
            if (Canonicalizer.consumeAComponentValue(tokenStream, rule.getPrelude(), 0)) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            errors.add((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_EXCESSIVELY_NESTED, params)));
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<Declaration> parseAListOfDeclarations(@Nonnull List<Token> tokenList, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        decls = new ArrayList<Declaration>();
        tokenStream = new TokenStream(tokenList);
        block0: while (true) {
            tokenStream.consume();
            current = CssTokenUtil.getTokenType(tokenStream.current());
            if (current == TokenType.WHITESPACE || current == TokenType.SEMICOLON) continue;
            if (current == TokenType.EOF_TOKEN) {
                return decls;
            }
            if (current == TokenType.AT_KEYWORD) {
                atRule = this.parseAnAtRule(tokenStream, errors);
                params = new ArrayList<String>();
                params.add("style");
                params.add(atRule.getName());
                errors.add((ErrorToken)CssTokenUtil.copyPosTo(atRule, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_AT_RULE, params)));
                continue;
            }
            if (current == TokenType.IDENT) {
                this.parseADeclaration(tokenStream, decls, errors);
                continue;
            }
            params = new ArrayList<String>();
            params.add("style");
            errors.add((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_DECLARATION, params)));
            tokenStream.reconsume();
            while (true) {
                if (CssTokenUtil.getTokenType(tokenStream.next()) != TokenType.SEMICOLON && CssTokenUtil.getTokenType(tokenStream.next()) != TokenType.EOF_TOKEN) ** break;
                continue block0;
                tokenStream.consume();
                dummyTokenList = new ArrayList<Token>();
                if (Canonicalizer.consumeAComponentValue(tokenStream, dummyTokenList, 0)) continue;
                errors.add((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_EXCESSIVELY_NESTED, params)));
            }
            break;
        }
    }

    public void parseADeclaration(@Nonnull TokenStream tokenStream, @Nonnull List<Declaration> declarations, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.IDENT) {
            throw new CssValidationException("Internal Error: parseADeclaration precondition not met");
        }
        Token startToken = tokenStream.current();
        Declaration decl = (Declaration)CssTokenUtil.copyPosTo(startToken, new Declaration(startToken.toString()));
        while (CssTokenUtil.getTokenType(tokenStream.next()) == TokenType.WHITESPACE) {
            tokenStream.consume();
        }
        tokenStream.consume();
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.COLON) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            errors.add((ErrorToken)CssTokenUtil.copyPosTo(startToken, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INCOMPLETE_DECLARATION, params)));
            tokenStream.reconsume();
            while (CssTokenUtil.getTokenType(tokenStream.next()) != TokenType.SEMICOLON && CssTokenUtil.getTokenType(tokenStream.next()) != TokenType.EOF_TOKEN) {
                tokenStream.consume();
            }
            return;
        }
        block2: while (CssTokenUtil.getTokenType(tokenStream.next()) != TokenType.SEMICOLON && CssTokenUtil.getTokenType(tokenStream.next()) != TokenType.EOF_TOKEN) {
            tokenStream.consume();
            if (!Canonicalizer.consumeAComponentValue(tokenStream, (List<Token>)decl.getValue(), 0)) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("style");
                errors.add((ErrorToken)CssTokenUtil.copyPosTo(startToken, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_EXCESSIVELY_NESTED, params)));
            }
            decl.getValue().add(CssTokenUtil.copyPosTo(tokenStream.next(), new EOFToken()));
            boolean foundImportant = false;
            for (int i = decl.getValue().size() - 1; i >= 0; --i) {
                if (CssTokenUtil.getTokenType((Token)decl.getValue().get(i)) == TokenType.WHITESPACE) continue;
                if (CssTokenUtil.getTokenType((Token)decl.getValue().get(i)) == TokenType.IDENT && CssSpecUtils.asciiMatch((Token)decl.getValue().get(i), "important")) {
                    foundImportant = true;
                    continue;
                }
                if (!foundImportant || CssTokenUtil.getTokenType((Token)decl.getValue().get(i)) != TokenType.DELIM || !((Token)decl.getValue().get(i)).getValue().equals("!")) continue block2;
                decl.getValue().subList(i, decl.getValue().size()).clear();
                decl.setImportant(true);
                continue block2;
            }
        }
        declarations.add(decl);
    }

    private CssSpecUtils.BlockType blockTypeFor(@Nonnull AtRule atRule) {
        CssSpecUtils.BlockType maybeBlockType = this.atRuleSpec.get(CssSpecUtils.stripVendorPrefix(atRule.getName()));
        if (maybeBlockType != null) {
            return maybeBlockType;
        }
        return this.defaultAtRuleSpec;
    }

    private List<Token> extractASimpleBlock(@Nonnull TokenStream tokenStream, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        ArrayList<Token> consumedTokens = new ArrayList<Token>();
        if (!Canonicalizer.consumeASimpleBlock(tokenStream, consumedTokens, 0)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            errors.add((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_EXCESSIVELY_NESTED, params)));
        }
        if (consumedTokens.size() < 2) {
            throw new CssValidationException("size of consumedTokens less than 2");
        }
        int end = consumedTokens.size() - 1;
        consumedTokens.set(end, CssTokenUtil.copyPosTo((Token)consumedTokens.get(end), new EOFToken()));
        return consumedTokens.subList(1, consumedTokens.size());
    }

    public static boolean consumeAComponentValue(@Nonnull TokenStream tokenStream, @Nonnull List<Token> tokenList, int depth) throws CssValidationException {
        if (depth > 100) {
            return false;
        }
        TokenType current = CssTokenUtil.getTokenType(tokenStream.current());
        if (current == TokenType.OPEN_CURLY || current == TokenType.OPEN_SQUARE || current == TokenType.OPEN_PAREN) {
            if (!Canonicalizer.consumeASimpleBlock(tokenStream, tokenList, depth + 1)) {
                return false;
            }
        } else if (current == TokenType.FUNCTION_TOKEN) {
            if (!Canonicalizer.consumeAFunction(tokenStream, tokenList, depth + 1)) {
                return false;
            }
        } else {
            tokenList.add(tokenStream.current());
        }
        return true;
    }

    private static boolean consumeAFunction(@Nonnull TokenStream tokenStream, @Nonnull List<Token> tokenList, int depth) throws CssValidationException {
        if (depth > 100) {
            return false;
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.FUNCTION_TOKEN) {
            throw new CssValidationException("Internal Error: consumeAFunction precondition not met");
        }
        tokenList.add(tokenStream.current());
        do {
            tokenStream.consume();
            TokenType current = CssTokenUtil.getTokenType(tokenStream.current());
            if (current != TokenType.EOF_TOKEN && current != TokenType.CLOSE_PAREN) continue;
            tokenList.add(tokenStream.current());
            return true;
        } while (Canonicalizer.consumeAComponentValue(tokenStream, tokenList, depth + 1));
        return false;
    }

    private static boolean consumeASimpleBlock(@Nonnull TokenStream tokenStream, @Nonnull List<Token> tokenList, int depth) throws CssValidationException {
        if (depth > 100) {
            return false;
        }
        TokenType current = CssTokenUtil.getTokenType(tokenStream.current());
        if (current != TokenType.OPEN_CURLY && current != TokenType.OPEN_SQUARE && current != TokenType.OPEN_PAREN) {
            throw new CssValidationException("Internal Error: consumeASimpleBlock precondition not met");
        }
        Token startToken = tokenStream.current();
        String mirror = CssTokenUtil.getMirror(startToken);
        tokenList.add(startToken);
        do {
            tokenStream.consume();
            current = CssTokenUtil.getTokenType(tokenStream.current());
            if (current == TokenType.EOF_TOKEN) {
                tokenList.add(tokenStream.current());
                return true;
            }
            if (current != TokenType.CLOSE_CURLY && current != TokenType.CLOSE_SQUARE && current != TokenType.CLOSE_PAREN || !tokenStream.current().toString().equals(mirror)) continue;
            tokenList.add(tokenStream.current());
            return true;
        } while (Canonicalizer.consumeAComponentValue(tokenStream, tokenList, depth + 1));
        return false;
    }

    private void parseAQualifiedRule(@Nonnull TokenStream tokenStream, @Nonnull List<Rule> rules, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.EOF_TOKEN || CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.AT_KEYWORD) {
            throw new CssValidationException("Internal Error: parseAQualifiedRule precondition not met");
        }
        QualifiedRule rule = (QualifiedRule)CssTokenUtil.copyPosTo(tokenStream.current(), new QualifiedRule());
        tokenStream.reconsume();
        while (true) {
            ArrayList<String> params;
            tokenStream.consume();
            TokenType current = CssTokenUtil.getTokenType(tokenStream.current());
            if (current == TokenType.EOF_TOKEN) {
                params = new ArrayList<String>();
                params.add("style");
                errors.add((ErrorToken)CssTokenUtil.copyPosTo(rule, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_EOF_IN_PRELUDE_OF_QUALIFIED_RULE, params)));
                return;
            }
            if (current == TokenType.OPEN_CURLY) {
                rule.getPrelude().add(CssTokenUtil.copyPosTo(tokenStream.current(), new EOFToken()));
                rule.setDeclarations(this.parseAListOfDeclarations(this.extractASimpleBlock(tokenStream, errors), errors));
                rules.add(rule);
                return;
            }
            if (Canonicalizer.consumeAComponentValue(tokenStream, rule.getPrelude(), 0)) continue;
            params = new ArrayList();
            params.add("style");
            errors.add((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_EXCESSIVELY_NESTED, params)));
        }
    }
}

