/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import com.steadystate.css.parser.Token;
import dev.amp.validator.Context;
import dev.amp.validator.ParsedAttrSpec;
import dev.amp.validator.UrlErrorInStylesheetAdapter;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.Canonicalizer;
import dev.amp.validator.css.CssParser;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.EOFToken;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.ParsedCssUrl;
import dev.amp.validator.css.ParsedDocCssSpec;
import dev.amp.validator.css.Stylesheet;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.utils.AttributeSpecUtils;
import dev.amp.validator.utils.ByteUtils;
import dev.amp.validator.utils.TagSpecUtils;
import dev.amp.validator.utils.UrlUtils;
import dev.amp.validator.visitor.Amp4AdsVisitor;
import dev.amp.validator.visitor.ImportantPropertyVisitor;
import dev.amp.validator.visitor.KeyframesVisitor;
import dev.amp.validator.visitor.UrlFunctionVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class CssSpecUtils {
    private static final int MAX_NUM_ALLOWED_DECLARATIONS = 5;

    private CssSpecUtils() {
    }

    public static Stylesheet parseAStylesheet(@Nonnull List<Token> tokenList, @Nonnull Map<String, BlockType> atRuleSpec, @Nonnull BlockType defaultSpec, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        Canonicalizer canonicalizer = new Canonicalizer(atRuleSpec, defaultSpec);
        Stylesheet stylesheet = new Stylesheet();
        stylesheet.setRules(canonicalizer.parseAListOfRules(tokenList, true, errors));
        CssTokenUtil.copyPosTo(tokenList.get(0), stylesheet);
        stylesheet.setEOF((EOFToken)CssTokenUtil.copyPosTo(tokenList.get(tokenList.size() - 1), new EOFToken()));
        return stylesheet;
    }

    public static void extractUrls(@Nonnull Stylesheet stylesheet, @Nonnull List<ParsedCssUrl> parsedUrls, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        int errorsOldLength = errors.size();
        UrlFunctionVisitor visitor = new UrlFunctionVisitor(parsedUrls, errors);
        stylesheet.accept(visitor);
        if (errorsOldLength != errors.size()) {
            int parsedUrlsOldLength = parsedUrls.size();
            parsedUrls.subList(parsedUrlsOldLength, parsedUrls.size()).clear();
        }
    }

    public static void extractUrlsFromDeclaration(@Nonnull Declaration declaration, @Nonnull List<ParsedCssUrl> parsedUrls, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        int errorsOldLength = errors.size();
        UrlFunctionVisitor visitor = new UrlFunctionVisitor(parsedUrls, errors);
        declaration.accept(visitor);
        if (errorsOldLength != errors.size()) {
            int parsedUrlsOldLength = parsedUrls.size();
            parsedUrls.subList(parsedUrlsOldLength, parsedUrls.size()).clear();
        }
    }

    public static void extractImportantDeclarations(@Nonnull Stylesheet stylesheet, @Nonnull List<Declaration> important) throws CssValidationException {
        ImportantPropertyVisitor visitor = new ImportantPropertyVisitor(important);
        stylesheet.accept(visitor);
    }

    public static String stripVendorPrefix(@Nonnull String prefixedString) {
        if (!prefixedString.equals("") && prefixedString.charAt(0) == '-') {
            if (prefixedString.startsWith("-o-")) {
                return prefixedString.substring("-o-".length());
            }
            if (prefixedString.startsWith("-moz-")) {
                return prefixedString.substring("-moz-".length());
            }
            if (prefixedString.startsWith("-ms-")) {
                return prefixedString.substring("-ms-".length());
            }
            if (prefixedString.startsWith("-webkit-")) {
                return prefixedString.substring("-webkit-".length());
            }
        }
        return prefixedString;
    }

    public static String stripMinMax(@Nonnull String prefixedString) {
        if (prefixedString.startsWith("min-")) {
            return prefixedString.substring("min-".length());
        }
        if (prefixedString.startsWith("max-")) {
            return prefixedString.substring("max-".length());
        }
        return prefixedString;
    }

    public static boolean asciiMatch(@Nonnull Token token, @Nonnull String str) {
        return token.toString().toLowerCase().equals(str.toLowerCase());
    }

    public static void validateKeyframesCss(@Nonnull Stylesheet styleSheet, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        KeyframesVisitor visitor = new KeyframesVisitor(errors);
        styleSheet.accept(visitor);
    }

    public static void validateAmp4AdsCss(@Nonnull Stylesheet styleSheet, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        Amp4AdsVisitor visitor = new Amp4AdsVisitor(errors);
        styleSheet.accept(visitor);
    }

    public static boolean isDeclarationValid(@Nonnull ValidatorProtos.CssSpec cssSpec, @Nonnull String declarationName) {
        if (cssSpec.getDeclarationList().size() == 0) {
            return true;
        }
        return cssSpec.getDeclarationList().indexOf((Object)CssSpecUtils.stripVendorPrefix(declarationName)) > -1;
    }

    public static String allowedDeclarationsString(@Nonnull ValidatorProtos.CssSpec cssSpec) {
        if (cssSpec.getDeclarationList().size() > 5) {
            return "";
        }
        return "['" + String.join((CharSequence)"', '", (Iterable<? extends CharSequence>)cssSpec.getDeclarationList()) + "']";
    }

    public static void parseUrlToken(@Nonnull List<Token> tokens, int tokenIdx, @Nonnull ParsedCssUrl parsed) throws CssValidationException {
        if (tokenIdx + 1 >= tokens.size()) {
            throw new CssValidationException("Url token not within range of tokens");
        }
        Token token = tokens.get(tokenIdx);
        if (CssTokenUtil.getTokenType(token) != TokenType.URL) {
            throw new CssValidationException("Url token not within range of tokens");
        }
        CssTokenUtil.copyPosTo(token, parsed);
        parsed.setUtf8Url(token.toString());
    }

    public static int parseUrlFunction(@Nonnull List<Token> tokens, int tokenIdx, @Nonnull ParsedCssUrl parsed) throws CssValidationException {
        Token token = tokens.get(tokenIdx);
        if (CssTokenUtil.getTokenType(token) != TokenType.FUNCTION_TOKEN) {
            throw new CssValidationException("Token at index is not a function token");
        }
        if (!token.toString().equals("url(")) {
            throw new CssValidationException("Token value is not url");
        }
        if (CssTokenUtil.getTokenType(tokens.get(tokens.size() - 1)) != TokenType.EOF_TOKEN) {
            throw new CssValidationException("Last token is not EOF token");
        }
        CssTokenUtil.copyPosTo(token, parsed);
        if (++tokenIdx >= tokens.size()) {
            throw new CssValidationException("Index outside of tokens range");
        }
        while (CssTokenUtil.getTokenType(tokens.get(tokenIdx)) == TokenType.WHITESPACE) {
            if (++tokenIdx < tokens.size()) continue;
            throw new CssValidationException("Index outside of tokens range");
        }
        if (CssTokenUtil.getTokenType(tokens.get(tokenIdx)) != TokenType.STRING) {
            return -1;
        }
        parsed.setUtf8Url(tokens.get(tokenIdx).toString());
        if (++tokenIdx >= tokens.size()) {
            throw new CssValidationException("token index outside of tokens range");
        }
        while (CssTokenUtil.getTokenType(tokens.get(tokenIdx)) == TokenType.WHITESPACE) {
            if (++tokenIdx < tokens.size()) continue;
            throw new CssValidationException("token index outside of tokens range");
        }
        if (CssTokenUtil.getTokenType(tokens.get(tokenIdx)) != TokenType.CLOSE_PAREN) {
            return -1;
        }
        return tokenIdx + 1;
    }

    public static List<Declaration> parseInlineStyle(@Nonnull List<Token> tokenList, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        Canonicalizer canonicalizer = new Canonicalizer(new HashMap<String, BlockType>(), BlockType.PARSE_AS_DECLARATIONS);
        return canonicalizer.parseAListOfDeclarations(tokenList, errors);
    }

    public static void validateAttrCss(@Nonnull ParsedAttrSpec parsedAttrSpec, @Nonnull Context context, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull String attrName, @Nonnull String attrValue, @Nonnull ValidateTagResult result) throws IOException, CssValidationException {
        int attrByteLen = ByteUtils.byteLength(attrValue);
        result.setInlineStyleCssBytes(attrByteLen);
        ArrayList<ErrorToken> cssErrors = new ArrayList<ErrorToken>();
        CssParser cssParser = new CssParser(attrValue, context.getLineCol().getLineNumber(), context.getLineCol().getColumnNumber(), cssErrors);
        List<Token> tokenList = cssParser.tokenize();
        List<Declaration> declarations = CssSpecUtils.parseInlineStyle(tokenList, cssErrors);
        for (ErrorToken errorToken : cssErrors) {
            List<String> params = errorToken.getParams();
            params.set(0, tagSpec.getTagName());
            context.addError(errorToken.getCode(), errorToken.getLine(), errorToken.getCol(), params, "", result.getValidationResult());
        }
        if (cssErrors.size() > 0) {
            return;
        }
        ParsedDocCssSpec maybeDocCssSpec = context.matchingDocCssSpec();
        if (maybeDocCssSpec != null) {
            if (maybeDocCssSpec.getSpec().getMaxBytesPerInlineStyle() >= 0 && attrByteLen > maybeDocCssSpec.getSpec().getMaxBytesPerInlineStyle()) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(TagSpecUtils.getTagSpecName(tagSpec));
                params.add(Integer.toString(attrByteLen));
                params.add(Integer.toString(maybeDocCssSpec.getSpec().getMaxBytesPerInlineStyle()));
                if (maybeDocCssSpec.getSpec().getMaxBytesIsWarning()) {
                    context.addWarning(ValidatorProtos.ValidationError.Code.INLINE_STYLE_TOO_LONG, context.getLineCol(), params, maybeDocCssSpec.getSpec().getSpecUrl(), result.getValidationResult());
                } else {
                    context.addError(ValidatorProtos.ValidationError.Code.INLINE_STYLE_TOO_LONG, context.getLineCol(), params, maybeDocCssSpec.getSpec().getSpecUrl(), result.getValidationResult());
                }
            }
            for (Declaration declaration : declarations) {
                ArrayList<String> params;
                String firstIdent = declaration.firstIdent();
                if (!maybeDocCssSpec.getSpec().getAllowAllDeclarationInStyle()) {
                    Pattern valueRegex;
                    ArrayList<String> params2;
                    ValidatorProtos.CssDeclaration cssDeclaration;
                    ValidatorProtos.CssDeclaration cssDeclaration2 = cssDeclaration = parsedAttrSpec.getSpec().getValueDocSvgCss() ? maybeDocCssSpec.getCssDeclarationSvgByName(declaration.getName()) : maybeDocCssSpec.getCssDeclarationByName(declaration.getName());
                    if (cssDeclaration == null) {
                        ArrayList<String> params3 = new ArrayList<String>();
                        params3.add(declaration.getName());
                        params3.add(attrName);
                        params3.add(TagSpecUtils.getTagDescriptiveName(tagSpec));
                        context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_PROPERTY_IN_ATTR_VALUE, context.getLineCol(), params3, context.getRules().getStylesSpecUrl(), result.getValidationResult());
                        continue;
                    }
                    if (cssDeclaration.getValueCaseiList().size() > 0) {
                        boolean hasValidValue = false;
                        for (String value : cssDeclaration.getValueCaseiList()) {
                            if (!firstIdent.toLowerCase().equals(value)) continue;
                            hasValidValue = true;
                            break;
                        }
                        if (!hasValidValue) {
                            params2 = new ArrayList<String>();
                            params2.add(TagSpecUtils.getTagDescriptiveName(tagSpec));
                            params2.add(declaration.getName());
                            params2.add(firstIdent);
                            context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PROPERTY_VALUE, context.getLineCol(), params2, context.getRules().getStylesSpecUrl(), result.getValidationResult());
                        }
                    } else if (cssDeclaration.hasValueRegexCasei() && !(valueRegex = context.getRules().getFullMatchCaseiRegex(cssDeclaration.getValueRegexCasei())).matcher(firstIdent).matches()) {
                        params2 = new ArrayList();
                        params2.add(TagSpecUtils.getTagDescriptiveName(tagSpec));
                        params2.add(declaration.getName());
                        params2.add(firstIdent);
                        context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PROPERTY_VALUE, context.getLineCol(), params2, context.getRules().getStylesSpecUrl(), result.getValidationResult());
                    }
                }
                if (declaration.getName().contains("i-amphtml-")) {
                    params = new ArrayList<String>();
                    params.add(declaration.getName());
                    params.add(attrName);
                    params.add(TagSpecUtils.getTagSpecName(tagSpec));
                    context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_PROPERTY_IN_ATTR_VALUE, context.getLineCol().getLineNumber() + declaration.getLine(), context.getLineCol().getColumnNumber() + declaration.getCol(), params, "", result.getValidationResult());
                    continue;
                }
                if (!maybeDocCssSpec.getSpec().getAllowImportant() && declaration.getImportant()) {
                    params = new ArrayList();
                    params.add(attrName);
                    params.add(TagSpecUtils.getTagSpecName(tagSpec));
                    params.add("CSS !important");
                    context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, context.getRules().getStylesSpecUrl(), result.getValidationResult());
                }
                ArrayList<ErrorToken> urlErrors = new ArrayList<ErrorToken>();
                ArrayList<ParsedCssUrl> parsedUrls = new ArrayList<ParsedCssUrl>();
                CssSpecUtils.extractUrlsFromDeclaration(declaration, parsedUrls, urlErrors);
                for (ErrorToken errorToken : urlErrors) {
                    List<String> params4 = errorToken.getParams();
                    params4.set(0, TagSpecUtils.getTagSpecName(tagSpec));
                    context.addError(errorToken.getCode(), context.getLineCol(), params4, "", result.getValidationResult());
                }
                if (urlErrors.size() > 0) continue;
                for (ParsedCssUrl url : parsedUrls) {
                    if (maybeDocCssSpec.getSpec().hasImageUrlSpec()) {
                        UrlErrorInStylesheetAdapter adapter = new UrlErrorInStylesheetAdapter(context.getLineCol().getLineNumber(), context.getLineCol().getColumnNumber());
                        AttributeSpecUtils.validateUrlAndProtocol(maybeDocCssSpec.getImageUrlSpec(), adapter, context, url.getUtf8Url(), tagSpec, result.getValidationResult());
                    }
                    if (maybeDocCssSpec.getSpec().getUrlBytesIncluded() || UrlUtils.isDataUrl(url.getUtf8Url())) continue;
                    result.setInlineStyleCssBytes(result.getInlineStyleCssBytes() - ByteUtils.byteLength(url.getUtf8Url()));
                }
            }
        }
    }

    public static enum BlockType {
        PARSE_AS_RULES,
        PARSE_AS_DECLARATIONS,
        PARSE_AS_IGNORE;

    }
}

