/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import com.steadystate.css.parser.Token;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.QualifiedRule;
import dev.amp.validator.css.TokenStream;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.selector.AttrSelector;
import dev.amp.validator.selector.ClassSelector;
import dev.amp.validator.selector.Combinator;
import dev.amp.validator.selector.IdSelector;
import dev.amp.validator.selector.PseudoSelector;
import dev.amp.validator.selector.Selector;
import dev.amp.validator.selector.SelectorException;
import dev.amp.validator.selector.SelectorsGroup;
import dev.amp.validator.selector.SimpleSelectorSequence;
import dev.amp.validator.selector.TypeSelector;
import dev.amp.validator.utils.SelectorUtils;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class SelectorVisitor
implements RuleVisitor {
    private final List<ErrorToken> errors;

    public SelectorVisitor(@Nonnull List<ErrorToken> errors) {
        this.errors = errors;
    }

    @Override
    public void visitQualifiedRule(QualifiedRule qualifiedRule) throws CssValidationException {
        SelectorsGroup maybeSelector;
        TokenStream tokenStream = new TokenStream(qualifiedRule.getPrelude());
        tokenStream.consume();
        try {
            maybeSelector = SelectorVisitor.parseASelectorsGroup(tokenStream);
        }
        catch (SelectorException selectorException) {
            this.errors.add(selectorException.getErrorToken());
            return;
        }
        ArrayDeque<Selector> toVisit = maybeSelector.getElements();
        while (!toVisit.isEmpty()) {
            Selector node = toVisit.pop();
            node.accept(this);
            node.forEachChild(child -> toVisit.add((Selector)((Object)child)));
        }
    }

    public static SelectorsGroup parseASelectorsGroup(@Nonnull TokenStream tokenStream) throws CssValidationException, SelectorException {
        if (!SelectorUtils.isSimpleSelectorSequenceStart(tokenStream.current())) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_MEDIA_TYPE, params);
            throw new SelectorException((ErrorToken)CssTokenUtil.copyPosTo(tokenStream.current(), errorToken));
        }
        Token start = tokenStream.current();
        Selector selector = SelectorUtils.parseASelector(tokenStream);
        ArrayDeque<Selector> elements = new ArrayDeque<Selector>();
        elements.add(selector);
        while (true) {
            if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
                tokenStream.consume();
            }
            if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.COMMA) break;
            tokenStream.consume();
            if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
                tokenStream.consume();
            }
            elements.push(SelectorUtils.parseASelector(tokenStream));
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.EOF_TOKEN) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_UNPARSED_INPUT_REMAINS_IN_SELECTOR, params);
            throw new SelectorException(errorToken);
        }
        if (elements.size() == 1) {
            if (elements.getFirst() instanceof SelectorsGroup) {
                return (SelectorsGroup)elements.getFirst();
            }
            throw new CssValidationException("Expected SelectorsGroup as first element of Selectors collection.");
        }
        return (SelectorsGroup)CssTokenUtil.copyPosTo(start, new SelectorsGroup(elements));
    }

    public abstract void visitTypeSelector(@Nonnull TypeSelector var1);

    public abstract void visitIdSelector(@Nonnull IdSelector var1);

    public abstract void visitAttrSelector(@Nonnull AttrSelector var1);

    public abstract void visitPseudoSelector(@Nonnull PseudoSelector var1);

    public abstract void visitClassSelector(@Nonnull ClassSelector var1);

    public abstract void visitSimpleSelectorSequence(@Nonnull SimpleSelectorSequence var1);

    public abstract void visitCombinator(@Nonnull Combinator var1);

    public abstract void visitSelectorsGroup(@Nonnull Selector var1);
}

