/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.BinToken;
import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.StringTable;
import dev.argon.esexpr.SyntaxException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ESExprBinaryReader {
    private final List<String> symbolTable;
    @NotNull
    private final InputStream is;
    private int nextByte = -1;

    public ESExprBinaryReader(@NotNull List<String> symbolTable, @NotNull InputStream is) {
        this.symbolTable = new ArrayList<String>(symbolTable);
        this.is = is;
    }

    public ESExprBinaryReader(@NotNull InputStream is) {
        this.symbolTable = new ArrayList<String>();
        this.is = is;
    }

    @Nullable
    public ESExpr read() throws IOException, SyntaxException {
        if (this.peekNext() < 0) {
            return null;
        }
        return this.readExpr();
    }

    @NotNull
    public @NotNull Stream<@NotNull ESExpr> readAll() {
        return Stream.generate(() -> {
            try {
                return this.read();
            }
            catch (SyntaxException | IOException ex) {
                throw new RuntimeException(ex);
            }
        }).takeWhile(Objects::nonNull);
    }

    private int next() throws IOException {
        if (this.nextByte >= 0) {
            int res = this.nextByte;
            this.nextByte = -1;
            return res;
        }
        return this.is.read();
    }

    private int peekNext() throws IOException {
        if (this.nextByte >= 0) {
            return this.nextByte;
        }
        this.nextByte = this.is.read();
        return this.nextByte;
    }

    private BinToken nextToken() throws IOException, SyntaxException {
        BinToken.WithIntegerType type;
        int b = this.next();
        if (b < 0) {
            throw new EOFException();
        }
        switch (b & 0xE0) {
            case 0: {
                BinToken.WithIntegerType withIntegerType = BinToken.WithIntegerType.CONSTRUCTOR;
                break;
            }
            case 32: {
                BinToken.WithIntegerType withIntegerType = BinToken.WithIntegerType.INT;
                break;
            }
            case 64: {
                BinToken.WithIntegerType withIntegerType = BinToken.WithIntegerType.NEG_INT;
                break;
            }
            case 96: {
                BinToken.WithIntegerType withIntegerType = BinToken.WithIntegerType.STRING;
                break;
            }
            case 128: {
                BinToken.WithIntegerType withIntegerType = BinToken.WithIntegerType.STRING_POOL_INDEX;
                break;
            }
            case 160: {
                BinToken.WithIntegerType withIntegerType = BinToken.WithIntegerType.BINARY;
                break;
            }
            case 192: {
                BinToken.WithIntegerType withIntegerType = BinToken.WithIntegerType.KEYWORD;
                break;
            }
            default: {
                BinToken.WithIntegerType withIntegerType = type = null;
            }
        }
        if (type == null) {
            return switch (b) {
                case 224 -> BinToken.Fixed.CONSTRUCTOR_END;
                case 225 -> BinToken.Fixed.TRUE;
                case 226 -> BinToken.Fixed.FALSE;
                case 227 -> BinToken.Fixed.NULL0;
                case 228 -> BinToken.Fixed.FLOAT32;
                case 229 -> BinToken.Fixed.FLOAT64;
                case 230 -> BinToken.Fixed.CONSTRUCTOR_START_STRING_TABLE;
                case 231 -> BinToken.Fixed.CONSTRUCTOR_START_LIST;
                case 232 -> BinToken.Fixed.NULL1;
                case 233 -> BinToken.Fixed.NULL2;
                case 234 -> BinToken.Fixed.NULLN;
                case 235 -> BinToken.Fixed.APPEND_STRING_TABLE;
                default -> throw new SyntaxException();
            };
        }
        BigInteger i = BigInteger.valueOf(b & 0xF);
        if ((b & 0x10) == 16) {
            i = this.readInt(i, 4);
        }
        return new BinToken.WithInteger(type, i);
    }

    private BigInteger readInt(BigInteger acc, int bits) throws IOException {
        int b;
        do {
            if ((b = this.next()) < 0) {
                throw new EOFException();
            }
            acc = acc.or(BigInteger.valueOf(b & 0x7F).shiftLeft(bits));
            bits += 7;
        } while ((b & 0x80) != 0);
        return acc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ESExpr readExpr() throws SyntaxException, IOException {
        ExprPlus exprPlus = this.readExprPlus();
        Objects.requireNonNull(exprPlus);
        ExprPlus exprPlus2 = exprPlus;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExprPlus.Expr.class}, (Object)exprPlus2, n)) {
            case 0: {
                ExprPlus.Expr expr = (ExprPlus.Expr)exprPlus2;
                try {
                    ESExpr eSExpr = expr.expr();
                    return eSExpr;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new SyntaxException();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ExprPlus readExprPlus() throws SyntaxException, IOException {
        ExprPlus.ConstructorEnd constructorEnd;
        Record record;
        BinToken binToken = this.nextToken();
        Objects.requireNonNull(binToken);
        BinToken binToken2 = binToken;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinToken.WithInteger.class, BinToken.Fixed.class}, (Object)binToken2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object value;
                BinToken.WithIntegerType type;
                BinToken.WithInteger withInteger = (BinToken.WithInteger)binToken2;
                try {
                    Object object = withInteger.type();
                    type = object;
                    value = object = withInteger.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                ExprPlus.Expr expr = switch (type) {
                    default -> throw new MatchException(null, null);
                    case BinToken.WithIntegerType.CONSTRUCTOR -> {
                        String sym = this.symbolTable.get(((BigInteger)value).intValueExact());
                        yield new ExprPlus.Expr(this.readConstructor(sym));
                    }
                    case BinToken.WithIntegerType.INT -> new ExprPlus.Expr(new ESExpr.Int((BigInteger)value));
                    case BinToken.WithIntegerType.NEG_INT -> new ExprPlus.Expr(new ESExpr.Int(((BigInteger)value).add(BigInteger.ONE).negate()));
                    case BinToken.WithIntegerType.STRING -> {
                        int len = ((BigInteger)value).intValueExact();
                        byte[] b = new byte[len];
                        if (this.is.readNBytes(b, 0, len) < len) {
                            throw new EOFException();
                        }
                        yield new ExprPlus.Expr(new ESExpr.Str(new String(b, StandardCharsets.UTF_8)));
                    }
                    case BinToken.WithIntegerType.STRING_POOL_INDEX -> {
                        String sym = this.symbolTable.get(((BigInteger)value).intValueExact());
                        yield new ExprPlus.Expr(new ESExpr.Str(sym));
                    }
                    case BinToken.WithIntegerType.BINARY -> {
                        int len = ((BigInteger)value).intValueExact();
                        byte[] b = new byte[len];
                        if (this.is.readNBytes(b, 0, len) < len) {
                            throw new EOFException();
                        }
                        yield new ExprPlus.Expr(new ESExpr.Binary(b));
                    }
                    case BinToken.WithIntegerType.KEYWORD -> {
                        String sym = this.symbolTable.get(((BigInteger)value).intValueExact());
                        yield new ExprPlus.Keyword(sym);
                    }
                };
                record = expr;
                return record;
            }
            case 1: 
        }
        BinToken.Fixed fixed = (BinToken.Fixed)binToken2;
        record = constructorEnd = (switch (fixed) {
            default -> throw new MatchException(null, null);
            case BinToken.Fixed.NULL0 -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Null(BigInteger.ZERO));
            }
            case BinToken.Fixed.NULL1 -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Null(BigInteger.ONE));
            }
            case BinToken.Fixed.NULL2 -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Null(BigInteger.valueOf(2L)));
            }
            case BinToken.Fixed.NULLN -> {
                ExprPlus var8_12;
                BigInteger n = this.readInt(BigInteger.ZERO, 0);
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Null(n.add(BigInteger.valueOf(3L))));
            }
            case BinToken.Fixed.CONSTRUCTOR_END -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.ConstructorEnd();
            }
            case BinToken.Fixed.TRUE -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Bool(true));
            }
            case BinToken.Fixed.FALSE -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Bool(false));
            }
            case BinToken.Fixed.FLOAT32 -> {
                int b;
                ExprPlus var8_12;
                int bits = 0;
                for (int i = 0; i < 4; bits |= (b & 0xFF) << i * 8, ++i) {
                    b = this.next();
                    if (b >= 0) continue;
                    throw new EOFException();
                }
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Float32(Float.intBitsToFloat(bits)));
            }
            case BinToken.Fixed.FLOAT64 -> {
                int b;
                ExprPlus var8_12;
                long bits = 0L;
                for (int i = 0; i < 8; bits |= (long)(b & 0xFF) << i * 8, ++i) {
                    b = this.next();
                    if (b >= 0) continue;
                    throw new EOFException();
                }
                yield var8_12 = new ExprPlus.Expr(new ESExpr.Float64(Double.longBitsToDouble(bits)));
            }
            case BinToken.Fixed.CONSTRUCTOR_START_STRING_TABLE -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.Expr(this.readConstructor("string-table"));
            }
            case BinToken.Fixed.CONSTRUCTOR_START_LIST -> {
                ExprPlus var8_12;
                yield var8_12 = new ExprPlus.Expr(this.readConstructor("list"));
            }
            case BinToken.Fixed.APPEND_STRING_TABLE -> {
                ExprPlus var8_12;
                ESExpr newStringTable = this.readExpr();
                if (newStringTable instanceof ESExpr.Str) {
                    ESExpr.Str var10_19 = (ESExpr.Str)newStringTable;
                    {
                        String b;
                        String s = b = var10_19.s();
                        this.symbolTable.add(s);
                    }
                } else {
                    StringTable newDecoded;
                    try {
                        newDecoded = StringTable.codec().decode(newStringTable);
                    }
                    catch (DecodeException ex) {
                        throw new SyntaxException("Could not decode string table.", ex);
                    }
                    this.symbolTable.addAll(newDecoded.values());
                }
                yield var8_12 = this.readExprPlus();
            }
        });
        return record;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ESExpr readConstructor(String name) throws IOException, SyntaxException {
        ArrayList<ESExpr> args = new ArrayList<ESExpr>();
        HashMap<String, ESExpr> kwargs = new HashMap<String, ESExpr>();
        block8: while (true) {
            String kw;
            ExprPlus exprPlus;
            Objects.requireNonNull(this.readExprPlus());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExprPlus.Expr.class, ExprPlus.ConstructorEnd.class, ExprPlus.Keyword.class}, (Object)exprPlus, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Object object;
                    ExprPlus.Expr expr = (ExprPlus.Expr)exprPlus;
                    try {
                        Object expr2 = object = expr.expr();
                        args.add((ESExpr)expr2);
                        continue block8;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    Object object = (ExprPlus.ConstructorEnd)exprPlus;
                    return new ESExpr.Constructor(name, args, kwargs);
                }
                case 2: 
            }
            ExprPlus.Keyword keyword = (ExprPlus.Keyword)exprPlus;
            {
                String string;
                kw = string = keyword.name();
            }
            ESExpr expr = this.readExpr();
            kwargs.put(kw, expr);
        }
    }

    private static sealed interface ExprPlus {

        public record Keyword(String name) implements ExprPlus
        {
        }

        public record ConstructorEnd() implements ExprPlus
        {
        }

        public record Expr(ESExpr expr) implements ExprPlus
        {
        }
    }
}

