/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import dev.cdevents.config.CustomObjectMapper;
import dev.cdevents.exception.CDEventsException;
import dev.cdevents.models.CDEvent;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.v03.CloudEventBuilder;
import io.cloudevents.core.v03.CloudEventV03;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDEvents {
    private static ObjectMapper objectMapper = new CustomObjectMapper().customConfiguration();
    private static Logger log = LoggerFactory.getLogger(CDEvents.class);

    private CDEvents() {
    }

    public static String cdEventAsJson(CDEvent cdEvent) {
        try {
            return objectMapper.writeValueAsString((Object)cdEvent);
        }
        catch (JsonProcessingException e) {
            log.error("Error while mapping cdEvent as Json {}", (Object)e.getMessage());
            throw new CDEventsException("Error while mapping cdEvent as Json {}", e);
        }
    }

    public static CloudEvent cdEventAsCloudEvent(CDEvent cdEvent) {
        if (!CDEvents.validateCDEvent(cdEvent)) {
            log.error("CDEvent validation failed against schema URL - {}", (Object)cdEvent.schemaURL());
            throw new CDEventsException("CDEvent validation failed against schema URL - " + cdEvent.schemaURL());
        }
        String cdEventJson = CDEvents.cdEventAsJson(cdEvent);
        log.info("CDEvent with type {} as json - {}", (Object)cdEvent.getContext().getType(), (Object)cdEventJson);
        CloudEventV03 ceToSend = ((CloudEventBuilder)new CloudEventBuilder().withId(UUID.randomUUID().toString()).withSource(cdEvent.getContext().getSource()).withType(cdEvent.getContext().getType()).withDataContentType("application/json").withData(cdEventJson.getBytes(StandardCharsets.UTF_8))).withTime(OffsetDateTime.now()).build();
        return ceToSend;
    }

    public static boolean validateCDEvent(CDEvent cdEvent) {
        JsonNode jsonNode;
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
        JsonSchema jsonSchema = factory.getSchema(cdEvent.eventSchema());
        Set errors = jsonSchema.validate(jsonNode = (JsonNode)objectMapper.convertValue((Object)cdEvent, ObjectNode.class));
        if (!errors.isEmpty()) {
            log.error("CDEvent validation failed with errors {}", (Object)errors);
            return false;
        }
        return true;
    }
}

