/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.models.CDEvent;
import dev.cdevents.models.ChangeSubject;
import java.net.URI;

public class ChangeAbandonedCDEvent
extends CDEvent {
    private static final String CDEVENT_VERSION = "0.1.1";
    @JsonProperty(required=true)
    private ChangeSubject subject;

    public ChangeAbandonedCDEvent() {
        this.initCDEvent(this.currentCDEventType());
        this.setSubject(new ChangeSubject(CDEventConstants.SubjectType.CHANGE));
    }

    public ChangeSubject getSubject() {
        return this.subject;
    }

    public void setSubject(ChangeSubject subject) {
        this.subject = subject;
    }

    @Override
    public String currentCDEventType() {
        return CDEventConstants.CDEventTypes.ChangeAbandonedEvent.getEventType().concat(CDEVENT_VERSION);
    }

    @Override
    public String schemaURL() {
        return String.format("https://cdevents.dev/%s/schema/change-abandoned-event", "0.1.2");
    }

    @Override
    public String eventSchema() {
        return "{\n  \"$schema\": \"https://json-schema.org/draft/2020-12/schema\",\n  \"$id\": \"https://cdevents.dev/0.1.2/schema/change-abandoned-event\",\n  \"properties\": {\n    \"context\": {\n      \"properties\": {\n        \"version\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"id\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"source\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"type\": {\n          \"type\": \"string\",\n          \"enum\": [\n            \"dev.cdevents.change.abandoned.0.1.1\"\n          ],\n          \"default\": \"dev.cdevents.change.abandoned.0.1.1\"\n        },\n        \"timestamp\": {\n          \"type\": \"string\",\n          \"format\": \"date-time\"\n        }\n      },\n      \"additionalProperties\": false,\n      \"type\": \"object\",\n      \"required\": [\n        \"version\",\n        \"id\",\n        \"source\",\n        \"type\",\n        \"timestamp\"\n      ]\n    },\n    \"subject\": {\n      \"properties\": {\n        \"id\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"source\": {\n          \"type\": \"string\"\n        },\n        \"type\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"content\": {\n          \"properties\": {\n            \"repository\": {\n              \"properties\": {\n                \"id\": {\n                  \"type\": \"string\",\n                  \"minLength\": 1\n                },\n                \"source\": {\n                  \"type\": \"string\"\n                }\n              },\n              \"additionalProperties\": false,\n              \"type\": \"object\",\n              \"required\": [\n                \"id\"\n              ]\n            }\n          },\n          \"additionalProperties\": false,\n          \"type\": \"object\"\n        }\n      },\n      \"additionalProperties\": false,\n      \"type\": \"object\",\n      \"required\": [\n        \"id\",\n        \"type\",\n        \"content\"\n      ]\n    },\n    \"customData\": {\n      \"oneOf\": [\n        {\n          \"type\": \"object\"\n        },\n        {\n          \"type\": \"string\",\n          \"contentEncoding\": \"base64\"\n        }\n      ]\n    },\n    \"customDataContentType\": {\n      \"type\": \"string\"\n    }\n  },\n  \"additionalProperties\": false,\n  \"type\": \"object\",\n  \"required\": [\n    \"context\",\n    \"subject\"\n  ]\n}";
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource);
    }

    public void setSubjectRepositoryId(String repositoryId) {
        this.getSubject().getContent().getRepository().setId(repositoryId);
    }

    public void setSubjectRepositorySource(URI repositorySource) {
        this.getSubject().getContent().getRepository().setSource(repositorySource);
    }
}

