/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.models.CDEvent;
import dev.cdevents.models.RepositorySubject;
import java.net.URI;

public class RepositoryCreatedCDEvent
extends CDEvent {
    private static final String CDEVENT_VERSION = "0.1.0";
    @JsonProperty(required=true)
    private RepositorySubject subject;

    public RepositoryCreatedCDEvent() {
        this.initCDEvent(this.currentCDEventType());
        this.setSubject(new RepositorySubject(CDEventConstants.SubjectType.REPOSITORY));
    }

    public RepositorySubject getSubject() {
        return this.subject;
    }

    public void setSubject(RepositorySubject subject) {
        this.subject = subject;
    }

    @Override
    public String currentCDEventType() {
        return CDEventConstants.CDEventTypes.RepositoryCreatedEvent.getEventType().concat(CDEVENT_VERSION);
    }

    @Override
    public String schemaURL() {
        return String.format("https://cdevents.dev/%s/schema/repository-created-event", "0.1.2");
    }

    @Override
    public String eventSchema() {
        return "{\n  \"$schema\": \"https://json-schema.org/draft/2020-12/schema\",\n  \"$id\": \"https://cdevents.dev/0.1.2/schema/repository-created-event\",\n  \"properties\": {\n    \"context\": {\n      \"properties\": {\n        \"version\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"id\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"source\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"type\": {\n          \"type\": \"string\",\n          \"enum\": [\n            \"dev.cdevents.repository.created.0.1.0\"\n          ],\n          \"default\": \"dev.cdevents.repository.created.0.1.0\"\n        },\n        \"timestamp\": {\n          \"type\": \"string\",\n          \"format\": \"date-time\"\n        }\n      },\n      \"additionalProperties\": false,\n      \"type\": \"object\",\n      \"required\": [\n        \"version\",\n        \"id\",\n        \"source\",\n        \"type\",\n        \"timestamp\"\n      ]\n    },\n    \"subject\": {\n      \"properties\": {\n        \"id\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"source\": {\n          \"type\": \"string\"\n        },\n        \"type\": {\n          \"type\": \"string\",\n          \"minLength\": 1\n        },\n        \"content\": {\n          \"properties\": {\n            \"name\": {\n              \"type\": \"string\",\n              \"minLength\": 1\n            },\n            \"owner\": {\n              \"type\": \"string\"\n            },\n            \"url\": {\n              \"type\": \"string\",\n              \"minLength\": 1\n            },\n            \"viewUrl\": {\n              \"type\": \"string\"\n            }\n          },\n          \"additionalProperties\": false,\n          \"type\": \"object\",\n          \"required\": [\n            \"name\",\n            \"url\"\n          ]\n        }\n      },\n      \"additionalProperties\": false,\n      \"type\": \"object\",\n      \"required\": [\n        \"id\",\n        \"type\",\n        \"content\"\n      ]\n    },\n    \"customData\": {\n      \"oneOf\": [\n        {\n          \"type\": \"object\"\n        },\n        {\n          \"type\": \"string\",\n          \"contentEncoding\": \"base64\"\n        }\n      ]\n    },\n    \"customDataContentType\": {\n      \"type\": \"string\"\n    }\n  },\n  \"additionalProperties\": false,\n  \"type\": \"object\",\n  \"required\": [\n    \"context\",\n    \"subject\"\n  ]\n}";
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource);
    }

    public void setSubjectName(String repositoryName) {
        this.getSubject().getContent().setName(repositoryName);
    }

    public void setSubjectOwner(String repositoryOwner) {
        this.getSubject().getContent().setOwner(repositoryOwner);
    }

    public void setSubjectUrl(URI subjectUrl) {
        this.getSubject().getContent().setUrl(subjectUrl);
    }

    public void setSubjectViewUrl(URI subjectViewUrl) {
        this.getSubject().getContent().setViewUrl(subjectViewUrl);
    }
}

