/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import dev.cdevents.config.CustomObjectMapper;
import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.exception.CDEventsException;
import dev.cdevents.models.CDEvent;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.v03.CloudEventBuilder;
import io.cloudevents.core.v03.CloudEventV03;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDEvents {
    private static ObjectMapper objectMapper = new CustomObjectMapper().customConfiguration();
    private static Logger log = LoggerFactory.getLogger(CDEvents.class);

    private CDEvents() {
    }

    public static String cdEventAsJson(CDEvent cdEvent) {
        try {
            return objectMapper.writeValueAsString((Object)cdEvent);
        }
        catch (JsonProcessingException e) {
            log.error("Error while mapping cdEvent as Json {}", (Object)e.getMessage());
            throw new CDEventsException("Error while mapping cdEvent as Json {}", e);
        }
    }

    public static CloudEvent cdEventAsCloudEvent(CDEvent cdEvent) {
        if (!CDEvents.validateCDEvent(cdEvent)) {
            log.error("CDEvent validation failed against schema URL - {}", (Object)cdEvent.schemaURL());
            throw new CDEventsException("CDEvent validation failed against schema URL - " + cdEvent.schemaURL());
        }
        String cdEventJson = CDEvents.cdEventAsJson(cdEvent);
        log.info("CDEvent with type {} as json - {}", (Object)cdEvent.currentCDEventType(), (Object)cdEventJson);
        try {
            CloudEventV03 ceToSend = ((CloudEventBuilder)new CloudEventBuilder().withId(UUID.randomUUID().toString()).withSource(new URI(cdEvent.eventSource())).withType(cdEvent.currentCDEventType()).withDataContentType("application/json").withData(cdEventJson.getBytes(StandardCharsets.UTF_8))).withTime(OffsetDateTime.now()).build();
            return ceToSend;
        }
        catch (URISyntaxException e) {
            throw new CDEventsException("Exception occurred while building CloudEvent from CDEvent ", e);
        }
    }

    public static boolean validateCDEvent(CDEvent cdEvent) {
        Set<ValidationMessage> errors = CDEvents.getJsonSchemaValidationMessages(cdEvent);
        if (!errors.isEmpty()) {
            log.error("CDEvent validation failed with errors {}", errors);
            return false;
        }
        return true;
    }

    public static CDEvent cdEventFromJson(String cdEventJson) {
        if (!CDEvents.validateCDEventJson(cdEventJson)) {
            throw new CDEventsException("CDEvent Json validation failed against schema");
        }
        String eventType = CDEvents.getUnVersionedEventTypeFromJson(cdEventJson);
        CDEventConstants.CDEventTypes cdEventType = CDEvents.getCDEventTypeEnum(eventType);
        try {
            CDEvent cdEvent = (CDEvent)new ObjectMapper().readValue(cdEventJson, cdEventType.getEventClass());
            return cdEvent;
        }
        catch (JsonProcessingException e) {
            log.error("Exception occurred while creating CDEvent from json {}", (Object)cdEventJson);
            throw new CDEventsException("Exception occurred while creating CDEvent from json ", e);
        }
    }

    public static boolean validateCDEventJson(String cdEventJson) {
        String eventType = CDEvents.getUnVersionedEventTypeFromJson(cdEventJson);
        CDEventConstants.CDEventTypes cdEventType = CDEvents.getCDEventTypeEnum(eventType);
        try {
            CDEvent cdEvent = (CDEvent)new ObjectMapper().readValue(cdEventJson, cdEventType.getEventClass());
            Set<ValidationMessage> errors = CDEvents.getJsonSchemaValidationMessages(cdEvent);
            if (!errors.isEmpty()) {
                log.error("CDEvent Json validation failed against schema URL {}", (Object)cdEvent.schemaURL());
                log.error("CDEvent Json validation failed with errors {}", errors);
                return false;
            }
        }
        catch (JsonProcessingException e) {
            throw new CDEventsException("Exception occurred while validating CDEvent json with schema file ", e);
        }
        return true;
    }

    private static Set<ValidationMessage> getJsonSchemaValidationMessages(CDEvent cdEvent) {
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
        JsonSchema jsonSchema = factory.getSchema(cdEvent.eventSchema());
        JsonNode jsonNode = (JsonNode)objectMapper.convertValue((Object)cdEvent, ObjectNode.class);
        Set errors = jsonSchema.validate(jsonNode);
        return errors;
    }

    private static CDEventConstants.CDEventTypes getCDEventTypeEnum(String eventType) {
        return Arrays.stream(CDEventConstants.CDEventTypes.values()).filter(type -> eventType.equals(type.getEventType())).findFirst().orElseThrow(() -> {
            log.error("Invalid CDEvent type found {} from cdEventJson", (Object)eventType);
            return new CDEventsException("Invalid CDEvent type found from cdEventJson");
        });
    }

    private static String getUnVersionedEventTypeFromJson(String cdEventJson) {
        Object unVersionedEventType = "";
        try {
            String versionedEventType;
            JsonNode rootNode = objectMapper.readTree(cdEventJson);
            if (rootNode.get("context") != null && rootNode.get("context").get("type") != null) {
                versionedEventType = rootNode.get("context").get("type").asText();
                if (!versionedEventType.startsWith("dev.cdevents.")) {
                    throw new CDEventsException("Invalid CDEvent type found in CDEvent Json " + versionedEventType);
                }
            } else {
                throw new CDEventsException("Unable to find context and type in CDEvent Json");
            }
            String[] type = versionedEventType.split("\\.");
            String subject = type[2];
            String predicate = type[3];
            unVersionedEventType = "dev.cdevents." + subject + "." + predicate + ".";
            return unVersionedEventType;
        }
        catch (JsonProcessingException e) {
            throw new CDEventsException("Exception occurred while reading CDEvent Json for eventType ", e);
        }
    }
}

