/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.exception.CDEventsException;
import dev.cdevents.models.CDEvent;
import dev.cdevents.models.pipelinerun.finished.Content;
import dev.cdevents.models.pipelinerun.finished.Context;
import dev.cdevents.models.pipelinerun.finished.Pipelinerunfinished;
import dev.cdevents.models.pipelinerun.finished.Subject;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.UUID;

public class PipelinerunFinishedCDEvent
extends Pipelinerunfinished
implements CDEvent {
    public PipelinerunFinishedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().setType(Subject.Type.PIPELINE_RUN);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/pipeline-run-finished-event";
    }

    @Override
    public String eventSchema() {
        try {
            return Files.readString(Paths.get(CDEventConstants.SCHEMA_FOLDER + "/pipelinerunfinished.json", new String[0]));
        }
        catch (IOException e) {
            throw new CDEventsException("Exception while reading Event JsonSchema file ", e);
        }
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectPipelineName(String pipelineName) {
        this.getSubject().getContent().setPipelineName(pipelineName);
    }

    public void setSubjectUrl(String url) {
        this.getSubject().getContent().setUrl(url);
    }

    public void setSubjectOutcome(String outcome) {
        this.getSubject().getContent().setOutcome(outcome);
    }

    public void setSubjectErrors(String errors) {
        this.getSubject().getContent().setErrors(errors);
    }
}

