/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.exception.CDEventsException;
import dev.cdevents.models.CDEvent;
import dev.cdevents.models.testoutput.published.Content;
import dev.cdevents.models.testoutput.published.Context;
import dev.cdevents.models.testoutput.published.Subject;
import dev.cdevents.models.testoutput.published.TestCaseRun;
import dev.cdevents.models.testoutput.published.Testoutputpublished;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.UUID;

public class TestoutputPublishedCDEvent
extends Testoutputpublished
implements CDEvent {
    public TestoutputPublishedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setTestCaseRun(new TestCaseRun());
        this.getSubject().setType(Subject.Type.TEST_OUTPUT);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/test-output-published-event";
    }

    @Override
    public String eventSchema() {
        try {
            return Files.readString(Paths.get(CDEventConstants.SCHEMA_FOLDER + "/testoutputpublished.json", new String[0]));
        }
        catch (IOException e) {
            throw new CDEventsException("Exception while reading Event JsonSchema file ", e);
        }
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectOutputType(Content.OutputType outputType) {
        this.getSubject().getContent().setOutputType(outputType);
    }

    public void setSubjectFormat(String format) {
        this.getSubject().getContent().setFormat(format);
    }

    public void setSubjectUri(URI uri) {
        this.getSubject().getContent().setUri(uri);
    }

    public void setSubjectTestCaseRunId(String id) {
        this.getSubject().getContent().getTestCaseRun().setId(id);
    }

    public void setSubjectTestCaseRunSource(String source) {
        this.getSubject().getContent().getTestCaseRun().setSource(source);
    }
}

