/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.models.testoutput.published;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.cdevents.models.testoutput.published.TestCaseRun;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"outputType", "format", "uri", "testCaseRun"})
public class Content {
    @JsonProperty(value="outputType")
    private OutputType outputType;
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="uri")
    private URI uri;
    @JsonProperty(value="testCaseRun")
    private TestCaseRun testCaseRun;

    @JsonProperty(value="outputType")
    public OutputType getOutputType() {
        return this.outputType;
    }

    @JsonProperty(value="outputType")
    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    @JsonProperty(value="format")
    public String getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    public void setFormat(String format) {
        this.format = format;
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @JsonProperty(value="testCaseRun")
    public TestCaseRun getTestCaseRun() {
        return this.testCaseRun;
    }

    @JsonProperty(value="testCaseRun")
    public void setTestCaseRun(TestCaseRun testCaseRun) {
        this.testCaseRun = testCaseRun;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.format == null ? 0 : this.format.hashCode());
        result = result * 31 + (this.outputType == null ? 0 : this.outputType.hashCode());
        result = result * 31 + (this.uri == null ? 0 : this.uri.hashCode());
        result = result * 31 + (this.testCaseRun == null ? 0 : this.testCaseRun.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Content)) {
            return false;
        }
        Content rhs = (Content)other;
        return (this.format == rhs.format || this.format != null && this.format.equals(rhs.format)) && (this.outputType == rhs.outputType || this.outputType != null && this.outputType.equals((Object)rhs.outputType)) && (this.uri == rhs.uri || this.uri != null && this.uri.equals(rhs.uri)) && (this.testCaseRun == rhs.testCaseRun || this.testCaseRun != null && this.testCaseRun.equals(rhs.testCaseRun));
    }

    public static enum OutputType {
        REPORT("report"),
        VIDEO("video"),
        IMAGE("image"),
        LOG("log"),
        OTHER("other");

        private final String value;
        private static final Map<String, OutputType> CONSTANTS;

        private OutputType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OutputType fromValue(String value) {
            OutputType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OutputType>();
            for (OutputType c : OutputType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

