/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.models.testsuiterun.finished;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.cdevents.models.testsuiterun.finished.Environment;
import dev.cdevents.models.testsuiterun.finished.TestSuite;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"environment", "testSuite", "outcome", "severity", "reason"})
public class Content {
    @JsonProperty(value="environment")
    private Environment environment;
    @JsonProperty(value="testSuite")
    private TestSuite testSuite;
    @JsonProperty(value="outcome")
    private Outcome outcome;
    @JsonProperty(value="severity")
    private Severity severity;
    @JsonProperty(value="reason")
    private String reason;

    @JsonProperty(value="environment")
    public Environment getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @JsonProperty(value="testSuite")
    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    @JsonProperty(value="testSuite")
    public void setTestSuite(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    @JsonProperty(value="outcome")
    public Outcome getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    @JsonProperty(value="severity")
    public Severity getSeverity() {
        return this.severity;
    }

    @JsonProperty(value="severity")
    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.severity == null ? 0 : this.severity.hashCode());
        result = result * 31 + (this.reason == null ? 0 : this.reason.hashCode());
        result = result * 31 + (this.environment == null ? 0 : this.environment.hashCode());
        result = result * 31 + (this.testSuite == null ? 0 : this.testSuite.hashCode());
        result = result * 31 + (this.outcome == null ? 0 : this.outcome.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Content)) {
            return false;
        }
        Content rhs = (Content)other;
        return (this.severity == rhs.severity || this.severity != null && this.severity.equals((Object)rhs.severity)) && (this.reason == rhs.reason || this.reason != null && this.reason.equals(rhs.reason)) && (this.environment == rhs.environment || this.environment != null && this.environment.equals(rhs.environment)) && (this.testSuite == rhs.testSuite || this.testSuite != null && this.testSuite.equals(rhs.testSuite)) && (this.outcome == rhs.outcome || this.outcome != null && this.outcome.equals((Object)rhs.outcome));
    }

    public static enum Severity {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        CRITICAL("critical");

        private final String value;
        private static final Map<String, Severity> CONSTANTS;

        private Severity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Severity fromValue(String value) {
            Severity constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Severity>();
            for (Severity c : Severity.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Outcome {
        PASS("pass"),
        FAIL("fail"),
        CANCEL("cancel"),
        ERROR("error");

        private final String value;
        private static final Map<String, Outcome> CONSTANTS;

        private Outcome(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Outcome fromValue(String value) {
            Outcome constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Outcome>();
            for (Outcome c : Outcome.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

