/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjln;

import dev.felnull.fnjl.os.OSs;
import dev.felnull.fnjl.util.FNDataUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FelNullJavaLibraryNative {
    private static boolean init;
    private static boolean loaded;

    public static synchronized void init() {
        String tempDir = System.getProperty("java.io.tmpdir");
        Path path = Paths.get(tempDir, new String[0]).resolve("fnjl_natives");
        path.toFile().mkdirs();
        FelNullJavaLibraryNative.init(path);
    }

    public static synchronized void init(Path libraryPath) {
        FelNullJavaLibraryNative.init("dev/felnull/fnjln/natives/", libraryPath);
    }

    public static synchronized void init(String libraryLocation, Path libraryPath) {
        if (init) {
            return;
        }
        if (libraryPath == null) {
            init = true;
            return;
        }
        OSs.Type os = OSs.getOS();
        String arch = OSs.getArch();
        String libName = String.format("FNJLNative_%s.%s", arch, os.getLibName());
        String outLibName = String.format("FNJLNative_%s%s.%s", FelNullJavaLibraryNative.getNativeLibraryVersion(), arch, os.getLibName());
        File outLibFIle = libraryPath.resolve(outLibName).toFile();
        if (outLibFIle.exists() && FelNullJavaLibraryNative.loadLibrary(outLibFIle)) {
            loaded = true;
            init = true;
            return;
        }
        InputStream stream = FNDataUtil.resourceExtractor(FelNullJavaLibraryNative.class, (String)(libraryLocation + libName));
        if (stream != null) {
            stream = new BufferedInputStream(stream);
            try {
                byte[] data = FNDataUtil.streamToByteArray((InputStream)stream);
                outLibFIle.delete();
                Files.write(outLibFIle.toPath(), data, new OpenOption[0]);
                loaded = FelNullJavaLibraryNative.loadLibrary(outLibFIle);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        init = true;
    }

    private static boolean loadLibrary(File file) {
        try {
            System.load(file.getAbsolutePath());
            return true;
        }
        catch (UnsatisfiedLinkError er) {
            er.printStackTrace();
            return false;
        }
    }

    public static boolean isInitialized() {
        return init;
    }

    public static boolean isLoadedSuccess() {
        return init && loaded;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static String getVersion() {
        return "1.35";
    }

    public static int getNativeLibraryVersion() {
        return 1;
    }

    public static void check() {
        if (!FelNullJavaLibraryNative.isInitialized()) {
            throw new RuntimeException("Library not initialized");
        }
        if (!FelNullJavaLibraryNative.isLoaded()) {
            throw new RuntimeException("Library not loaded");
        }
    }
}

