/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebasePlatform;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthKt;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserImpl;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.internal.InternalTokenResult;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 j2\u00020\u0001:\u0003ijkB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\tJ\u000e\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0013J\u0010\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0015H\u0016J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020*0.2\u0006\u0010/\u001a\u00020\u001cJ\u0014\u00100\u001a\b\u0012\u0004\u0012\u0002010.2\u0006\u0010/\u001a\u00020\u001cJ\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020*0.2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u001cJ\u001c\u00104\u001a\b\u0012\u0004\u0012\u0002050.2\u0006\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u001cJ\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010#\u001a\u00020!H\u0002J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020:0.2\u0006\u00106\u001a\u00020\u001cJ%\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAJ\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0.2\u0006\u0010D\u001a\u00020EH\u0016J\n\u0010F\u001a\u0004\u0018\u00010\u001cH\u0016J\u000e\u0010G\u001a\u00020E2\u0006\u0010H\u001a\u00020\u001cJN\u0010I\u001a\u00020*\"\u0004\b\u0000\u0010J2\u0006\u0010#\u001a\u00020!2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ0 2#\u0010L\u001a\u001f\u0012\u0013\u0012\u00110!\u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(#\u0012\u0006\u0012\u0004\u0018\u0001HJ0MH\u0000\u00a2\u0006\u0002\bPJ\u000e\u0010Q\u001a\u00020*2\u0006\u0010+\u001a\u00020\tJ\u000e\u0010R\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0013J\u0010\u0010R\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0015H\u0016J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020*0.2\u0006\u00106\u001a\u00020\u001c2\b\u0010T\u001a\u0004\u0018\u00010UJ\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020*0.2\u0006\u00106\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020UJ\u000e\u0010X\u001a\u00020Y2\u0006\u0010\"\u001a\u00020\u001cJ\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002050.J\u0014\u0010[\u001a\b\u0012\u0004\u0012\u0002050.2\u0006\u0010\\\u001a\u00020]J\u0014\u0010^\u001a\b\u0012\u0004\u0012\u0002050.2\u0006\u0010_\u001a\u00020\u001cJ\u001c\u0010`\u001a\b\u0012\u0004\u0012\u0002050.2\u0006\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u001cJ\u001c\u0010a\u001a\b\u0012\u0004\u0012\u0002050.2\u0006\u00106\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020\u001cJ\u0006\u0010b\u001a\u00020*J\u0014\u0010c\u001a\b\u0012\u0004\u0012\u00020*0.2\u0006\u0010#\u001a\u00020\u000fJ\u0016\u0010d\u001a\u00020*2\u0006\u0010e\u001a\u00020\u001c2\u0006\u0010f\u001a\u00020gJ\u0014\u0010h\u001a\b\u0012\u0004\u0012\u00020\u001c0.2\u0006\u0010/\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010#\u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b$\u0010%R\u0015\u0010&\u001a\u00020\u001c*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006l"}, d2={"Lcom/google/firebase/auth/FirebaseAuth;", "Lcom/google/firebase/auth/internal/InternalAuthProvider;", "app", "Lcom/google/firebase/FirebaseApp;", "(Lcom/google/firebase/FirebaseApp;)V", "getApp", "()Lcom/google/firebase/FirebaseApp;", "authStateListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/google/firebase/auth/FirebaseAuth$AuthStateListener;", "client", "Lcom/squareup/okhttp/OkHttpClient;", "getClient", "()Lcom/squareup/okhttp/OkHttpClient;", "currentUser", "Lcom/google/firebase/auth/FirebaseUser;", "getCurrentUser", "()Lcom/google/firebase/auth/FirebaseUser;", "idTokenListeners", "Lcom/google/firebase/auth/FirebaseAuth$IdTokenListener;", "internalIdTokenListeners", "Lcom/google/firebase/auth/internal/IdTokenListener;", "json", "Lcom/squareup/okhttp/MediaType;", "kotlin.jvm.PlatformType", "getJson", "()Lcom/squareup/okhttp/MediaType;", "languageCode", "", "getLanguageCode", "()Ljava/lang/String;", "refreshSource", "Lcom/google/android/gms/tasks/TaskCompletionSource;", "Lcom/google/firebase/auth/FirebaseUserImpl;", "value", "user", "setUser", "(Lcom/google/firebase/auth/FirebaseUserImpl;)V", "key", "getKey", "(Lcom/google/firebase/FirebaseApp;)Ljava/lang/String;", "addAuthStateListener", "", "listener", "addIdTokenListener", "applyActionCode", "Lcom/google/android/gms/tasks/Task;", "code", "checkActionCode", "Lcom/google/firebase/auth/ActionCodeResult;", "confirmPasswordReset", "newPassword", "createUserWithEmailAndPassword", "Lcom/google/firebase/auth/AuthResult;", "email", "password", "enqueueRefreshTokenCall", "fetchSignInMethodsForEmail", "Lcom/google/firebase/auth/SignInMethodQueryResult;", "formatErrorMessage", "title", "request", "Lcom/squareup/okhttp/Request;", "response", "Lcom/squareup/okhttp/Response;", "formatErrorMessage$firebase_java_sdk", "getAccessToken", "Lcom/google/firebase/auth/GetTokenResult;", "forceRefresh", "", "getUid", "isSignInWithEmailLink", "link", "refreshToken", "T", "source", "map", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "refreshToken$firebase_java_sdk", "removeAuthStateListener", "removeIdTokenListener", "sendPasswordResetEmail", "settings", "Lcom/google/firebase/auth/ActionCodeSettings;", "sendSignInLinkToEmail", "actionCodeSettings", "setLanguageCode", "", "signInAnonymously", "signInWithCredential", "authCredential", "Lcom/google/firebase/auth/AuthCredential;", "signInWithCustomToken", "customToken", "signInWithEmailAndPassword", "signInWithEmailLink", "signOut", "updateCurrentUser", "useEmulator", "host", "port", "", "verifyPasswordResetCode", "AuthStateListener", "Companion", "IdTokenListener", "firebase-java-sdk"})
public final class FirebaseAuth
implements InternalAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirebaseApp app;
    private final MediaType json;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener> internalIdTokenListeners;
    @NotNull
    private final CopyOnWriteArrayList<IdTokenListener> idTokenListeners;
    @NotNull
    private final CopyOnWriteArrayList<AuthStateListener> authStateListeners;
    @Nullable
    private FirebaseUserImpl user;
    @NotNull
    private TaskCompletionSource<FirebaseUserImpl> refreshSource;

    /*
     * WARNING - void declaration
     */
    public FirebaseAuth(@NotNull FirebaseApp app) {
        void $this$refreshSource_u24lambda_u2d5;
        TaskCompletionSource taskCompletionSource;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.app = app;
        this.json = MediaType.parse((String)"application/json; charset=utf-8");
        this.client = new OkHttpClient();
        this.internalIdTokenListeners = new CopyOnWriteArrayList();
        this.idTokenListeners = new CopyOnWriteArrayList();
        this.authStateListeners = new CopyOnWriteArrayList();
        TaskCompletionSource taskCompletionSource2 = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk();
        FirebaseAuth firebaseAuth = this;
        try {
            FirebaseUserImpl firebaseUserImpl;
            FirebasePlatform $this$user_u24lambda_u2d2 = taskCompletionSource2;
            boolean bl = false;
            String string = $this$user_u24lambda_u2d2.retrieve(this.getKey(this.getApp()));
            if (string == null) {
                firebaseUserImpl = null;
            } else {
                String it = string;
                boolean bl2 = false;
                firebaseUserImpl = new FirebaseUserImpl(this.getApp(), JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(it)), false, 4, null);
            }
            taskCompletionSource = Result.constructor-impl(firebaseUserImpl);
        }
        catch (Throwable $this$user_u24lambda_u2d2) {
            taskCompletionSource = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$user_u24lambda_u2d2));
        }
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        taskCompletionSource2 = taskCompletionSource;
        Throwable throwable = Result.exceptionOrNull-impl((Object)taskCompletionSource2);
        if (throwable != null) {
            void it;
            Throwable throwable2 = throwable;
            firebaseAuth = firebaseAuth2;
            boolean bl = false;
            it.printStackTrace();
            firebaseAuth2 = firebaseAuth;
        }
        firebaseAuth2.user = (FirebaseUserImpl)((Object)(Result.isFailure-impl((Object)taskCompletionSource2) ? null : taskCompletionSource2));
        this.client.setConnectTimeout(60L, TimeUnit.SECONDS);
        this.client.setReadTimeout(60L, TimeUnit.SECONDS);
        this.client.setWriteTimeout(60L, TimeUnit.SECONDS);
        taskCompletionSource = taskCompletionSource2 = new TaskCompletionSource();
        firebaseAuth = this;
        boolean bl = false;
        $this$refreshSource_u24lambda_u2d5.setException(new Exception());
        firebaseAuth.refreshSource = taskCompletionSource2;
    }

    @NotNull
    public final FirebaseApp getApp() {
        return this.app;
    }

    public final MediaType getJson() {
        return this.json;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @Nullable
    public final FirebaseUser getCurrentUser() {
        return this.user;
    }

    @NotNull
    public final String getKey(@NotNull FirebaseApp $this$key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        String it = string = "[" + $this$key.getName() + "]";
        boolean bl = false;
        Object object = !$this$key.isDefaultApp() ? string : null;
        if (object == null) {
            object = "";
        }
        return "com.google.firebase.auth.FIREBASE_USER" + (String)object;
    }

    private final void setUser(FirebaseUserImpl value) {
        if (!Intrinsics.areEqual((Object)this.user, (Object)value)) {
            FirebaseUserImpl prev = this.user;
            this.user = value;
            if (value == null) {
                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().clear(this.getKey(this.app));
            } else {
                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(this.getKey(this.app), FirebaseAuthKt.getJsonParser().encodeToString((SerializationStrategy)FirebaseUserImpl.Companion.serializer(), (Object)value));
            }
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(prev, value, this, null){
                int label;
                final /* synthetic */ FirebaseUserImpl $prev;
                final /* synthetic */ FirebaseUserImpl $value;
                final /* synthetic */ FirebaseAuth this$0;
                {
                    this.$prev = $prev;
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FirebaseUserImpl firebaseUserImpl = this.$prev;
                            FirebaseUserImpl firebaseUserImpl2 = this.$value;
                            if (!Intrinsics.areEqual((Object)(firebaseUserImpl == null ? null : firebaseUserImpl.getUid()), (Object)(firebaseUserImpl2 == null ? null : firebaseUserImpl2.getUid()))) {
                                void $this$forEach$iv;
                                Iterable iterable = FirebaseAuth.access$getAuthStateListeners$p(this.this$0);
                                Iterator<E> iterator = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    AuthStateListener l = (AuthStateListener)element$iv;
                                    boolean bl = false;
                                    l.onAuthStateChanged((FirebaseAuth)((Object)iterator));
                                }
                            }
                            FirebaseUserImpl firebaseUserImpl3 = this.$prev;
                            FirebaseUserImpl firebaseUserImpl4 = this.$value;
                            if (!Intrinsics.areEqual((Object)(firebaseUserImpl3 == null ? null : firebaseUserImpl3.getIdToken()), (Object)(firebaseUserImpl4 == null ? null : firebaseUserImpl4.getIdToken()))) {
                                FirebaseUserImpl firebaseUserImpl5 = this.$value;
                                InternalTokenResult result = new InternalTokenResult((String)(firebaseUserImpl5 == null ? null : firebaseUserImpl5.getIdToken()));
                                for (com.google.firebase.auth.internal.IdTokenListener listener : FirebaseAuth.access$getInternalIdTokenListeners$p(this.this$0)) {
                                    FirebaseUserImpl firebaseUserImpl6 = this.$value;
                                    Log.i("FirebaseAuth", "Calling onIdTokenChanged for " + (String)(firebaseUserImpl6 == null ? null : firebaseUserImpl6.getUid()) + " on listener " + listener);
                                    listener.onIdTokenChanged(result);
                                }
                                for (IdTokenListener listener : FirebaseAuth.access$getIdTokenListeners$p(this.this$0)) {
                                    listener.onIdTokenChanged(this.this$0);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @NotNull
    public final Task<AuthResult> signInAnonymously() {
        TaskCompletionSource<AuthResult> source = new TaskCompletionSource<AuthResult>();
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true)))).toString());
        Request request = new Request.Builder().url("https://identitytoolkit.googleapis.com/v1/accounts:signUp?key=" + this.app.getOptions().getApiKey()).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request){
            final /* synthetic */ TaskCompletionSource<AuthResult> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onFailure(@NotNull Request request, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    String string = response.message();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.message()");
                    String string2 = string;
                    string = this.$request;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request");
                    this.$source.setException(new FirebaseAuthInvalidUserException(string2, this.this$0.formatErrorMessage$firebase_java_sdk("accounts:signUp", (Request)string, response)));
                } else {
                    String string;
                    Closeable closeable = (Closeable)response.body();
                    Throwable throwable = null;
                    try {
                        ResponseBody it = (ResponseBody)closeable;
                        boolean bl = false;
                        string = it.string();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String body = string;
                    FirebaseApp firebaseApp = this.this$0.getApp();
                    Json json = FirebaseAuthKt.getJsonParser();
                    Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
                    FirebaseAuth.access$setUser(this.this$0, new FirebaseUserImpl(firebaseApp, JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(body)), true));
                    this.$source.setResult(() -> signInAnonymously.1.onResponse$lambda-1(this.this$0));
                }
            }

            private static final FirebaseUser onResponse$lambda-1(FirebaseAuth this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return FirebaseAuth.access$getUser$p(this$0);
            }
        });
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"source.task");
        return task;
    }

    @NotNull
    public final Task<AuthResult> signInWithCustomToken(@NotNull String customToken) {
        Intrinsics.checkNotNullParameter((Object)customToken, (String)"customToken");
        TaskCompletionSource<AuthResult> source = new TaskCompletionSource<AuthResult>();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"token", (Object)JsonElementKt.JsonPrimitive((String)customToken)), TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true))};
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request request = new Request.Builder().url("https://www.googleapis.com/identitytoolkit/v3/relyingparty/verifyCustomToken?key=" + this.app.getOptions().getApiKey()).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request){
            final /* synthetic */ TaskCompletionSource<AuthResult> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onFailure(@NotNull Request request, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    String string = response.message();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.message()");
                    String string2 = string;
                    string = this.$request;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request");
                    this.$source.setException(new FirebaseAuthInvalidUserException(string2, this.this$0.formatErrorMessage$firebase_java_sdk("verifyCustomToken", (Request)string, response)));
                } else {
                    String string;
                    Closeable closeable = (Closeable)response.body();
                    Throwable throwable = null;
                    try {
                        ResponseBody it = (ResponseBody)closeable;
                        boolean bl = false;
                        string = it.string();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String body = string;
                    FirebaseApp firebaseApp = this.this$0.getApp();
                    Json json = FirebaseAuthKt.getJsonParser();
                    Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
                    FirebaseUserImpl user2 = new FirebaseUserImpl(firebaseApp, JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(body)), false, 4, null);
                    this.this$0.refreshToken$firebase_java_sdk(user2, this.$source, signInWithCustomToken.onResponse.1.INSTANCE);
                }
            }
        });
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"source.task");
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String formatErrorMessage$firebase_java_sdk(@NotNull String title, @NotNull Request request, @NotNull Response response) {
        String string;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Closeable closeable = (Closeable)response.body();
        String string2 = response.message();
        int n = response.code();
        RequestBody requestBody = request.body();
        String string3 = request.urlString();
        String string4 = request.method();
        String string5 = title;
        Throwable throwable = null;
        try {
            ResponseBody it = (ResponseBody)closeable;
            boolean bl = false;
            string = it.string();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string6 = string;
        return string5 + " API returned an error, with url [" + string4 + "] " + string3 + " " + requestBody + " -- response [" + n + "] " + string2 + " " + string6;
    }

    public final void signOut() {
        this.setUser(null);
    }

    @Override
    @NotNull
    public Task<GetTokenResult> getAccessToken(boolean forceRefresh) {
        TaskCompletionSource source = new TaskCompletionSource();
        FirebaseUserImpl firebaseUserImpl = this.user;
        if (firebaseUserImpl == null) {
            Task<GetTokenResult> task = Tasks.forException(new FirebaseNoSignedInUserException("Please sign in before trying to get a token."));
            Intrinsics.checkNotNullExpressionValue(task, (String)"forException(FirebaseNoS\u2026trying to get a token.\"))");
            return task;
        }
        FirebaseUserImpl user2 = firebaseUserImpl;
        if (!forceRefresh || (double)user2.getCreatedAt() + (double)(user2.getExpiresIn() * 1000) * 0.9 > (double)System.currentTimeMillis()) {
            Task<GetTokenResult> task = Tasks.forResult(new GetTokenResult(user2.getIdToken(), user2.getClaims()));
            Intrinsics.checkNotNullExpressionValue(task, (String)"forResult(GetTokenResult\u2026er.idToken, user.claims))");
            return task;
        }
        this.refreshToken$firebase_java_sdk(user2, source, (Function1)new Function1<FirebaseUserImpl, GetTokenResult>(user2){
            final /* synthetic */ FirebaseUserImpl $user;
            {
                this.$user = $user;
                super(1);
            }

            @Nullable
            public final GetTokenResult invoke(@NotNull FirebaseUserImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new GetTokenResult(it.getIdToken(), this.$user.getClaims());
            }
        });
        Task<GetTokenResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"source.task");
        return task;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void refreshToken$firebase_java_sdk(@NotNull FirebaseUserImpl user2, @NotNull TaskCompletionSource<T> source, @NotNull Function1<? super FirebaseUserImpl, ? extends T> map) {
        void it;
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource;
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource2 = taskCompletionSource = this.refreshSource;
        FirebaseAuth firebaseAuth = this;
        boolean bl = false;
        boolean bl2 = it.getTask().isComplete();
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource3 = !bl2 ? taskCompletionSource : null;
        firebaseAuth.refreshSource = taskCompletionSource3 == null ? this.enqueueRefreshTokenCall(user2) : taskCompletionSource3;
        this.refreshSource.getTask().addOnSuccessListener(arg_0 -> FirebaseAuth.refreshToken$lambda-7(source, map, arg_0));
        this.refreshSource.getTask().addOnFailureListener(arg_0 -> FirebaseAuth.refreshToken$lambda-8(source, arg_0));
    }

    private final TaskCompletionSource<FirebaseUserImpl> enqueueRefreshTokenCall(FirebaseUserImpl user2) {
        TaskCompletionSource<FirebaseUserImpl> source = new TaskCompletionSource<FirebaseUserImpl>();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"refresh_token", (Object)JsonElementKt.JsonPrimitive((String)user2.getRefreshToken())), TuplesKt.to((Object)"grant_type", (Object)JsonElementKt.JsonPrimitive((String)"refresh_token"))};
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request request = new Request.Builder().url("https://securetoken.googleapis.com/v1/token?key=" + this.app.getOptions().getApiKey()).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, user2){
            final /* synthetic */ TaskCompletionSource<FirebaseUserImpl> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ FirebaseUserImpl $user;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$user = $user;
            }

            public void onFailure(@NotNull Request request, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Closeable closeable = (Closeable)response.body();
                FirebaseAuth firebaseAuth = this.this$0;
                FirebaseUserImpl firebaseUserImpl = this.$user;
                TaskCompletionSource<FirebaseUserImpl> taskCompletionSource = this.$source;
                Throwable throwable = null;
                try {
                    Object object;
                    ResponseBody body = (ResponseBody)closeable;
                    boolean bl = false;
                    if (!response.isSuccessful()) {
                        String it = body.string();
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.signOutAndThrowInvalidUserException(it, "token API returned an error: " + it);
                        object = Unit.INSTANCE;
                    } else {
                        Json json = FirebaseAuthKt.getJsonParser();
                        String string = body.string();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.string()");
                        String $this$onResponse_u24lambda_u2d2_u24lambda_u2d1 = string = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(string));
                        boolean bl3 = false;
                        FirebaseUserImpl user2 = new FirebaseUserImpl(firebaseAuth.getApp(), (JsonObject)$this$onResponse_u24lambda_u2d2_u24lambda_u2d1, firebaseUserImpl.isAnonymous());
                        if (!Intrinsics.areEqual((Object)user2.getClaims().get("aud"), (Object)firebaseAuth.getApp().getOptions().getProjectId())) {
                            this.signOutAndThrowInvalidUserException(user2.getClaims().toString(), "Project ID's do not match " + user2.getClaims().get("aud") + " != " + firebaseAuth.getApp().getOptions().getProjectId());
                        } else {
                            FirebaseAuth.access$setUser(firebaseAuth, user2);
                            taskCompletionSource.setResult(user2);
                        }
                        object = string;
                    }
                    Unit unit = object;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            private final void signOutAndThrowInvalidUserException(String body, String message) {
                this.this$0.signOut();
                this.$source.setException(new FirebaseAuthInvalidUserException(body, message));
            }
        });
        return source;
    }

    @Override
    @Nullable
    public String getUid() {
        FirebaseUserImpl firebaseUserImpl = this.user;
        return firebaseUserImpl == null ? null : firebaseUserImpl.getUid();
    }

    @Override
    public void addIdTokenListener(@NotNull com.google.firebase.auth.internal.IdTokenListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.internalIdTokenListeners.addIfAbsent(listener);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener, this, null){
            int label;
            final /* synthetic */ com.google.firebase.auth.internal.IdTokenListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FirebaseUserImpl firebaseUserImpl = FirebaseAuth.access$getUser$p(this.this$0);
                        this.$listener.onIdTokenChanged(new InternalTokenResult((String)(firebaseUserImpl == null ? null : firebaseUserImpl.getIdToken())));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void removeIdTokenListener(@NotNull com.google.firebase.auth.internal.IdTokenListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.internalIdTokenListeners.remove(listener);
    }

    public final synchronized void addAuthStateListener(@NotNull AuthStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.authStateListeners.addIfAbsent(listener);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener, this, null){
            int label;
            final /* synthetic */ AuthStateListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$listener.onAuthStateChanged(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final synchronized void removeAuthStateListener(@NotNull AuthStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.authStateListeners.remove(listener);
    }

    public final void addIdTokenListener(@NotNull IdTokenListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.idTokenListeners.addIfAbsent(listener);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener, this, null){
            int label;
            final /* synthetic */ IdTokenListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$listener.onIdTokenChanged(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void removeIdTokenListener(@NotNull IdTokenListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.idTokenListeners.remove(listener);
    }

    @NotNull
    public final Task<AuthResult> signInWithEmailAndPassword(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> sendPasswordResetEmail(@NotNull String email, @Nullable ActionCodeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> createUserWithEmailAndPassword(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> signInWithCredential(@NotNull AuthCredential authCredential) {
        Intrinsics.checkNotNullParameter((Object)authCredential, (String)"authCredential");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<ActionCodeResult> checkActionCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> confirmPasswordReset(@NotNull String code, @NotNull String newPassword) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> sendSignInLinkToEmail(@NotNull String email, @NotNull ActionCodeSettings actionCodeSettings) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)actionCodeSettings, (String)"actionCodeSettings");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<String> verifyPasswordResetCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> updateCurrentUser(@NotNull FirebaseUser user2) {
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> applyActionCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final String getLanguageCode() {
        throw new NotImplementedError(null, 1, null);
    }

    public final boolean isSignInWithEmailLink(@NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> signInWithEmailLink(@NotNull String email, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Void setLanguageCode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new NotImplementedError(null, 1, null);
    }

    public final void useEmulator(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        throw new NotImplementedError(null, 1, null);
    }

    private static final void refreshToken$lambda-7(TaskCompletionSource $source, Function1 $map, FirebaseUserImpl it) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $source.setResult($map.invoke((Object)it));
    }

    private static final void refreshToken$lambda-8(TaskCompletionSource $source, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $source.setException(it);
    }

    @JvmStatic
    @NotNull
    public static final FirebaseAuth getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final FirebaseAuth getInstance(@NotNull FirebaseApp app) {
        return Companion.getInstance(app);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getAuthStateListeners$p(FirebaseAuth $this) {
        return $this.authStateListeners;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getInternalIdTokenListeners$p(FirebaseAuth $this) {
        return $this.internalIdTokenListeners;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getIdTokenListeners$p(FirebaseAuth $this) {
        return $this.idTokenListeners;
    }

    public static final /* synthetic */ void access$setUser(FirebaseAuth $this, FirebaseUserImpl value) {
        $this.setUser(value);
    }

    public static final /* synthetic */ FirebaseUserImpl access$getUser$p(FirebaseAuth $this) {
        return $this.user;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$Companion;", "", "()V", "getInstance", "Lcom/google/firebase/auth/FirebaseAuth;", "app", "Lcom/google/firebase/FirebaseApp;", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FirebaseAuth getInstance() {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)firebaseApp, (String)"getInstance()");
            return this.getInstance(firebaseApp);
        }

        @JvmStatic
        @NotNull
        public final FirebaseAuth getInstance(@NotNull FirebaseApp app) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            FirebaseAuth firebaseAuth = app.get(FirebaseAuth.class);
            Intrinsics.checkNotNullExpressionValue((Object)firebaseAuth, (String)"app.get(FirebaseAuth::class.java)");
            return firebaseAuth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @FunctionalInterface
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$AuthStateListener;", "", "onAuthStateChanged", "", "auth", "Lcom/google/firebase/auth/FirebaseAuth;", "firebase-java-sdk"})
    public static interface AuthStateListener {
        public void onAuthStateChanged(@NotNull FirebaseAuth var1);
    }

    @FunctionalInterface
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$IdTokenListener;", "", "onIdTokenChanged", "", "auth", "Lcom/google/firebase/auth/FirebaseAuth;", "firebase-java-sdk"})
    public static interface IdTokenListener {
        public void onIdTokenChanged(@NotNull FirebaseAuth var1);
    }
}

