/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.android;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.database.core.TokenProvider;
import com.google.firebase.inject.Deferred;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class AndroidAppCheckTokenProvider
implements TokenProvider {
    private final Deferred<InternalAppCheckTokenProvider> deferredAppCheckProvider;
    private final AtomicReference<InternalAppCheckTokenProvider> internalAppCheck;

    public AndroidAppCheckTokenProvider(Deferred<InternalAppCheckTokenProvider> deferredAppCheckProvider) {
        this.deferredAppCheckProvider = deferredAppCheckProvider;
        this.internalAppCheck = new AtomicReference();
        deferredAppCheckProvider.whenAvailable(authProvider -> this.internalAppCheck.set((InternalAppCheckTokenProvider)authProvider.get()));
    }

    @Override
    public void getToken(boolean forceRefresh, @NonNull TokenProvider.GetTokenCompletionListener listener) {
        InternalAppCheckTokenProvider appCheckProvider = this.internalAppCheck.get();
        if (appCheckProvider != null) {
            Task<AppCheckTokenResult> getTokenResult = appCheckProvider.getToken(forceRefresh);
            getTokenResult.addOnSuccessListener(result -> listener.onSuccess(result.getToken())).addOnFailureListener(e -> listener.onError(e.getMessage()));
        } else {
            listener.onSuccess(null);
        }
    }

    @Override
    public void addTokenChangeListener(ExecutorService executorService, TokenProvider.TokenChangeListener tokenListener) {
        this.deferredAppCheckProvider.whenAvailable(provider -> ((InternalAppCheckTokenProvider)provider.get()).addAppCheckTokenListener(tokenResult -> executorService.execute(() -> tokenListener.onTokenChange(tokenResult.getToken()))));
    }

    @Override
    public void removeTokenChangeListener(TokenProvider.TokenChangeListener tokenListener) {
    }
}

