/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalDocumentsResult;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class IndexBackfiller {
    private static final String LOG_TAG = "IndexBackfiller";
    private static final long INITIAL_BACKFILL_DELAY_MS = TimeUnit.SECONDS.toMillis(15L);
    private static final long REGULAR_BACKFILL_DELAY_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final int MAX_DOCUMENTS_TO_PROCESS = 50;
    private final Scheduler scheduler;
    private final Persistence persistence;
    private LocalDocumentsView localDocumentsView;
    private IndexManager indexManager;
    private int maxDocumentsToProcess = 50;

    public IndexBackfiller(Persistence persistence, AsyncQueue asyncQueue) {
        this.persistence = persistence;
        this.scheduler = new Scheduler(asyncQueue);
    }

    public void setLocalDocumentsView(LocalDocumentsView localDocumentsView) {
        this.localDocumentsView = localDocumentsView;
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int backfill() {
        Assert.hardAssert(this.localDocumentsView != null, "setLocalDocumentsView() not called", new Object[0]);
        Assert.hardAssert(this.indexManager != null, "setIndexManager() not called", new Object[0]);
        return this.persistence.runTransaction("Backfill Indexes", () -> this.writeIndexEntries());
    }

    private int writeIndexEntries() {
        int documentsRemaining;
        String collectionGroup;
        HashSet<String> processedCollectionGroups = new HashSet<String>();
        for (documentsRemaining = this.maxDocumentsToProcess; documentsRemaining > 0 && (collectionGroup = this.indexManager.getNextCollectionGroupToUpdate()) != null && !processedCollectionGroups.contains(collectionGroup); documentsRemaining -= this.writeEntriesForCollectionGroup(collectionGroup, documentsRemaining)) {
            Logger.debug(LOG_TAG, "Processing collection: %s", collectionGroup);
            processedCollectionGroups.add(collectionGroup);
        }
        return this.maxDocumentsToProcess - documentsRemaining;
    }

    private int writeEntriesForCollectionGroup(String collectionGroup, int documentsRemainingUnderCap) {
        FieldIndex.IndexOffset existingOffset = this.indexManager.getMinOffset(collectionGroup);
        LocalDocumentsResult nextBatch = this.localDocumentsView.getNextDocuments(collectionGroup, existingOffset, documentsRemainingUnderCap);
        this.indexManager.updateIndexEntries(nextBatch.getDocuments());
        FieldIndex.IndexOffset newOffset = this.getNewOffset(existingOffset, nextBatch);
        Logger.debug(LOG_TAG, "Updating offset: %s", newOffset);
        this.indexManager.updateCollectionGroup(collectionGroup, newOffset);
        return nextBatch.getDocuments().size();
    }

    private FieldIndex.IndexOffset getNewOffset(FieldIndex.IndexOffset existingOffset, LocalDocumentsResult lookupResult) {
        FieldIndex.IndexOffset maxOffset = existingOffset;
        for (Map.Entry<DocumentKey, Document> entry : lookupResult.getDocuments()) {
            FieldIndex.IndexOffset newOffset = FieldIndex.IndexOffset.fromDocument(entry.getValue());
            if (newOffset.compareTo(maxOffset) <= 0) continue;
            maxOffset = newOffset;
        }
        return FieldIndex.IndexOffset.create(maxOffset.getReadTime(), maxOffset.getDocumentKey(), Math.max(lookupResult.getBatchId(), existingOffset.getLargestBatchId()));
    }

    @VisibleForTesting
    void setMaxDocumentsToProcess(int newMax) {
        this.maxDocumentsToProcess = newMax;
    }

    public class Scheduler
    implements com.google.firebase.firestore.local.Scheduler {
        private boolean hasRun = false;
        @Nullable
        private AsyncQueue.DelayedTask backfillTask;
        private final AsyncQueue asyncQueue;

        public Scheduler(AsyncQueue asyncQueue) {
            this.asyncQueue = asyncQueue;
        }

        @Override
        public void start() {
            this.scheduleBackfill();
        }

        @Override
        public void stop() {
            if (this.backfillTask != null) {
                this.backfillTask.cancel();
            }
        }

        private void scheduleBackfill() {
            long delay = this.hasRun ? REGULAR_BACKFILL_DELAY_MS : INITIAL_BACKFILL_DELAY_MS;
            this.backfillTask = this.asyncQueue.enqueueAfterDelay(AsyncQueue.TimerId.INDEX_BACKFILL, delay, () -> {
                int documentsProcessed = IndexBackfiller.this.backfill();
                Logger.debug(IndexBackfiller.LOG_TAG, "Documents written: %s", documentsProcessed);
                this.hasRun = true;
                this.scheduleBackfill();
            });
        }
    }
}

