/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzar;
import com.google.firebase.iid.zzf;
import com.google.firebase.iid.zzv;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

final class zzao {
    private static int zza = 0;
    private static PendingIntent zzb;
    @GuardedBy(value="responseCallbacks")
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zzc = new SimpleArrayMap();
    private final Context zzd;
    private final zzai zze;
    private Messenger zzf;
    private Messenger zzg;
    private zzf zzh;

    public zzao(Context context, zzai zzai2) {
        this.zzd = context;
        this.zze = zzai2;
        this.zzf = new Messenger(new zzar(this, Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zza(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(new zzf.zza());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof zzf) {
                    this.zzh = (zzf)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzg = (Messenger)((Object)parcelable);
                }
            }
            Intent intent2 = (Intent)message.obj;
            zzao zzao2 = this;
            String string2 = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string2)) {
                if (!Log.isLoggable("FirebaseInstanceId", 3)) return;
                String string3 = String.valueOf(string2);
                Log.d("FirebaseInstanceId", string3.length() != 0 ? "Unexpected response action: ".concat(string3) : new String("Unexpected response action: "));
                return;
            }
            String string4 = intent2.getStringExtra("registration_id");
            if (string4 == null) {
                string4 = intent2.getStringExtra("unregistered");
            }
            if (string4 == null) {
                Intent intent3 = intent2;
                zzao zzao3 = zzao2;
                String string5 = intent3.getStringExtra("error");
                if (string5 == null) {
                    String string6 = String.valueOf(intent3.getExtras());
                    Log.w("FirebaseInstanceId", new StringBuilder(49 + String.valueOf(string6).length()).append("Unexpected response, no error or registration id ").append(string6).toString());
                    return;
                }
                if (Log.isLoggable("FirebaseInstanceId", 3)) {
                    String string7 = String.valueOf(string5);
                    Log.d("FirebaseInstanceId", string7.length() != 0 ? "Received InstanceID error ".concat(string7) : new String("Received InstanceID error "));
                }
                if (string5.startsWith("|")) {
                    String[] stringArray = string5.split("\\|");
                    if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                        String string8 = String.valueOf(string5);
                        Log.w("FirebaseInstanceId", string8.length() != 0 ? "Unexpected structured response ".concat(string8) : new String("Unexpected structured response "));
                        return;
                    }
                    String string9 = stringArray[2];
                    string5 = stringArray[3];
                    if (string5.startsWith(":")) {
                        string5 = string5.substring(1);
                    }
                    zzao3.zza(string9, intent3.putExtra("error", string5).getExtras());
                    return;
                }
                SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = zzao3.zzc;
                synchronized (simpleArrayMap) {
                    int n = 0;
                    while (n < zzao3.zzc.size()) {
                        zzao3.zza((String)zzao3.zzc.keyAt(n), intent3.getExtras());
                        ++n;
                    }
                    return;
                }
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string4);
            if (matcher.matches()) {
                String string10 = matcher.group(1);
                String string11 = matcher.group(2);
                Bundle bundle = intent2.getExtras();
                bundle.putString("registration_id", string11);
                zzao2.zza(string10, bundle);
                return;
            }
            if (!Log.isLoggable("FirebaseInstanceId", 3)) return;
            String string12 = String.valueOf(string4);
            Log.d("FirebaseInstanceId", string12.length() != 0 ? "Unexpected response string: ".concat(string12) : new String("Unexpected response string: "));
            return;
        }
        Log.w("FirebaseInstanceId", "Dropping invalid message");
    }

    private static synchronized void zza(Context context, Intent intent) {
        if (zzb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzb = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string2, Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzc;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzc.remove((Object)string2);
            if (taskCompletionSource == null) {
                String string3 = String.valueOf(string2);
                Log.w("FirebaseInstanceId", string3.length() != 0 ? "Missing callback for ".concat(string3) : new String("Missing callback for "));
                return;
            }
            taskCompletionSource.setResult(bundle);
            return;
        }
    }

    final Bundle zza(Bundle bundle) throws IOException {
        if (this.zze.zzd() >= 12000000) {
            Task<Bundle> task = zzv.zza(this.zzd).zzb(1, bundle);
            try {
                return Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable("FirebaseInstanceId", 3)) {
                    String string2 = String.valueOf(exception);
                    Log.d("FirebaseInstanceId", new StringBuilder(22 + String.valueOf(string2).length()).append("Error making request: ").append(string2).toString());
                }
                if (exception.getCause() instanceof zzag && ((zzag)exception.getCause()).zza() == 4) {
                    return this.zzb(bundle);
                }
                return null;
            }
        }
        return this.zzb(bundle);
    }

    private final Bundle zzb(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zzc(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zzc(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zza() {
        return Integer.toString(zza++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzc(Bundle bundle) throws IOException {
        Object object;
        TaskCompletionSource taskCompletionSource;
        String string2;
        block26: {
            zzao zzao2;
            Intent intent;
            block27: {
                Object object2;
                string2 = zzao.zza();
                taskCompletionSource = new TaskCompletionSource();
                object = this.zzc;
                synchronized (object) {
                    this.zzc.put((Object)string2, taskCompletionSource);
                }
                String string3 = string2;
                Bundle bundle2 = bundle;
                zzao zzao3 = this;
                if (zzao3.zze.zza() == 0) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (zzao3.zze.zza() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle2);
                zzao.zza(zzao3.zzd, intent2);
                String string4 = string3;
                intent = intent2;
                zzao2 = zzao3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable("FirebaseInstanceId", 3)) {
                    object2 = String.valueOf(intent.getExtras());
                    Log.d("FirebaseInstanceId", new StringBuilder(8 + String.valueOf(object2).length()).append("Sending ").append((String)object2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)((Object)zzao2.zzf));
                if (zzao2.zzg != null || zzao2.zzh != null) {
                    object2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (zzao2.zzg != null) {
                            zzao2.zzg.send((Message)object2);
                        } else {
                            zzao2.zzh.zza((Message)object2);
                        }
                        break block26;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable("FirebaseInstanceId", 3)) break block27;
                        Log.d("FirebaseInstanceId", "Messenger failed, fallback to startService");
                    }
                }
            }
            if (zzao2.zze.zza() == 2) {
                zzao2.zzd.sendBroadcast(intent);
            } else {
                zzao2.zzd.startService(intent);
            }
        }
        try {
            object = (Bundle)Tasks.await(taskCompletionSource.getTask(), 30000L, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | TimeoutException exception) {
            Log.w("FirebaseInstanceId", "No response");
            throw new IOException("TIMEOUT");
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        finally {
            SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzc;
            synchronized (simpleArrayMap) {
                this.zzc.remove((Object)string2);
            }
        }
    }

    static /* synthetic */ void zza(zzao zzao2, Message message) {
        zzao2.zza(message);
    }
}

