/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.inject.Provider;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Personalization {
    public static final String ANALYTICS_ORIGIN_PERSONALIZATION = "fp";
    public static final String EXTERNAL_EVENT = "personalization_assignment";
    public static final String EXTERNAL_RC_PARAMETER_PARAM = "arm_key";
    public static final String EXTERNAL_ARM_VALUE_PARAM = "arm_value";
    public static final String PERSONALIZATION_ID = "personalizationId";
    public static final String EXTERNAL_PERSONALIZATION_ID_PARAM = "personalization_id";
    public static final String ARM_INDEX = "armIndex";
    public static final String EXTERNAL_ARM_INDEX_PARAM = "arm_index";
    public static final String GROUP = "group";
    public static final String EXTERNAL_GROUP_PARAM = "group";
    public static final String INTERNAL_EVENT = "_fpc";
    public static final String CHOICE_ID = "choiceId";
    public static final String INTERNAL_CHOICE_ID_PARAM = "_fpid";
    private final Provider<AnalyticsConnector> analyticsConnector;
    private final Map<String, String> loggedChoiceIds = Collections.synchronizedMap(new HashMap());

    public Personalization(Provider<AnalyticsConnector> analyticsConnector) {
        this.analyticsConnector = analyticsConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logArmActive(@NonNull String rcParameter, @NonNull ConfigContainer configContainer) {
        AnalyticsConnector connector = this.analyticsConnector.get();
        if (connector == null) {
            return;
        }
        JSONObject ids = configContainer.getPersonalizationMetadata();
        if (ids.length() < 1) {
            return;
        }
        JSONObject values = configContainer.getConfigs();
        if (values.length() < 1) {
            return;
        }
        JSONObject metadata = ids.optJSONObject(rcParameter);
        if (metadata == null) {
            return;
        }
        String choiceId = metadata.optString(CHOICE_ID);
        if (choiceId.isEmpty()) {
            return;
        }
        Map<String, String> map = this.loggedChoiceIds;
        synchronized (map) {
            if (choiceId.equals(this.loggedChoiceIds.get(rcParameter))) {
                return;
            }
            this.loggedChoiceIds.put(rcParameter, choiceId);
        }
        Bundle logParams = new Bundle();
        logParams.putString(EXTERNAL_RC_PARAMETER_PARAM, rcParameter);
        logParams.putString(EXTERNAL_ARM_VALUE_PARAM, values.optString(rcParameter));
        logParams.putString(EXTERNAL_PERSONALIZATION_ID_PARAM, metadata.optString(PERSONALIZATION_ID));
        logParams.putInt(EXTERNAL_ARM_INDEX_PARAM, metadata.optInt(ARM_INDEX, -1));
        logParams.putString("group", metadata.optString("group"));
        connector.logEvent(ANALYTICS_ORIGIN_PERSONALIZATION, EXTERNAL_EVENT, logParams);
        Bundle internalLogParams = new Bundle();
        internalLogParams.putString(INTERNAL_CHOICE_ID_PARAM, choiceId);
        connector.logEvent(ANALYTICS_ORIGIN_PERSONALIZATION, INTERNAL_EVENT, internalLogParams);
    }
}

