/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.icu.lang.UCharacter;
import android.icu.text.CaseMap;
import android.icu.text.Edits;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.AndroidCharacter;
import android.text.Annotation;
import android.text.GetChars;
import android.text.MeasuredParagraph;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AccessibilityClickableSpan;
import android.text.style.AccessibilityURLSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.EasyEditSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LocaleSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.SpellCheckSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TtsSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.text.style.UpdateAppearance;
import android.util.Log;
import android.util.Printer;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;

public class TextUtils {
    private static final String TAG = "TextUtils";
    static final char ELLIPSIS_FILLER = '\ufeff';
    private static final String ELLIPSIS_NORMAL = "\u2026";
    private static final String ELLIPSIS_TWO_DOTS = "\u2025";
    public static final int ALIGNMENT_SPAN = 1;
    public static final int FIRST_SPAN = 1;
    public static final int FOREGROUND_COLOR_SPAN = 2;
    public static final int RELATIVE_SIZE_SPAN = 3;
    public static final int SCALE_X_SPAN = 4;
    public static final int STRIKETHROUGH_SPAN = 5;
    public static final int UNDERLINE_SPAN = 6;
    public static final int STYLE_SPAN = 7;
    public static final int BULLET_SPAN = 8;
    public static final int QUOTE_SPAN = 9;
    public static final int LEADING_MARGIN_SPAN = 10;
    public static final int URL_SPAN = 11;
    public static final int BACKGROUND_COLOR_SPAN = 12;
    public static final int TYPEFACE_SPAN = 13;
    public static final int SUPERSCRIPT_SPAN = 14;
    public static final int SUBSCRIPT_SPAN = 15;
    public static final int ABSOLUTE_SIZE_SPAN = 16;
    public static final int TEXT_APPEARANCE_SPAN = 17;
    public static final int ANNOTATION = 18;
    public static final int SUGGESTION_SPAN = 19;
    public static final int SPELL_CHECK_SPAN = 20;
    public static final int SUGGESTION_RANGE_SPAN = 21;
    public static final int EASY_EDIT_SPAN = 22;
    public static final int LOCALE_SPAN = 23;
    public static final int TTS_SPAN = 24;
    public static final int ACCESSIBILITY_CLICKABLE_SPAN = 25;
    public static final int ACCESSIBILITY_URL_SPAN = 26;
    public static final int LAST_SPAN = 26;
    public static final Parcelable.Creator<CharSequence> CHAR_SEQUENCE_CREATOR = new Parcelable.Creator<CharSequence>(){

        @Override
        public CharSequence createFromParcel(Parcel p) {
            int kind = p.readInt();
            String string = p.readString();
            if (string == null) {
                return null;
            }
            if (kind == 1) {
                return string;
            }
            SpannableString sp = new SpannableString((CharSequence)string);
            block28: while ((kind = p.readInt()) != 0) {
                switch (kind) {
                    case 1: {
                        TextUtils.readSpan(p, (Spannable)sp, new AlignmentSpan.Standard(p));
                        continue block28;
                    }
                    case 2: {
                        TextUtils.readSpan(p, (Spannable)sp, new ForegroundColorSpan(p));
                        continue block28;
                    }
                    case 3: {
                        TextUtils.readSpan(p, (Spannable)sp, new RelativeSizeSpan(p));
                        continue block28;
                    }
                    case 4: {
                        TextUtils.readSpan(p, (Spannable)sp, new ScaleXSpan(p));
                        continue block28;
                    }
                    case 5: {
                        TextUtils.readSpan(p, (Spannable)sp, new StrikethroughSpan(p));
                        continue block28;
                    }
                    case 6: {
                        TextUtils.readSpan(p, (Spannable)sp, new UnderlineSpan(p));
                        continue block28;
                    }
                    case 7: {
                        TextUtils.readSpan(p, (Spannable)sp, new StyleSpan(p));
                        continue block28;
                    }
                    case 8: {
                        TextUtils.readSpan(p, (Spannable)sp, new BulletSpan(p));
                        continue block28;
                    }
                    case 9: {
                        TextUtils.readSpan(p, (Spannable)sp, new QuoteSpan(p));
                        continue block28;
                    }
                    case 10: {
                        TextUtils.readSpan(p, (Spannable)sp, new LeadingMarginSpan.Standard(p));
                        continue block28;
                    }
                    case 11: {
                        TextUtils.readSpan(p, (Spannable)sp, new URLSpan(p));
                        continue block28;
                    }
                    case 12: {
                        TextUtils.readSpan(p, (Spannable)sp, new BackgroundColorSpan(p));
                        continue block28;
                    }
                    case 13: {
                        TextUtils.readSpan(p, (Spannable)sp, new TypefaceSpan(p));
                        continue block28;
                    }
                    case 14: {
                        TextUtils.readSpan(p, (Spannable)sp, new SuperscriptSpan(p));
                        continue block28;
                    }
                    case 15: {
                        TextUtils.readSpan(p, (Spannable)sp, new SubscriptSpan(p));
                        continue block28;
                    }
                    case 16: {
                        TextUtils.readSpan(p, (Spannable)sp, new AbsoluteSizeSpan(p));
                        continue block28;
                    }
                    case 17: {
                        TextUtils.readSpan(p, (Spannable)sp, new TextAppearanceSpan(p));
                        continue block28;
                    }
                    case 18: {
                        TextUtils.readSpan(p, (Spannable)sp, new Annotation(p));
                        continue block28;
                    }
                    case 19: {
                        TextUtils.readSpan(p, (Spannable)sp, new SuggestionSpan(p));
                        continue block28;
                    }
                    case 20: {
                        TextUtils.readSpan(p, (Spannable)sp, new SpellCheckSpan(p));
                        continue block28;
                    }
                    case 21: {
                        TextUtils.readSpan(p, (Spannable)sp, new SuggestionRangeSpan(p));
                        continue block28;
                    }
                    case 22: {
                        TextUtils.readSpan(p, (Spannable)sp, new EasyEditSpan(p));
                        continue block28;
                    }
                    case 23: {
                        TextUtils.readSpan(p, (Spannable)sp, new LocaleSpan(p));
                        continue block28;
                    }
                    case 24: {
                        TextUtils.readSpan(p, (Spannable)sp, new TtsSpan(p));
                        continue block28;
                    }
                    case 25: {
                        TextUtils.readSpan(p, (Spannable)sp, new AccessibilityClickableSpan(p));
                        continue block28;
                    }
                    case 26: {
                        TextUtils.readSpan(p, (Spannable)sp, new AccessibilityURLSpan(p));
                        continue block28;
                    }
                }
                throw new RuntimeException("bogus span encoding " + kind);
            }
            return sp;
        }

        public CharSequence[] newArray(int size) {
            return new CharSequence[size];
        }
    };
    public static final int CAP_MODE_CHARACTERS = 4096;
    public static final int CAP_MODE_WORDS = 8192;
    public static final int CAP_MODE_SENTENCES = 16384;
    private static final int PARCEL_SAFE_TEXT_LENGTH = 100000;
    private static Object sLock = new Object();
    private static char[] sTemp = null;
    private static String[] EMPTY_STRING_ARRAY = new String[0];

    public static String getEllipsisString(TruncateAt method) {
        return method == TruncateAt.END_SMALL ? ELLIPSIS_TWO_DOTS : ELLIPSIS_NORMAL;
    }

    private TextUtils() {
    }

    public static void getChars(CharSequence s, int start, int end, char[] dest, int destoff) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            ((String)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuffer.class) {
            ((StringBuffer)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuilder.class) {
            ((StringBuilder)s).getChars(start, end, dest, destoff);
        } else if (s instanceof GetChars) {
            ((GetChars)s).getChars(start, end, dest, destoff);
        } else {
            for (int i = start; i < end; ++i) {
                dest[destoff++] = s.charAt(i);
            }
        }
    }

    public static int indexOf(CharSequence s, char ch) {
        return TextUtils.indexOf(s, ch, 0);
    }

    public static int indexOf(CharSequence s, char ch, int start) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            return ((String)s).indexOf(ch, start);
        }
        return TextUtils.indexOf(s, ch, start, s.length());
    }

    public static int indexOf(CharSequence s, char ch, int start, int end) {
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class) {
            int INDEX_INCREMENT = 500;
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segend = start + 500;
                if (segend > end) {
                    segend = end;
                }
                TextUtils.getChars(s, start, segend, temp, 0);
                int count = segend - start;
                for (int i = 0; i < count; ++i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + start;
                }
                start = segend;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence s, char ch) {
        return TextUtils.lastIndexOf(s, ch, s.length() - 1);
    }

    public static int lastIndexOf(CharSequence s, char ch, int last) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            return ((String)s).lastIndexOf(ch, last);
        }
        return TextUtils.lastIndexOf(s, ch, 0, last);
    }

    public static int lastIndexOf(CharSequence s, char ch, int start, int last) {
        if (last < 0) {
            return -1;
        }
        if (last >= s.length()) {
            last = s.length() - 1;
        }
        int end = last + 1;
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class) {
            int INDEX_INCREMENT = 500;
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segstart = end - 500;
                if (segstart < start) {
                    segstart = start;
                }
                TextUtils.getChars(s, segstart, end, temp, 0);
                int count = end - segstart;
                for (int i = count - 1; i >= 0; --i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + segstart;
                }
                end = segstart;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence s, CharSequence needle) {
        return TextUtils.indexOf(s, needle, 0, s.length());
    }

    public static int indexOf(CharSequence s, CharSequence needle, int start) {
        return TextUtils.indexOf(s, needle, start, s.length());
    }

    public static int indexOf(CharSequence s, CharSequence needle, int start, int end) {
        int nlen = needle.length();
        if (nlen == 0) {
            return start;
        }
        char c = needle.charAt(0);
        while ((start = TextUtils.indexOf(s, c, start)) <= end - nlen) {
            if (start < 0) {
                return -1;
            }
            if (TextUtils.regionMatches(s, start, needle, 0, nlen)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static boolean regionMatches(CharSequence one, int toffset, CharSequence two, int ooffset, int len) {
        int tempLen = 2 * len;
        if (tempLen < len) {
            throw new IndexOutOfBoundsException();
        }
        char[] temp = TextUtils.obtain(tempLen);
        TextUtils.getChars(one, toffset, toffset + len, temp, 0);
        TextUtils.getChars(two, ooffset, ooffset + len, temp, len);
        boolean match = true;
        for (int i = 0; i < len; ++i) {
            if (temp[i] == temp[i + len]) continue;
            match = false;
            break;
        }
        TextUtils.recycle(temp);
        return match;
    }

    public static String substring(CharSequence source, int start, int end) {
        if (source instanceof String) {
            return ((String)source).substring(start, end);
        }
        if (source instanceof StringBuilder) {
            return ((StringBuilder)source).substring(start, end);
        }
        if (source instanceof StringBuffer) {
            return ((StringBuffer)source).substring(start, end);
        }
        char[] temp = TextUtils.obtain(end - start);
        TextUtils.getChars(source, start, end, temp, 0);
        String ret = new String(temp, 0, end - start);
        TextUtils.recycle(temp);
        return ret;
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        int length = tokens.length;
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tokens[0]);
        for (int i = 1; i < length; ++i) {
            sb.append(delimiter);
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        Iterator it = tokens.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter);
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String[] split(String text, String expression) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return text.split(expression, -1);
    }

    public static String[] split(String text, Pattern pattern) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return pattern.split(text, -1);
    }

    public static CharSequence stringOrSpannedString(CharSequence source) {
        if (source == null) {
            return null;
        }
        if (source instanceof SpannedString) {
            return source;
        }
        if (source instanceof Spanned) {
            return new SpannedString(source);
        }
        return source.toString();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String nullIfEmpty(String str) {
        return TextUtils.isEmpty(str) ? null : str;
    }

    public static String emptyIfNull(String str) {
        return str == null ? "" : str;
    }

    public static String firstNotEmpty(String a, String b) {
        return !TextUtils.isEmpty(a) ? a : (String)Preconditions.checkStringNotEmpty((CharSequence)b);
    }

    public static int length(String s) {
        return TextUtils.isEmpty(s) ? 0 : s.length();
    }

    public static String safeIntern(String s) {
        return s != null ? s.intern() : null;
    }

    public static int getTrimmedLength(CharSequence s) {
        int end;
        int start;
        int len = s.length();
        for (start = 0; start < len && s.charAt(start) <= ' '; ++start) {
        }
        for (end = len; end > start && s.charAt(end - 1) <= ' '; --end) {
        }
        return end - start;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static CharSequence getReverse(CharSequence source, int start, int end) {
        return new Reverser(source, start, end);
    }

    public static void writeToParcel(CharSequence cs, Parcel p, int parcelableFlags) {
        if (cs instanceof Spanned) {
            p.writeInt(0);
            p.writeString(cs.toString());
            Spanned sp = (Spanned)cs;
            Object[] os = sp.getSpans(0, cs.length(), Object.class);
            for (int i = 0; i < os.length; ++i) {
                Object o = os[i];
                Object prop = os[i];
                if (prop instanceof CharacterStyle) {
                    prop = ((CharacterStyle)prop).getUnderlying();
                }
                if (!(prop instanceof ParcelableSpan)) continue;
                ParcelableSpan ps = (ParcelableSpan)prop;
                int spanTypeId = ps.getSpanTypeIdInternal();
                if (spanTypeId < 1 || spanTypeId > 26) {
                    Log.e(TAG, "External class \"" + ps.getClass().getSimpleName() + "\" is attempting to use the frameworks-only ParcelableSpan interface");
                    continue;
                }
                p.writeInt(spanTypeId);
                ps.writeToParcelInternal(p, parcelableFlags);
                TextUtils.writeWhere(p, sp, o);
            }
            p.writeInt(0);
        } else {
            p.writeInt(1);
            if (cs != null) {
                p.writeString(cs.toString());
            } else {
                p.writeString(null);
            }
        }
    }

    private static void writeWhere(Parcel p, Spanned sp, Object o) {
        p.writeInt(sp.getSpanStart(o));
        p.writeInt(sp.getSpanEnd(o));
        p.writeInt(sp.getSpanFlags(o));
    }

    public static void dumpSpans(CharSequence cs, Printer printer, String prefix) {
        if (cs instanceof Spanned) {
            Spanned sp = (Spanned)cs;
            Object[] os = sp.getSpans(0, cs.length(), Object.class);
            for (int i = 0; i < os.length; ++i) {
                Object o = os[i];
                printer.println(prefix + cs.subSequence(sp.getSpanStart(o), sp.getSpanEnd(o)) + ": " + Integer.toHexString(System.identityHashCode(o)) + " " + o.getClass().getCanonicalName() + " (" + sp.getSpanStart(o) + "-" + sp.getSpanEnd(o) + ") fl=#" + sp.getSpanFlags(o));
            }
        } else {
            printer.println(prefix + cs + ": (no spans)");
        }
    }

    public static CharSequence replace(CharSequence template, String[] sources, CharSequence[] destinations) {
        int i;
        SpannableStringBuilder tb = new SpannableStringBuilder(template);
        for (i = 0; i < sources.length; ++i) {
            int where = TextUtils.indexOf((CharSequence)tb, sources[i]);
            if (where < 0) continue;
            tb.setSpan((Object)sources[i], where, where + sources[i].length(), 33);
        }
        for (i = 0; i < sources.length; ++i) {
            int start = tb.getSpanStart((Object)sources[i]);
            int end = tb.getSpanEnd((Object)sources[i]);
            if (start < 0) continue;
            tb.replace(start, end, destinations[i]);
        }
        return tb;
    }

    public static CharSequence expandTemplate(CharSequence template, CharSequence ... values) {
        if (values.length > 9) {
            throw new IllegalArgumentException("max of 9 values are supported");
        }
        SpannableStringBuilder ssb = new SpannableStringBuilder(template);
        try {
            int i = 0;
            while (i < ssb.length()) {
                if (ssb.charAt(i) == '^') {
                    char next = ssb.charAt(i + 1);
                    if (next == '^') {
                        ssb.delete(i + 1, i + 2);
                        ++i;
                        continue;
                    }
                    if (Character.isDigit(next)) {
                        int which = Character.getNumericValue(next) - 1;
                        if (which < 0) {
                            throw new IllegalArgumentException("template requests value ^" + (which + 1));
                        }
                        if (which >= values.length) {
                            throw new IllegalArgumentException("template requests value ^" + (which + 1) + "; only " + values.length + " provided");
                        }
                        ssb.replace(i, i + 2, values[which]);
                        i += values[which].length();
                        continue;
                    }
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ssb;
    }

    public static int getOffsetBefore(CharSequence text, int offset) {
        char c1;
        if (offset == 0) {
            return 0;
        }
        if (offset == 1) {
            return 0;
        }
        char c = text.charAt(offset - 1);
        offset = c >= '\udc00' && c <= '\udfff' ? ((c1 = text.charAt(offset - 2)) >= '\ud800' && c1 <= '\udbff' ? (offset -= 2) : --offset) : --offset;
        if (text instanceof Spanned) {
            ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int start = ((Spanned)text).getSpanStart(spans[i]);
                int end = ((Spanned)text).getSpanEnd(spans[i]);
                if (start >= offset || end <= offset) continue;
                offset = start;
            }
        }
        return offset;
    }

    public static int getOffsetAfter(CharSequence text, int offset) {
        char c1;
        int len = text.length();
        if (offset == len) {
            return len;
        }
        if (offset == len - 1) {
            return len;
        }
        char c = text.charAt(offset);
        offset = c >= '\ud800' && c <= '\udbff' ? ((c1 = text.charAt(offset + 1)) >= '\udc00' && c1 <= '\udfff' ? (offset += 2) : ++offset) : ++offset;
        if (text instanceof Spanned) {
            ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int start = ((Spanned)text).getSpanStart(spans[i]);
                int end = ((Spanned)text).getSpanEnd(spans[i]);
                if (start >= offset || end <= offset) continue;
                offset = end;
            }
        }
        return offset;
    }

    private static void readSpan(Parcel p, Spannable sp, Object o) {
        sp.setSpan(o, p.readInt(), p.readInt(), p.readInt());
    }

    public static void copySpansFrom(Spanned source, int start, int end, Class kind, Spannable dest, int destoff) {
        if (kind == null) {
            kind = Object.class;
        }
        Object[] spans = source.getSpans(start, end, kind);
        for (int i = 0; i < spans.length; ++i) {
            int st = source.getSpanStart(spans[i]);
            int en = source.getSpanEnd(spans[i]);
            int fl = source.getSpanFlags(spans[i]);
            if (st < start) {
                st = start;
            }
            if (en > end) {
                en = end;
            }
            dest.setSpan(spans[i], st - start + destoff, en - start + destoff, fl);
        }
    }

    public static CharSequence toUpperCase(Locale locale, CharSequence source, boolean copySpans) {
        Object[] spans;
        Edits edits = new Edits();
        if (!copySpans) {
            StringBuilder result = (StringBuilder)CaseMap.toUpper().apply(locale, source, (Appendable)new StringBuilder(), edits);
            return edits.hasChanges() ? result : source;
        }
        SpannableStringBuilder result = (SpannableStringBuilder)CaseMap.toUpper().apply(locale, source, (Appendable)new SpannableStringBuilder(), edits);
        if (!edits.hasChanges()) {
            return source;
        }
        Edits.Iterator iterator = edits.getFineIterator();
        int sourceLength = source.length();
        Spanned spanned = (Spanned)source;
        for (Object span : spans = spanned.getSpans(0, sourceLength, Object.class)) {
            int sourceStart = spanned.getSpanStart(span);
            int sourceEnd = spanned.getSpanEnd(span);
            int flags2 = spanned.getSpanFlags(span);
            int destStart = sourceStart == sourceLength ? result.length() : TextUtils.toUpperMapToDest(iterator, sourceStart);
            int destEnd = sourceEnd == sourceLength ? result.length() : TextUtils.toUpperMapToDest(iterator, sourceEnd);
            result.setSpan(span, destStart, destEnd, flags2);
        }
        return result;
    }

    private static int toUpperMapToDest(Edits.Iterator iterator, int sourceIndex) {
        iterator.findSourceIndex(sourceIndex);
        if (sourceIndex == iterator.sourceIndex()) {
            return iterator.destinationIndex();
        }
        if (iterator.hasChange()) {
            return iterator.destinationIndex() + iterator.newLength();
        }
        return iterator.destinationIndex() + (sourceIndex - iterator.sourceIndex());
    }

    public static CharSequence ellipsize(CharSequence text, TextPaint p, float avail, TruncateAt where) {
        return TextUtils.ellipsize(text, p, avail, where, false, null);
    }

    public static CharSequence ellipsize(CharSequence text, TextPaint paint, float avail, TruncateAt where, boolean preserveLength, EllipsizeCallback callback2) {
        return TextUtils.ellipsize(text, paint, avail, where, preserveLength, callback2, TextDirectionHeuristics.FIRSTSTRONG_LTR, TextUtils.getEllipsisString(where));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence ellipsize(CharSequence text, TextPaint paint, float avail, TruncateAt where, boolean preserveLength, EllipsizeCallback callback2, TextDirectionHeuristic textDir, String ellipsis) {
        int len = text.length();
        MeasuredParagraph mt = null;
        try {
            mt = MeasuredParagraph.buildForMeasurement((TextPaint)paint, (CharSequence)text, (int)0, (int)text.length(), (TextDirectionHeuristic)textDir, mt);
            float width = mt.getWholeWidth();
            if (width <= avail) {
                if (callback2 != null) {
                    callback2.ellipsized(0, 0);
                }
                CharSequence charSequence = text;
                return charSequence;
            }
            float ellipsiswid = paint.measureText(ellipsis);
            int left = 0;
            int right = len;
            if (!((avail -= ellipsiswid) < 0.0f)) {
                if (where == TruncateAt.START) {
                    right = len - mt.breakText(len, false, avail);
                } else if (where == TruncateAt.END || where == TruncateAt.END_SMALL) {
                    left = mt.breakText(len, true, avail);
                } else {
                    right = len - mt.breakText(len, false, avail / 2.0f);
                    left = mt.breakText(right, true, avail -= mt.measure(right, len));
                }
            }
            if (callback2 != null) {
                callback2.ellipsized(left, right);
            }
            char[] buf = mt.getChars();
            Spanned sp = text instanceof Spanned ? (Spanned)text : null;
            int removed = right - left;
            int remaining = len - removed;
            if (preserveLength) {
                if (remaining > 0 && removed >= ellipsis.length()) {
                    ellipsis.getChars(0, ellipsis.length(), buf, left);
                    left += ellipsis.length();
                }
                for (int i = left; i < right; ++i) {
                    buf[i] = 65279;
                }
                String s = new String(buf, 0, len);
                if (sp == null) {
                    String string = s;
                    return string;
                }
                SpannableString ss = new SpannableString((CharSequence)s);
                TextUtils.copySpansFrom(sp, 0, len, Object.class, (Spannable)ss, 0);
                SpannableString spannableString = ss;
                return spannableString;
            }
            if (remaining == 0) {
                String s = "";
                return s;
            }
            if (sp == null) {
                StringBuilder sb = new StringBuilder(remaining + ellipsis.length());
                sb.append(buf, 0, left);
                sb.append(ellipsis);
                sb.append(buf, right, len - right);
                String string = sb.toString();
                return string;
            }
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            ssb.append(text, 0, left);
            ssb.append((CharSequence)ellipsis);
            ssb.append(text, right, len);
            SpannableStringBuilder spannableStringBuilder = ssb;
            return spannableStringBuilder;
        }
        finally {
            if (mt != null) {
                mt.recycle();
            }
        }
    }

    @Deprecated
    public static CharSequence commaEllipsize(CharSequence text, TextPaint p, float avail, String oneMore, String more) {
        return TextUtils.commaEllipsize(text, p, avail, oneMore, more, TextDirectionHeuristics.FIRSTSTRONG_LTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static CharSequence commaEllipsize(CharSequence text, TextPaint p, float avail, String oneMore, String more, TextDirectionHeuristic textDir) {
        MeasuredParagraph mt = null;
        MeasuredParagraph tempMt = null;
        try {
            int len = text.length();
            mt = MeasuredParagraph.buildForMeasurement((TextPaint)p, (CharSequence)text, (int)0, (int)len, (TextDirectionHeuristic)textDir, mt);
            float width = mt.getWholeWidth();
            if (width <= avail) {
                CharSequence charSequence = text;
                return charSequence;
            }
            char[] buf = mt.getChars();
            int commaCount = 0;
            for (int i = 0; i < len; ++i) {
                if (buf[i] != ',') continue;
                ++commaCount;
            }
            int remaining = commaCount + 1;
            int ok = 0;
            Object okFormat = "";
            int w = 0;
            int count = 0;
            float[] widths = mt.getWidths().getRawArray();
            for (int i = 0; i < len; ++i) {
                String format;
                float moreWid;
                w = (int)((float)w + widths[i]);
                if (buf[i] != ',') continue;
                ++count;
                if (!((float)w + (moreWid = (tempMt = MeasuredParagraph.buildForMeasurement((TextPaint)p, (CharSequence)(format = --remaining == 1 ? " " + oneMore : " " + String.format(more, remaining)), (int)0, (int)format.length(), (TextDirectionHeuristic)textDir, tempMt)).getWholeWidth()) <= avail)) continue;
                ok = i + 1;
                okFormat = format;
            }
            SpannableStringBuilder out = new SpannableStringBuilder((CharSequence)okFormat);
            out.insert(0, text, 0, ok);
            SpannableStringBuilder spannableStringBuilder = out;
            return spannableStringBuilder;
        }
        finally {
            if (mt != null) {
                mt.recycle();
            }
            if (tempMt != null) {
                tempMt.recycle();
            }
        }
    }

    static boolean couldAffectRtl(char c) {
        return '\u0590' <= c && c <= '\u08ff' || c == '\u200e' || c == '\u200f' || '\u202a' <= c && c <= '\u202e' || '\u2066' <= c && c <= '\u2069' || '\ud800' <= c && c <= '\udfff' || '\ufb1d' <= c && c <= '\ufdff' || '\ufe70' <= c && c <= '\ufefe';
    }

    static boolean doesNotNeedBidi(char[] text, int start, int len) {
        int end = start + len;
        for (int i = start; i < end; ++i) {
            if (!TextUtils.couldAffectRtl(text[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] obtain(int len) {
        char[] buf;
        Object object = sLock;
        synchronized (object) {
            buf = sTemp;
            sTemp = null;
        }
        if (buf == null || buf.length < len) {
            buf = ArrayUtils.newUnpaddedCharArray(len);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recycle(char[] temp) {
        if (temp.length > 1000) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sTemp = temp;
        }
    }

    public static String htmlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static CharSequence concat(CharSequence ... text) {
        if (text.length == 0) {
            return "";
        }
        if (text.length == 1) {
            return text[0];
        }
        boolean spanned = false;
        for (CharSequence piece : text) {
            if (!(piece instanceof Spanned)) continue;
            spanned = true;
            break;
        }
        if (spanned) {
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            for (CharSequence piece : text) {
                ssb.append(piece == null ? "null" : piece);
            }
            return new SpannedString((CharSequence)ssb);
        }
        StringBuilder sb = new StringBuilder();
        for (CharSequence piece : text) {
            sb.append(piece);
        }
        return sb.toString();
    }

    public static boolean isGraphic(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            int gc = Character.getType(cp);
            if (gc == 15 || gc == 16 || gc == 19 || gc == 0 || gc == 13 || gc == 14 || gc == 12) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isGraphic(char c) {
        int gc = Character.getType(c);
        return gc != 15 && gc != 16 && gc != 19 && gc != 0 && gc != 13 && gc != 14 && gc != 12;
    }

    public static boolean isDigitsOnly(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isDigit(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintableAscii(char c) {
        int asciiFirst = 32;
        int asciiLast = 126;
        return ' ' <= c && c <= '~' || c == '\r' || c == '\n';
    }

    public static boolean isPrintableAsciiOnly(CharSequence str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (TextUtils.isPrintableAscii(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getCapsMode(CharSequence cs, int off, int reqModes) {
        int j;
        char c;
        int i;
        if (off < 0) {
            return 0;
        }
        int mode = 0;
        if ((reqModes & 0x1000) != 0) {
            mode |= 0x1000;
        }
        if ((reqModes & 0x6000) == 0) {
            return mode;
        }
        for (i = off; i > 0 && ((c = cs.charAt(i - 1)) == '\"' || c == '\'' || Character.getType(c) == 21); --i) {
        }
        for (j = i; j > 0 && ((c = cs.charAt(j - 1)) == ' ' || c == '\t'); --j) {
        }
        if (j == 0 || cs.charAt(j - 1) == '\n') {
            return mode | 0x2000;
        }
        if ((reqModes & 0x4000) == 0) {
            if (i != j) {
                mode |= 0x2000;
            }
            return mode;
        }
        if (i == j) {
            return mode;
        }
        while (j > 0 && ((c = cs.charAt(j - 1)) == '\"' || c == '\'' || Character.getType(c) == 22)) {
            --j;
        }
        if (j > 0 && ((c = cs.charAt(j - 1)) == '.' || c == '?' || c == '!')) {
            if (c == '.') {
                for (int k = j - 2; k >= 0; --k) {
                    c = cs.charAt(k);
                    if (c == '.') {
                        return mode;
                    }
                    if (!Character.isLetter(c)) break;
                }
            }
            return mode | 0x4000;
        }
        return mode;
    }

    public static boolean delimitedStringContains(String delimitedString, char delimiter, String item) {
        if (TextUtils.isEmpty(delimitedString) || TextUtils.isEmpty(item)) {
            return false;
        }
        int pos = -1;
        int length = delimitedString.length();
        while ((pos = delimitedString.indexOf(item, pos + 1)) != -1) {
            if (pos > 0 && delimitedString.charAt(pos - 1) != delimiter) continue;
            int expectedDelimiterPos = pos + item.length();
            if (expectedDelimiterPos == length) {
                return true;
            }
            if (delimitedString.charAt(expectedDelimiterPos) != delimiter) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] removeEmptySpans(T[] spans, Spanned spanned, Class<T> klass) {
        Object[] copy = null;
        int count = 0;
        for (int i = 0; i < spans.length; ++i) {
            int end;
            T span = spans[i];
            int start = spanned.getSpanStart(span);
            if (start == (end = spanned.getSpanEnd(span))) {
                if (copy != null) continue;
                copy = (Object[])Array.newInstance(klass, spans.length - 1);
                System.arraycopy(spans, 0, copy, 0, i);
                count = i;
                continue;
            }
            if (copy == null) continue;
            copy[count] = span;
            ++count;
        }
        if (copy != null) {
            Object[] result = (Object[])Array.newInstance(klass, count);
            System.arraycopy(copy, 0, result, 0, count);
            return result;
        }
        return spans;
    }

    public static long packRangeInLong(int start, int end) {
        return (long)start << 32 | (long)end;
    }

    public static int unpackRangeStartFromLong(long range) {
        return (int)(range >>> 32);
    }

    public static int unpackRangeEndFromLong(long range) {
        return (int)(range & 0xFFFFFFFFL);
    }

    public static boolean hasStyleSpan(Spanned spanned) {
        Class[] styleClasses;
        Preconditions.checkArgument((spanned != null ? 1 : 0) != 0);
        for (Class clazz : styleClasses = new Class[]{CharacterStyle.class, ParagraphStyle.class, UpdateAppearance.class}) {
            if (spanned.nextSpanTransition(-1, spanned.length(), clazz) >= spanned.length()) continue;
            return true;
        }
        return false;
    }

    public static CharSequence trimNoCopySpans(CharSequence charSequence) {
        if (charSequence != null && charSequence instanceof Spanned) {
            return new SpannableStringBuilder(charSequence);
        }
        return charSequence;
    }

    public static void wrap(StringBuilder builder, String start, String end) {
        builder.insert(0, start);
        builder.append(end);
    }

    public static <T extends CharSequence> T trimToParcelableSize(T text) {
        return TextUtils.trimToSize(text, 100000);
    }

    public static <T extends CharSequence> T trimToSize(T text, int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        if (TextUtils.isEmpty(text) || text.length() <= size) {
            return text;
        }
        if (Character.isHighSurrogate(text.charAt(size - 1)) && Character.isLowSurrogate(text.charAt(size))) {
            --size;
        }
        return (T)text.subSequence(0, size);
    }

    public static interface EllipsizeCallback {
        public void ellipsized(int var1, int var2);
    }

    public static enum TruncateAt {
        START,
        MIDDLE,
        END,
        MARQUEE,
        END_SMALL;

    }

    private static class Reverser
    implements CharSequence,
    GetChars {
        private CharSequence mSource;
        private int mStart;
        private int mEnd;

        public Reverser(CharSequence source, int start, int end) {
            this.mSource = source;
            this.mStart = start;
            this.mEnd = end;
        }

        @Override
        public int length() {
            return this.mEnd - this.mStart;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            char[] buf = new char[end - start];
            this.getChars(start, end, buf, 0);
            return new String(buf);
        }

        @Override
        public String toString() {
            return this.subSequence(0, this.length()).toString();
        }

        @Override
        public char charAt(int off) {
            return (char)UCharacter.getMirror((int)this.mSource.charAt(this.mEnd - 1 - off));
        }

        public void getChars(int start, int end, char[] dest, int destoff) {
            TextUtils.getChars(this.mSource, start + this.mStart, end + this.mStart, dest, destoff);
            AndroidCharacter.mirror((char[])dest, (int)0, (int)(end - start));
            int len = end - start;
            int n = (end - start) / 2;
            for (int i = 0; i < n; ++i) {
                char tmp = dest[destoff + i];
                dest[destoff + i] = dest[destoff + len - i - 1];
                dest[destoff + len - i - 1] = tmp;
            }
        }
    }

    public static class SimpleStringSplitter
    implements StringSplitter,
    Iterator<String> {
        private String mString;
        private char mDelimiter;
        private int mPosition;
        private int mLength;

        public SimpleStringSplitter(char delimiter) {
            this.mDelimiter = delimiter;
        }

        @Override
        public void setString(String string) {
            this.mString = string;
            this.mPosition = 0;
            this.mLength = this.mString.length();
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.mPosition < this.mLength;
        }

        @Override
        public String next() {
            int end = this.mString.indexOf(this.mDelimiter, this.mPosition);
            if (end == -1) {
                end = this.mLength;
            }
            String nextString = this.mString.substring(this.mPosition, end);
            this.mPosition = end + 1;
            return nextString;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface StringSplitter
    extends Iterable<String> {
        public void setString(String var1);
    }
}

