/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.firebase.firestore.util.Preconditions;
import java.util.Date;

public final class Timestamp
implements Comparable<Timestamp>,
Parcelable {
    @NonNull
    public static final Parcelable.Creator<Timestamp> CREATOR = new Parcelable.Creator<Timestamp>(){

        @Override
        public Timestamp createFromParcel(Parcel source) {
            return new Timestamp(source);
        }

        public Timestamp[] newArray(int size) {
            return new Timestamp[size];
        }
    };
    private final long seconds;
    private final int nanoseconds;

    public Timestamp(long seconds, int nanoseconds) {
        Timestamp.validateRange(seconds, nanoseconds);
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    protected Timestamp(@NonNull Parcel in) {
        this.seconds = in.readLong();
        this.nanoseconds = in.readInt();
    }

    public Timestamp(@NonNull Date date) {
        long millis = date.getTime();
        long seconds = millis / 1000L;
        int nanoseconds = (int)(millis % 1000L) * 1000000;
        if (nanoseconds < 0) {
            --seconds;
            nanoseconds += 1000000000;
        }
        Timestamp.validateRange(seconds, nanoseconds);
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    @NonNull
    public static Timestamp now() {
        return new Timestamp(new Date());
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    @NonNull
    public Date toDate() {
        return new Date(this.seconds * 1000L + (long)(this.nanoseconds / 1000000));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags2) {
        dest.writeLong(this.seconds);
        dest.writeInt(this.nanoseconds);
    }

    @Override
    public int compareTo(@NonNull Timestamp other) {
        if (this.seconds == other.seconds) {
            return Integer.signum(this.nanoseconds - other.nanoseconds);
        }
        return Long.signum(this.seconds - other.seconds);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Timestamp)) {
            return false;
        }
        return this.compareTo((Timestamp)other) == 0;
    }

    public int hashCode() {
        int prime = 37;
        int result = prime * (int)this.seconds;
        result = prime * result + (int)(this.seconds >> 32);
        result = prime * result + this.nanoseconds;
        return result;
    }

    public String toString() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }

    private static void validateRange(long seconds, int nanoseconds) {
        Preconditions.checkArgument(nanoseconds >= 0, "Timestamp nanoseconds out of range: %s", nanoseconds);
        Preconditions.checkArgument((double)nanoseconds < 1.0E9, "Timestamp nanoseconds out of range: %s", nanoseconds);
        Preconditions.checkArgument(seconds >= -62135596800L, "Timestamp seconds out of range: %s", seconds);
        Preconditions.checkArgument(seconds < 253402300800L, "Timestamp seconds out of range: %s", seconds);
    }
}

