/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.persistence;

import com.google.firebase.database.core.persistence.CachePolicy;

public class LRUCachePolicy
implements CachePolicy {
    private static final long SERVER_UPDATES_BETWEEN_CACHE_SIZE_CHECKS = 1000L;
    private static final long MAX_NUMBER_OF_PRUNABLE_QUERIES_TO_KEEP = 1000L;
    private static final float PERCENT_OF_QUERIES_TO_PRUNE_AT_ONCE = 0.2f;
    public final long maxSizeBytes;

    public LRUCachePolicy(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
    }

    @Override
    public boolean shouldPrune(long currentSizeBytes, long countOfPrunableQueries) {
        return currentSizeBytes > this.maxSizeBytes || countOfPrunableQueries > 1000L;
    }

    @Override
    public boolean shouldCheckCacheSize(long serverUpdatesSinceLastCheck) {
        return serverUpdatesSinceLastCheck > 1000L;
    }

    @Override
    public float getPercentOfQueriesToPruneAtOnce() {
        return 0.2f;
    }

    @Override
    public long getMaxNumberOfQueriesToKeep() {
        return 1000L;
    }
}

