/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;

public class Slashes {
    @NonNull
    public static String preserveSlashEncode(@Nullable String s) {
        if (TextUtils.isEmpty(s)) {
            return "";
        }
        return Slashes.slashize(Uri.encode(s));
    }

    @NonNull
    public static String slashize(@NonNull String s) {
        Preconditions.checkNotNull(s);
        return s.replace("%2F", "/");
    }

    @NonNull
    public static String normalizeSlashes(@NonNull String uriSegment) {
        if (TextUtils.isEmpty(uriSegment)) {
            return "";
        }
        if (uriSegment.startsWith("/") || uriSegment.endsWith("/") || uriSegment.contains("//")) {
            StringBuilder result = new StringBuilder();
            for (String stringSegment : uriSegment.split("/", -1)) {
                if (TextUtils.isEmpty(stringSegment)) continue;
                if (result.length() > 0) {
                    result.append("/").append(stringSegment);
                    continue;
                }
                result.append(stringSegment);
            }
            return result.toString();
        }
        return uriSegment;
    }
}

