/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.Logger;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.TokenProvider;
import com.google.firebase.database.logging.Logger;
import java.util.List;

public class DatabaseConfig
extends Context {
    public synchronized void setLogger(Logger logger) {
        this.assertUnfrozen();
        this.logger = logger;
    }

    public synchronized void setEventTarget(EventTarget eventTarget) {
        this.assertUnfrozen();
        this.eventTarget = eventTarget;
    }

    public synchronized void setLogLevel(Logger.Level logLevel) {
        this.assertUnfrozen();
        switch (logLevel) {
            case DEBUG: {
                this.logLevel = Logger.Level.DEBUG;
                break;
            }
            case INFO: {
                this.logLevel = Logger.Level.INFO;
                break;
            }
            case WARN: {
                this.logLevel = Logger.Level.WARN;
                break;
            }
            case ERROR: {
                this.logLevel = Logger.Level.ERROR;
                break;
            }
            case NONE: {
                this.logLevel = Logger.Level.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level: " + (Object)((Object)logLevel));
            }
        }
    }

    public synchronized void setDebugLogComponents(List<String> debugComponents) {
        this.assertUnfrozen();
        this.setLogLevel(Logger.Level.DEBUG);
        this.loggedComponents = debugComponents;
    }

    public void setRunLoop(RunLoop runLoop) {
        this.runLoop = runLoop;
    }

    public void setAuthTokenProvider(TokenProvider provider) {
        this.authTokenProvider = provider;
    }

    public void setAppCheckTokenProvider(TokenProvider provider) {
        this.appCheckTokenProvider = provider;
    }

    public synchronized void setSessionPersistenceKey(String sessionKey) {
        this.assertUnfrozen();
        if (sessionKey == null || sessionKey.isEmpty()) {
            throw new IllegalArgumentException("Session identifier is not allowed to be empty or null!");
        }
        this.persistenceKey = sessionKey;
    }

    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        this.assertUnfrozen();
        this.persistenceEnabled = isEnabled;
    }

    public synchronized void setPersistenceCacheSizeBytes(long cacheSizeInBytes) {
        this.assertUnfrozen();
        if (cacheSizeInBytes < 0x100000L) {
            throw new DatabaseException("The minimum cache size must be at least 1MB");
        }
        if (cacheSizeInBytes > 0x6400000L) {
            throw new DatabaseException("Firebase Database currently doesn't support a cache size larger than 100MB");
        }
        this.cacheSize = cacheSizeInBytes;
    }

    public synchronized void setFirebaseApp(FirebaseApp app) {
        this.firebaseApp = app;
    }
}

