/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.NonNull;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.UploadTask;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StorageTaskManager {
    private static final StorageTaskManager _instance = new StorageTaskManager();
    private final Map<String, WeakReference<StorageTask<?>>> inProgressTasks = new HashMap();
    private final Object syncObject = new Object();

    StorageTaskManager() {
    }

    static StorageTaskManager getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UploadTask> getUploadTasksUnder(@NonNull StorageReference parent) {
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<UploadTask> inProgressList = new ArrayList<UploadTask>();
            String parentPath = parent.toString();
            for (Map.Entry<String, WeakReference<StorageTask<?>>> entry : this.inProgressTasks.entrySet()) {
                StorageTask task;
                if (!entry.getKey().startsWith(parentPath) || !((task = (StorageTask)entry.getValue().get()) instanceof UploadTask)) continue;
                inProgressList.add((UploadTask)task);
            }
            return Collections.unmodifiableList(inProgressList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileDownloadTask> getDownloadTasksUnder(@NonNull StorageReference parent) {
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<FileDownloadTask> inProgressList = new ArrayList<FileDownloadTask>();
            String parentPath = parent.toString();
            for (Map.Entry<String, WeakReference<StorageTask<?>>> entry : this.inProgressTasks.entrySet()) {
                StorageTask task;
                if (!entry.getKey().startsWith(parentPath) || !((task = (StorageTask)entry.getValue().get()) instanceof FileDownloadTask)) continue;
                inProgressList.add((FileDownloadTask)task);
            }
            return Collections.unmodifiableList(inProgressList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureRegistered(StorageTask<?> targetTask) {
        Object object = this.syncObject;
        synchronized (object) {
            this.inProgressTasks.put(targetTask.getStorage().toString(), new WeakReference(targetTask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegister(StorageTask<?> targetTask) {
        Object object = this.syncObject;
        synchronized (object) {
            StorageTask task;
            String key = targetTask.getStorage().toString();
            WeakReference<StorageTask<?>> weakReference = this.inProgressTasks.get(key);
            StorageTask storageTask = task = weakReference != null ? (StorageTask)weakReference.get() : null;
            if (task == null || task == targetTask) {
                this.inProgressTasks.remove(key);
            }
        }
    }
}

