/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebasePlatform;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthKt;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserImpl;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UrlFactory;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.internal.InternalTokenResult;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0001\n\u0002\b\u0004\u0018\u0000 x2\u00020\u0001:\u0003xyzB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JC\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162#\u0010\u0017\u001a\u001f\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0018H\u0002J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001202J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u0012022\u0006\u00104\u001a\u00020\u0014J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u001202H\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u0012022\u0006\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u0014J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u0012022\u0006\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u0014J%\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAJ\u0006\u0010B\u001a\u00020CJ\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020E022\u0006\u0010F\u001a\u00020GH\u0016JN\u0010I\u001a\u00020C\"\u0004\b\u0000\u0010J2\u0006\u0010,\u001a\u00020\u001c2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ0\u00112#\u0010L\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(,\u0012\u0006\u0012\u0004\u0018\u0001HJ0\u0018H\u0000\u00a2\u0006\u0002\bMJ\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00112\u0006\u0010,\u001a\u00020\u001cH\u0002J\u001b\u0010O\u001a\b\u0012\u0004\u0012\u00020C022\u0006\u00107\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bPJ\u001b\u0010Q\u001a\b\u0012\u0004\u0012\u00020C022\u0006\u0010=\u001a\u00020RH\u0000\u00a2\u0006\u0002\bSJ\n\u0010T\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020\u001fH\u0016J\u0010\u0010W\u001a\u00020C2\u0006\u0010V\u001a\u00020\u001fH\u0016J\u000e\u0010X\u001a\u00020C2\u0006\u0010V\u001a\u00020#J\u000e\u0010Y\u001a\u00020C2\u0006\u0010V\u001a\u00020#J\u000e\u0010U\u001a\u00020C2\u0006\u0010V\u001a\u00020!J\u000e\u0010W\u001a\u00020C2\u0006\u0010V\u001a\u00020!J\u0016\u0010Z\u001a\u00020C2\u0006\u0010[\u001a\u00020\u00142\u0006\u0010\\\u001a\u00020]J\u001e\u0010^\u001a\b\u0012\u0004\u0012\u00020C022\u0006\u00107\u001a\u00020\u00142\b\u0010_\u001a\u0004\u0018\u00010`J\u0014\u0010a\u001a\b\u0012\u0004\u0012\u00020\u0012022\u0006\u0010b\u001a\u00020cJ\u0014\u0010d\u001a\b\u0012\u0004\u0012\u00020e022\u0006\u0010f\u001a\u00020\u0014J\u001c\u0010g\u001a\b\u0012\u0004\u0012\u00020C022\u0006\u0010f\u001a\u00020\u00142\u0006\u0010h\u001a\u00020\u0014J\u0014\u0010i\u001a\b\u0012\u0004\u0012\u00020j022\u0006\u00107\u001a\u00020\u0014J\u001c\u0010k\u001a\b\u0012\u0004\u0012\u00020C022\u0006\u00107\u001a\u00020\u00142\u0006\u0010l\u001a\u00020`J\u0014\u0010m\u001a\b\u0012\u0004\u0012\u00020\u0014022\u0006\u0010f\u001a\u00020\u0014J\u0014\u0010n\u001a\b\u0012\u0004\u0012\u00020C022\u0006\u0010,\u001a\u00020%J\u0014\u0010o\u001a\b\u0012\u0004\u0012\u00020C022\u0006\u0010f\u001a\u00020\u0014J\u000e\u0010s\u001a\u00020G2\u0006\u0010t\u001a\u00020\u0014J\u001c\u0010u\u001a\b\u0012\u0004\u0012\u00020\u0012022\u0006\u00107\u001a\u00020\u00142\u0006\u0010t\u001a\u00020\u0014J\u000e\u0010v\u001a\u00020w2\u0006\u0010+\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u0004\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0015\u0010(\u001a\u00020\u0014*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\"\u0010,\u001a\u0004\u0018\u00010\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u001c@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010p\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bq\u0010r\u00a8\u0006{"}, d2={"Lcom/google/firebase/auth/FirebaseAuth;", "Lcom/google/firebase/auth/internal/InternalAuthProvider;", "app", "Lcom/google/firebase/FirebaseApp;", "<init>", "(Lcom/google/firebase/FirebaseApp;)V", "getApp", "()Lcom/google/firebase/FirebaseApp;", "json", "Lokhttp3/MediaType;", "getJson$firebase_java_sdk", "()Lokhttp3/MediaType;", "client", "Lokhttp3/OkHttpClient;", "getClient$firebase_java_sdk", "()Lokhttp3/OkHttpClient;", "enqueueAuthPost", "Lcom/google/android/gms/tasks/TaskCompletionSource;", "Lcom/google/firebase/auth/AuthResult;", "url", "", "body", "Lokhttp3/RequestBody;", "setResult", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "responseBody", "Lcom/google/firebase/auth/FirebaseUserImpl;", "internalIdTokenListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/google/firebase/auth/internal/IdTokenListener;", "idTokenListeners", "Lcom/google/firebase/auth/FirebaseAuth$IdTokenListener;", "authStateListeners", "Lcom/google/firebase/auth/FirebaseAuth$AuthStateListener;", "currentUser", "Lcom/google/firebase/auth/FirebaseUser;", "getCurrentUser", "()Lcom/google/firebase/auth/FirebaseUser;", "key", "getKey", "(Lcom/google/firebase/FirebaseApp;)Ljava/lang/String;", "value", "user", "setUser", "(Lcom/google/firebase/auth/FirebaseUserImpl;)V", "urlFactory", "Lcom/google/firebase/auth/UrlFactory;", "signInAnonymously", "Lcom/google/android/gms/tasks/Task;", "signInWithCustomToken", "customToken", "updateByGetAccountInfo", "createUserWithEmailAndPassword", "email", "password", "signInWithEmailAndPassword", "createAuthInvalidUserException", "Lcom/google/firebase/auth/FirebaseAuthInvalidUserException;", "action", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "createAuthInvalidUserException$firebase_java_sdk", "signOut", "", "getAccessToken", "Lcom/google/firebase/auth/GetTokenResult;", "forceRefresh", "", "refreshSource", "refreshToken", "T", "source", "map", "refreshToken$firebase_java_sdk", "enqueueRefreshTokenCall", "updateEmail", "updateEmail$firebase_java_sdk", "updateProfile", "Lcom/google/firebase/auth/UserProfileChangeRequest;", "updateProfile$firebase_java_sdk", "getUid", "addIdTokenListener", "listener", "removeIdTokenListener", "addAuthStateListener", "removeAuthStateListener", "useEmulator", "host", "port", "", "sendPasswordResetEmail", "settings", "Lcom/google/firebase/auth/ActionCodeSettings;", "signInWithCredential", "authCredential", "Lcom/google/firebase/auth/AuthCredential;", "checkActionCode", "Lcom/google/firebase/auth/ActionCodeResult;", "code", "confirmPasswordReset", "newPassword", "fetchSignInMethodsForEmail", "Lcom/google/firebase/auth/SignInMethodQueryResult;", "sendSignInLinkToEmail", "actionCodeSettings", "verifyPasswordResetCode", "updateCurrentUser", "applyActionCode", "languageCode", "getLanguageCode", "()Ljava/lang/String;", "isSignInWithEmailLink", "link", "signInWithEmailLink", "setLanguageCode", "", "Companion", "AuthStateListener", "IdTokenListener", "firebase-java-sdk"})
@SourceDebugExtension(value={"SMAP\nFirebaseAuth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseAuth.kt\ncom/google/firebase/auth/FirebaseAuth\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,858:1\n1#2:859\n*E\n"})
public final class FirebaseAuth
implements InternalAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirebaseApp app;
    @Nullable
    private final MediaType json;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener> internalIdTokenListeners;
    @NotNull
    private final CopyOnWriteArrayList<IdTokenListener> idTokenListeners;
    @NotNull
    private final CopyOnWriteArrayList<AuthStateListener> authStateListeners;
    @Nullable
    private FirebaseUserImpl user;
    @NotNull
    private UrlFactory urlFactory;
    @NotNull
    private TaskCompletionSource<FirebaseUserImpl> refreshSource;
    @NotNull
    private static final String REFRESH_TOKEN_TAG = "refresh_token_tag";

    /*
     * WARNING - void declaration
     */
    public FirebaseAuth(@NotNull FirebaseApp app) {
        void $this$refreshSource_u24lambda_u2414;
        TaskCompletionSource $this$user_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.app = app;
        this.json = MediaType.parse((String)"application/json; charset=utf-8");
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"build(...)");
        this.client = okHttpClient;
        this.internalIdTokenListeners = new CopyOnWriteArrayList();
        this.idTokenListeners = new CopyOnWriteArrayList();
        this.authStateListeners = new CopyOnWriteArrayList();
        TaskCompletionSource taskCompletionSource = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk();
        FirebaseAuth firebaseAuth = this;
        try {
            FirebaseUserImpl firebaseUserImpl;
            $this$user_u24lambda_u242 = taskCompletionSource;
            boolean bl = false;
            String string = ((FirebasePlatform)((Object)$this$user_u24lambda_u242)).retrieve(this.getKey(this.app));
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                firebaseUserImpl = new FirebaseUserImpl(this.app, JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(it)), false, null, null, null, null, 124, null);
            } else {
                firebaseUserImpl = null;
            }
            $this$user_u24lambda_u242 = Result.constructor-impl(firebaseUserImpl);
        }
        catch (Throwable bl) {
            $this$user_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        taskCompletionSource = $this$user_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)taskCompletionSource);
        if (throwable != null) {
            void it;
            TaskCompletionSource bl = $this$user_u24lambda_u242 = throwable;
            firebaseAuth = firebaseAuth2;
            boolean bl3 = false;
            it.printStackTrace();
            firebaseAuth2 = firebaseAuth;
        }
        firebaseAuth2.user = (FirebaseUserImpl)((Object)(Result.isFailure-impl((Object)taskCompletionSource) ? null : taskCompletionSource));
        this.urlFactory = new UrlFactory(this.app, null, 2, null);
        $this$user_u24lambda_u242 = taskCompletionSource = new TaskCompletionSource();
        firebaseAuth = this;
        boolean bl = false;
        $this$refreshSource_u24lambda_u2414.setException(new Exception());
        firebaseAuth.refreshSource = taskCompletionSource;
    }

    @NotNull
    public final FirebaseApp getApp() {
        return this.app;
    }

    @Nullable
    public final MediaType getJson$firebase_java_sdk() {
        return this.json;
    }

    @NotNull
    public final OkHttpClient getClient$firebase_java_sdk() {
        return this.client;
    }

    private final TaskCompletionSource<AuthResult> enqueueAuthPost(String url, RequestBody body, Function1<? super String, FirebaseUserImpl> setResult) {
        TaskCompletionSource<AuthResult> source = new TaskCompletionSource<AuthResult>();
        Request request = new Request.Builder().url(this.urlFactory.buildUrl(url)).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request, setResult){
            final /* synthetic */ TaskCompletionSource<AuthResult> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ Function1<String, FirebaseUserImpl> $setResult;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
                this.$setResult = $setResult;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void onResponse(Call call, Response response) throws IOException {
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        if (response.isSuccessful()) break block9;
                        var3_3 = this.$request;
                        Intrinsics.checkNotNull((Object)var3_3);
                        this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("accounts", var3_3, response));
                        break block10;
                    }
                    v0 /* !! */  = response.body();
                    if (v0 /* !! */  == null) ** GOTO lbl-1000
                    var4_5 = (Closeable)v0 /* !! */ ;
                    var5_6 = null;
                    try {
                        it = (ResponseBody)var4_5;
                        $i$a$-use-FirebaseAuth$enqueueAuthPost$1$onResponse$1 = false;
                        var6_7 = it.string();
                        v1 = var6_7;
                    }
                    catch (Throwable var6_8) {
                        var5_6 = var6_8;
                        throw var6_8;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var4_5, (Throwable)var5_6);
                    }
                    v0 /* !! */  = v1;
                    if (v1 != null) {
                        var4_5 = v0 /* !! */ ;
                        var5_6 = this.this$0;
                        var6_7 = this.$setResult;
                        var7_11 = this.$source;
                        responseBody = var4_5;
                        $i$a$-also-FirebaseAuth$enqueueAuthPost$1$onResponse$2 = false;
                        FirebaseAuth.access$setUser((FirebaseAuth)var5_6, (FirebaseUserImpl)var6_7.invoke((Object)responseBody));
                        var7_11.setResult((AuthResult)LambdaMetafactory.metafactory(null, null, null, ()Lcom/google/firebase/auth/FirebaseUser;, onResponse$lambda$2$lambda$1(com.google.firebase.auth.FirebaseAuth ), ()Lcom/google/firebase/auth/FirebaseUser;)((FirebaseAuth)var5_6));
                        v2 = var4_5;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = null;
                    }
                    if (v2 == null) {
                        var3_4 = this.$request;
                        Intrinsics.checkNotNull((Object)var3_4);
                        this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("accounts", var3_4, response));
                    }
                }
            }

            private static final FirebaseUser onResponse$lambda$2$lambda$1(FirebaseAuth this$0) {
                return FirebaseAuth.access$getUser$p(this$0);
            }
        });
        return source;
    }

    @Nullable
    public final FirebaseUser getCurrentUser() {
        return this.user;
    }

    @NotNull
    public final String getKey(@NotNull FirebaseApp $this$key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        String it = string = "[" + $this$key.getName() + "]";
        boolean bl = false;
        Object object = !$this$key.isDefaultApp() ? string : null;
        if (object == null) {
            object = "";
        }
        return "com.google.firebase.auth.FIREBASE_USER" + (String)object;
    }

    private final void setUser(FirebaseUserImpl value) {
        if (!Intrinsics.areEqual((Object)this.user, (Object)value)) {
            FirebaseUserImpl prev = this.user;
            this.user = value;
            if (value == null) {
                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().clear(this.getKey(this.app));
            } else {
                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(this.getKey(this.app), FirebaseAuthKt.getJsonParser().encodeToString((SerializationStrategy)FirebaseUserImpl.Companion.serializer(), (Object)value));
            }
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(prev, value, this, null){
                int label;
                final /* synthetic */ FirebaseUserImpl $prev;
                final /* synthetic */ FirebaseUserImpl $value;
                final /* synthetic */ FirebaseAuth this$0;
                {
                    this.$prev = $prev;
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Iterator<E> iterator;
                            ResultKt.throwOnFailure((Object)object);
                            FirebaseUserImpl firebaseUserImpl = this.$prev;
                            FirebaseUserImpl firebaseUserImpl2 = this.$value;
                            if (!Intrinsics.areEqual((Object)(firebaseUserImpl != null ? firebaseUserImpl.getUid() : null), (Object)(firebaseUserImpl2 != null ? firebaseUserImpl2.getUid() : null))) {
                                void $this$forEach$iv;
                                Iterable iterable = FirebaseAuth.access$getAuthStateListeners$p(this.this$0);
                                iterator = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    AuthStateListener l = (AuthStateListener)element$iv;
                                    boolean bl = false;
                                    l.onAuthStateChanged((FirebaseAuth)((Object)iterator));
                                }
                            }
                            FirebaseUserImpl firebaseUserImpl3 = this.$prev;
                            FirebaseUserImpl firebaseUserImpl4 = this.$value;
                            if (!Intrinsics.areEqual((Object)(firebaseUserImpl3 != null ? firebaseUserImpl3.getIdToken() : null), (Object)(firebaseUserImpl4 != null ? firebaseUserImpl4.getIdToken() : null))) {
                                FirebaseUserImpl firebaseUserImpl5 = this.$value;
                                InternalTokenResult result = new InternalTokenResult(firebaseUserImpl5 != null ? firebaseUserImpl5.getIdToken() : null);
                                Iterator<E> iterator2 = FirebaseAuth.access$getInternalIdTokenListeners$p(this.this$0).iterator();
                                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                                iterator = iterator2;
                                while (iterator.hasNext()) {
                                    com.google.firebase.auth.internal.IdTokenListener listener2 = (com.google.firebase.auth.internal.IdTokenListener)iterator.next();
                                    FirebaseUserImpl firebaseUserImpl6 = this.$value;
                                    Log.i("FirebaseAuth", "Calling onIdTokenChanged for " + (firebaseUserImpl6 != null ? firebaseUserImpl6.getUid() : null) + " on listener " + listener2);
                                    listener2.onIdTokenChanged(result);
                                }
                                Iterator<E> iterator3 = FirebaseAuth.access$getIdTokenListeners$p(this.this$0).iterator();
                                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
                                iterator = iterator3;
                                while (iterator.hasNext()) {
                                    IdTokenListener listener3 = (IdTokenListener)iterator.next();
                                    listener3.onIdTokenChanged(this.this$0);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @NotNull
    public final Task<AuthResult> signInAnonymously() {
        RequestBody requestBody = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true)))).toString());
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(...)");
        TaskCompletionSource<AuthResult> source = this.enqueueAuthPost("identitytoolkit.googleapis.com/v1/accounts:signUp", requestBody, (Function1<? super String, FirebaseUserImpl>)((Function1)arg_0 -> FirebaseAuth.signInAnonymously$lambda$4(this, arg_0)));
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    @NotNull
    public final Task<AuthResult> signInWithCustomToken(@NotNull String customToken) {
        Intrinsics.checkNotNullParameter((Object)customToken, (String)"customToken");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"token", (Object)JsonElementKt.JsonPrimitive((String)customToken)), TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true))};
        RequestBody requestBody = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(...)");
        Task<Task> task = this.enqueueAuthPost("www.googleapis.com/identitytoolkit/v3/relyingparty/verifyCustomToken", requestBody, (Function1<? super String, FirebaseUserImpl>)((Function1)arg_0 -> FirebaseAuth.signInWithCustomToken$lambda$5(this, arg_0))).getTask().continueWith(arg_0 -> FirebaseAuth.signInWithCustomToken$lambda$6(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(task, (String)"continueWith(...)");
        Task<Task> source = task;
        Task task2 = source.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"getResult(...)");
        return task2;
    }

    private final Task<AuthResult> updateByGetAccountInfo() {
        TaskCompletionSource<AuthResult> source = new TaskCompletionSource<AuthResult>();
        FirebaseUserImpl firebaseUserImpl = this.user;
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"idToken", (Object)JsonElementKt.JsonPrimitive((String)(firebaseUserImpl != null ? firebaseUserImpl.getIdToken() : null))))).toString());
        Request request = new Request.Builder().url(this.urlFactory.buildUrl("www.googleapis.com/identitytoolkit/v3/relyingparty/getAccountInfo")).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request){
            final /* synthetic */ TaskCompletionSource<AuthResult> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                block15: {
                    Object object;
                    Object object2;
                    Object object3;
                    Json json;
                    block17: {
                        block16: {
                            block14: {
                                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                                if (response.isSuccessful()) break block14;
                                Request request = this.$request;
                                Intrinsics.checkNotNull((Object)request);
                                this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("updateWithAccountInfo", request, response));
                                break block15;
                            }
                            json = FirebaseAuthKt.getJsonParser();
                            object3 = response.body();
                            if (object3 == null) break block16;
                            object2 = (Closeable)object3;
                            Json json2 = json;
                            object = null;
                            try {
                                Object it = (ResponseBody)object2;
                                boolean bl = false;
                                it = it.string();
                            }
                            catch (Throwable it) {
                                object = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                            }
                            Object object4 = it;
                            json = json2;
                            object3 = object4;
                            if (object4 != null) break block17;
                        }
                        object3 = "";
                    }
                    JsonObject newBody = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement((String)object3));
                    FirebaseUserImpl firebaseUserImpl = FirebaseAuth.access$getUser$p(this.this$0);
                    if (firebaseUserImpl != null) {
                        Object object5;
                        Object object6;
                        FirebaseUserImpl firebaseUserImpl2 = firebaseUserImpl;
                        object2 = this.this$0;
                        object = this.$source;
                        FirebaseUserImpl prev = firebaseUserImpl2;
                        boolean bl = false;
                        FirebaseApp firebaseApp = ((FirebaseAuth)object2).getApp();
                        boolean bl2 = prev.isAnonymous();
                        String string = prev.getUid();
                        String string2 = prev.getIdToken();
                        String string3 = prev.getRefreshToken();
                        int n = prev.getExpiresIn();
                        Object object7 = (JsonElement)newBody.get((Object)"createdAt");
                        long l = object7 != null && (object7 = JsonElementKt.getJsonPrimitive((JsonElement)object7)) != null && (object7 = JsonElementKt.getLongOrNull((JsonPrimitive)object7)) != null ? ((Long)object7).longValue() : prev.getCreatedAt();
                        Object object8 = (JsonElement)newBody.get((Object)"email");
                        if (object8 == null || (object8 = JsonElementKt.getJsonPrimitive((JsonElement)object8)) == null || (object8 = JsonElementKt.getContentOrNull((JsonPrimitive)object8)) == null) {
                            object8 = prev.getEmail();
                        }
                        if ((object6 = (JsonElement)newBody.get((Object)"photoUrl")) == null || (object6 = JsonElementKt.getJsonPrimitive((JsonElement)object6)) == null || (object6 = JsonElementKt.getContentOrNull((JsonPrimitive)object6)) == null) {
                            object6 = prev.getPhotoUrl();
                        }
                        if ((object5 = (JsonElement)newBody.get((Object)"displayName")) == null || (object5 = JsonElementKt.getJsonPrimitive((JsonElement)object5)) == null || (object5 = JsonElementKt.getContentOrNull((JsonPrimitive)object5)) == null) {
                            object5 = prev.getDisplayName();
                        }
                        FirebaseAuth.access$setUser((FirebaseAuth)object2, new FirebaseUserImpl(firebaseApp, bl2, string, string2, string3, n, l, (String)object8, (String)object6, (String)object5, null, 1024, null));
                        ((TaskCompletionSource)object).setResult(() -> updateByGetAccountInfo.1.onResponse$lambda$2$lambda$1((FirebaseAuth)object2));
                    }
                    this.$source.setResult(null);
                }
            }

            private static final FirebaseUser onResponse$lambda$2$lambda$1(FirebaseAuth this$0) {
                return FirebaseAuth.access$getUser$p(this$0);
            }
        });
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    @NotNull
    public final Task<AuthResult> createUserWithEmailAndPassword(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"email", (Object)JsonElementKt.JsonPrimitive((String)email)), TuplesKt.to((Object)"password", (Object)JsonElementKt.JsonPrimitive((String)password)), TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true))};
        RequestBody requestBody = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(...)");
        TaskCompletionSource<AuthResult> source = this.enqueueAuthPost("www.googleapis.com/identitytoolkit/v3/relyingparty/signupNewUser", requestBody, (Function1<? super String, FirebaseUserImpl>)((Function1)arg_0 -> FirebaseAuth.createUserWithEmailAndPassword$lambda$7(this, arg_0)));
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    @NotNull
    public final Task<AuthResult> signInWithEmailAndPassword(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"email", (Object)JsonElementKt.JsonPrimitive((String)email)), TuplesKt.to((Object)"password", (Object)JsonElementKt.JsonPrimitive((String)password)), TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true))};
        RequestBody requestBody = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(...)");
        TaskCompletionSource<AuthResult> source = this.enqueueAuthPost("www.googleapis.com/identitytoolkit/v3/relyingparty/verifyPassword", requestBody, (Function1<? super String, FirebaseUserImpl>)((Function1)arg_0 -> FirebaseAuth.signInWithEmailAndPassword$lambda$8(this, arg_0)));
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FirebaseAuthInvalidUserException createAuthInvalidUserException$firebase_java_sdk(@NotNull String action, @NotNull Request request, @NotNull Response response) {
        String string;
        JsonPrimitive jsonPrimitive;
        JsonElement jsonElement;
        String string2;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        Closeable closeable = (Closeable)responseBody;
        Throwable throwable = null;
        try {
            ResponseBody it = (ResponseBody)closeable;
            boolean bl = false;
            string2 = it.string();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String body = string2;
        Json json = FirebaseAuthKt.getJsonParser();
        Intrinsics.checkNotNull((Object)body);
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(body));
        throwable = (JsonElement)jsonObject.get((Object)"error");
        return new FirebaseAuthInvalidUserException(throwable != null && (string2 = JsonElementKt.getJsonObject((JsonElement)throwable)) != null && (jsonElement = (JsonElement)string2.get((Object)"message")) != null && (jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null && (string = JsonElementKt.getContentOrNull((JsonPrimitive)jsonPrimitive)) != null ? string : "UNKNOWN_ERROR", action + " API returned an error, with url [" + request.method() + "] " + request.url() + " " + request.body() + " -- response [" + response.code() + "] " + response.message() + " " + body);
    }

    public final void signOut() {
        Object v1;
        block3: {
            List list = this.client.dispatcher().queuedCalls();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queuedCalls(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Call it = (Call)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.request().tag(), (Object)REFRESH_TOKEN_TAG)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Call call = v1;
        if (call != null) {
            call.cancel();
        } else {
            Function0 cfr_ignored_0 = () -> FirebaseAuth.signOut$lambda$12(this);
        }
        this.setUser(null);
    }

    @Override
    @NotNull
    public Task<GetTokenResult> getAccessToken(boolean forceRefresh) {
        FirebaseUserImpl firebaseUserImpl = this.user;
        if (firebaseUserImpl == null) {
            Task<GetTokenResult> task = Tasks.forException(new FirebaseNoSignedInUserException("Please sign in before trying to get a token."));
            Intrinsics.checkNotNullExpressionValue(task, (String)"forException(...)");
            return task;
        }
        FirebaseUserImpl user2 = firebaseUserImpl;
        if (!forceRefresh && user2.getCreatedAt() + (long)(user2.getExpiresIn() * 1000) - (long)300000 > System.currentTimeMillis()) {
            Task<GetTokenResult> task = Tasks.forResult(new GetTokenResult(user2.getIdToken(), user2.getClaims()));
            Intrinsics.checkNotNullExpressionValue(task, (String)"forResult(...)");
            return task;
        }
        TaskCompletionSource source = new TaskCompletionSource();
        this.refreshToken$firebase_java_sdk(user2, source, arg_0 -> FirebaseAuth.getAccessToken$lambda$13(user2, arg_0));
        Task<GetTokenResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void refreshToken$firebase_java_sdk(@NotNull FirebaseUserImpl user2, @NotNull TaskCompletionSource<T> source, @NotNull Function1<? super FirebaseUserImpl, ? extends T> map2) {
        void it;
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource;
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource2 = taskCompletionSource = this.refreshSource;
        FirebaseAuth firebaseAuth = this;
        boolean bl = false;
        boolean bl2 = it.getTask().isComplete();
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource3 = !bl2 ? taskCompletionSource : null;
        if (taskCompletionSource3 == null) {
            taskCompletionSource3 = this.enqueueRefreshTokenCall(user2);
        }
        firebaseAuth.refreshSource = taskCompletionSource3;
        this.refreshSource.getTask().addOnSuccessListener(arg_0 -> FirebaseAuth.refreshToken$lambda$17(arg_0 -> FirebaseAuth.refreshToken$lambda$16(source, map2, arg_0), arg_0));
        this.refreshSource.getTask().addOnFailureListener(arg_0 -> FirebaseAuth.refreshToken$lambda$18(source, arg_0));
    }

    private final TaskCompletionSource<FirebaseUserImpl> enqueueRefreshTokenCall(FirebaseUserImpl user2) {
        TaskCompletionSource<FirebaseUserImpl> source = new TaskCompletionSource<FirebaseUserImpl>();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"refresh_token", (Object)JsonElementKt.JsonPrimitive((String)user2.getRefreshToken())), TuplesKt.to((Object)"grant_type", (Object)JsonElementKt.JsonPrimitive((String)"refresh_token"))};
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request request = new Request.Builder().url(this.urlFactory.buildUrl("securetoken.googleapis.com/v1/token")).post(body).tag((Object)REFRESH_TOKEN_TAG).build();
        this.client.newCall(request).enqueue(new Callback(source, body, this, user2){
            final /* synthetic */ TaskCompletionSource<FirebaseUserImpl> $source;
            final /* synthetic */ RequestBody $body;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ FirebaseUserImpl $user;
            {
                this.$source = $source;
                this.$body = $body;
                this.this$0 = $receiver;
                this.$user = $user;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                String responseBody;
                Object object;
                Object object2;
                Object object3;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                ResponseBody responseBody2 = response.body();
                if (responseBody2 != null) {
                    object3 = (Closeable)responseBody2;
                    object2 = null;
                    try {
                        ResponseBody it = (ResponseBody)object3;
                        boolean bl = false;
                        object = it.string();
                        v1 = object;
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                    }
                } else {
                    v1 = responseBody = null;
                }
                if (!response.isSuccessful() || responseBody == null) {
                    String string = responseBody;
                    if (string == null) {
                        string = "";
                    }
                    this.signOutAndThrowInvalidUserException(string, "token API returned an error: " + this.$body);
                } else {
                    JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(responseBody));
                    object3 = this.this$0;
                    object2 = this.$user;
                    object = this.$source;
                    JsonObject $this$onResponse_u24lambda_u241 = jsonObject;
                    boolean bl = false;
                    FirebaseUserImpl newUser = new FirebaseUserImpl(((FirebaseAuth)object3).getApp(), $this$onResponse_u24lambda_u241, ((FirebaseUserImpl)object2).isAnonymous(), ((FirebaseUserImpl)object2).getEmail(), null, null, null, 112, null);
                    if (!Intrinsics.areEqual((Object)newUser.getClaims().get("aud"), (Object)((FirebaseAuth)object3).getApp().getOptions().getProjectId())) {
                        this.signOutAndThrowInvalidUserException(newUser.getClaims().toString(), "Project ID's do not match " + newUser.getClaims().get("aud") + " != " + ((FirebaseAuth)object3).getApp().getOptions().getProjectId());
                    } else {
                        FirebaseAuth.access$setUser((FirebaseAuth)object3, newUser);
                        ((TaskCompletionSource)object).setResult(newUser);
                    }
                }
            }

            private final void signOutAndThrowInvalidUserException(String body, String message) {
                this.this$0.signOut();
                this.$source.setException(new FirebaseAuthInvalidUserException(body, message));
            }
        });
        return source;
    }

    @NotNull
    public final Task<Unit> updateEmail$firebase_java_sdk(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        TaskCompletionSource<Unit> source = new TaskCompletionSource<Unit>();
        Pair[] pairArray = new Pair[3];
        FirebaseUserImpl firebaseUserImpl = this.user;
        pairArray[0] = TuplesKt.to((Object)"idToken", (Object)JsonElementKt.JsonPrimitive((String)(firebaseUserImpl != null ? firebaseUserImpl.getIdToken() : null)));
        pairArray[1] = TuplesKt.to((Object)"email", (Object)JsonElementKt.JsonPrimitive((String)email));
        pairArray[2] = TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true));
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request request = new Request.Builder().url(this.urlFactory.buildUrl("identitytoolkit.googleapis.com/v1/accounts:update")).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request){
            final /* synthetic */ TaskCompletionSource<Unit> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                block17: {
                    Object object;
                    Object object2;
                    Json json;
                    block19: {
                        block18: {
                            block16: {
                                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                                if (response.isSuccessful()) break block16;
                                this.this$0.signOut();
                                Request request = this.$request;
                                Intrinsics.checkNotNull((Object)request);
                                this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("updateEmail", request, response));
                                break block17;
                            }
                            json = FirebaseAuthKt.getJsonParser();
                            object2 = response.body();
                            if (object2 == null) break block18;
                            object = (Closeable)object2;
                            Json json2 = json;
                            Throwable throwable = null;
                            try {
                                Object it = (ResponseBody)object;
                                boolean bl = false;
                                it = it.string();
                            }
                            catch (Throwable it) {
                                throwable = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            }
                            Object object3 = it;
                            json = json2;
                            object2 = object3;
                            if (object3 != null) break block19;
                        }
                        object2 = "";
                    }
                    JsonObject newBody = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement((String)object2));
                    FirebaseUserImpl firebaseUserImpl = FirebaseAuth.access$getUser$p(this.this$0);
                    if (firebaseUserImpl != null) {
                        Object object4;
                        Object object5;
                        Object object6;
                        Object object7;
                        FirebaseUserImpl firebaseUserImpl2 = firebaseUserImpl;
                        object = this.this$0;
                        FirebaseUserImpl prev = firebaseUserImpl2;
                        boolean bl = false;
                        FirebaseApp firebaseApp = ((FirebaseAuth)object).getApp();
                        boolean bl2 = prev.isAnonymous();
                        String string = prev.getUid();
                        Object object8 = (JsonElement)newBody.get((Object)"idToken");
                        if (object8 == null || (object8 = JsonElementKt.getJsonPrimitive((JsonElement)object8)) == null || (object8 = JsonElementKt.getContentOrNull((JsonPrimitive)object8)) == null) {
                            object8 = prev.getIdToken();
                        }
                        if ((object7 = (JsonElement)newBody.get((Object)"refreshToken")) == null || (object7 = JsonElementKt.getJsonPrimitive((JsonElement)object7)) == null || (object7 = JsonElementKt.getContentOrNull((JsonPrimitive)object7)) == null) {
                            object7 = prev.getRefreshToken();
                        }
                        int n = (object6 = (JsonElement)newBody.get((Object)"expiresIn")) != null && (object6 = JsonElementKt.getJsonPrimitive((JsonElement)object6)) != null && (object6 = JsonElementKt.getIntOrNull((JsonPrimitive)object6)) != null ? ((Integer)object6).intValue() : prev.getExpiresIn();
                        long l = prev.getCreatedAt();
                        Object object9 = (JsonElement)newBody.get((Object)"newEmail");
                        if (object9 == null || (object9 = JsonElementKt.getJsonPrimitive((JsonElement)object9)) == null || (object9 = JsonElementKt.getContentOrNull((JsonPrimitive)object9)) == null) {
                            object9 = prev.getEmail();
                        }
                        if ((object5 = (JsonElement)newBody.get((Object)"photoUrl")) == null || (object5 = JsonElementKt.getJsonPrimitive((JsonElement)object5)) == null || (object5 = JsonElementKt.getContentOrNull((JsonPrimitive)object5)) == null) {
                            object5 = prev.getPhotoUrl();
                        }
                        if ((object4 = (JsonElement)newBody.get((Object)"displayName")) == null || (object4 = JsonElementKt.getJsonPrimitive((JsonElement)object4)) == null || (object4 = JsonElementKt.getContentOrNull((JsonPrimitive)object4)) == null) {
                            object4 = prev.getDisplayName();
                        }
                        FirebaseAuth.access$setUser((FirebaseAuth)object, new FirebaseUserImpl(firebaseApp, bl2, string, (String)object8, (String)object7, n, l, (String)object9, (String)object5, (String)object4, null, 1024, null));
                    }
                    this.$source.setResult(null);
                }
            }
        });
        Task<Unit> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    @NotNull
    public final Task<Unit> updateProfile$firebase_java_sdk(@NotNull UserProfileChangeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        TaskCompletionSource<Unit> source = new TaskCompletionSource<Unit>();
        Pair[] pairArray = new Pair[4];
        FirebaseUserImpl firebaseUserImpl = this.user;
        pairArray[0] = TuplesKt.to((Object)"idToken", (Object)JsonElementKt.JsonPrimitive((String)(firebaseUserImpl != null ? firebaseUserImpl.getIdToken() : null)));
        pairArray[1] = TuplesKt.to((Object)"displayName", (Object)JsonElementKt.JsonPrimitive((String)request.getDisplayName$firebase_java_sdk()));
        pairArray[2] = TuplesKt.to((Object)"photoUrl", (Object)JsonElementKt.JsonPrimitive((String)request.getPhotoUrl$firebase_java_sdk()));
        pairArray[3] = TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true));
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request req = new Request.Builder().url(this.urlFactory.buildUrl("identitytoolkit.googleapis.com/v1/accounts:update")).post(body).build();
        this.client.newCall(req).enqueue(new Callback(source, this, req){
            final /* synthetic */ TaskCompletionSource<Unit> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $req;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$req = $req;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                block17: {
                    Object object;
                    Object object2;
                    Json json;
                    block19: {
                        block18: {
                            block16: {
                                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                                if (response.isSuccessful()) break block16;
                                this.this$0.signOut();
                                Request request = this.$req;
                                Intrinsics.checkNotNull((Object)request);
                                this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("updateProfile", request, response));
                                break block17;
                            }
                            json = FirebaseAuthKt.getJsonParser();
                            object2 = response.body();
                            if (object2 == null) break block18;
                            object = (Closeable)object2;
                            Json json2 = json;
                            Throwable throwable = null;
                            try {
                                Object it = (ResponseBody)object;
                                boolean bl = false;
                                it = it.string();
                            }
                            catch (Throwable it) {
                                throwable = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            }
                            Object object3 = it;
                            json = json2;
                            object2 = object3;
                            if (object3 != null) break block19;
                        }
                        object2 = "";
                    }
                    JsonObject newBody = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement((String)object2));
                    FirebaseUserImpl firebaseUserImpl = FirebaseAuth.access$getUser$p(this.this$0);
                    if (firebaseUserImpl != null) {
                        Object object4;
                        Object object5;
                        Object object6;
                        Object object7;
                        FirebaseUserImpl firebaseUserImpl2 = firebaseUserImpl;
                        object = this.this$0;
                        FirebaseUserImpl prev = firebaseUserImpl2;
                        boolean bl = false;
                        FirebaseApp firebaseApp = ((FirebaseAuth)object).getApp();
                        boolean bl2 = prev.isAnonymous();
                        String string = prev.getUid();
                        Object object8 = (JsonElement)newBody.get((Object)"idToken");
                        if (object8 == null || (object8 = JsonElementKt.getJsonPrimitive((JsonElement)object8)) == null || (object8 = JsonElementKt.getContentOrNull((JsonPrimitive)object8)) == null) {
                            object8 = prev.getIdToken();
                        }
                        if ((object7 = (JsonElement)newBody.get((Object)"refreshToken")) == null || (object7 = JsonElementKt.getJsonPrimitive((JsonElement)object7)) == null || (object7 = JsonElementKt.getContentOrNull((JsonPrimitive)object7)) == null) {
                            object7 = prev.getRefreshToken();
                        }
                        int n = (object6 = (JsonElement)newBody.get((Object)"expiresIn")) != null && (object6 = JsonElementKt.getJsonPrimitive((JsonElement)object6)) != null && (object6 = JsonElementKt.getIntOrNull((JsonPrimitive)object6)) != null ? ((Integer)object6).intValue() : prev.getExpiresIn();
                        long l = prev.getCreatedAt();
                        Object object9 = (JsonElement)newBody.get((Object)"newEmail");
                        if (object9 == null || (object9 = JsonElementKt.getJsonPrimitive((JsonElement)object9)) == null || (object9 = JsonElementKt.getContentOrNull((JsonPrimitive)object9)) == null) {
                            object9 = prev.getEmail();
                        }
                        if ((object5 = (JsonElement)newBody.get((Object)"photoUrl")) == null || (object5 = JsonElementKt.getJsonPrimitive((JsonElement)object5)) == null || (object5 = JsonElementKt.getContentOrNull((JsonPrimitive)object5)) == null) {
                            object5 = prev.getPhotoUrl();
                        }
                        if ((object4 = (JsonElement)newBody.get((Object)"displayName")) == null || (object4 = JsonElementKt.getJsonPrimitive((JsonElement)object4)) == null || (object4 = JsonElementKt.getContentOrNull((JsonPrimitive)object4)) == null) {
                            object4 = prev.getDisplayName();
                        }
                        FirebaseAuth.access$setUser((FirebaseAuth)object, new FirebaseUserImpl(firebaseApp, bl2, string, (String)object8, (String)object7, n, l, (String)object9, (String)object5, (String)object4, null, 1024, null));
                    }
                    this.$source.setResult(null);
                }
            }
        });
        Task<Unit> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    @Override
    @Nullable
    public String getUid() {
        FirebaseUserImpl firebaseUserImpl = this.user;
        return firebaseUserImpl != null ? firebaseUserImpl.getUid() : null;
    }

    @Override
    public void addIdTokenListener(@NotNull com.google.firebase.auth.internal.IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.internalIdTokenListeners.addIfAbsent(listener2);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, null){
            int label;
            final /* synthetic */ com.google.firebase.auth.internal.IdTokenListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FirebaseUserImpl firebaseUserImpl = FirebaseAuth.access$getUser$p(this.this$0);
                        this.$listener.onIdTokenChanged(new InternalTokenResult(firebaseUserImpl != null ? firebaseUserImpl.getIdToken() : null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void removeIdTokenListener(@NotNull com.google.firebase.auth.internal.IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.internalIdTokenListeners.remove(listener2);
    }

    public final synchronized void addAuthStateListener(@NotNull AuthStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.authStateListeners.addIfAbsent(listener2);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, null){
            int label;
            final /* synthetic */ AuthStateListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$listener.onAuthStateChanged(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final synchronized void removeAuthStateListener(@NotNull AuthStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.authStateListeners.remove(listener2);
    }

    public final void addIdTokenListener(@NotNull IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.idTokenListeners.addIfAbsent(listener2);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, null){
            int label;
            final /* synthetic */ IdTokenListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$listener.onIdTokenChanged(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void removeIdTokenListener(@NotNull IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.idTokenListeners.remove(listener2);
    }

    public final void useEmulator(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.urlFactory = new UrlFactory(this.app, "http://" + host + ":" + port + "/");
    }

    @NotNull
    public final Task<Unit> sendPasswordResetEmail(@NotNull String email, @Nullable ActionCodeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> signInWithCredential(@NotNull AuthCredential authCredential) {
        Intrinsics.checkNotNullParameter((Object)authCredential, (String)"authCredential");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<ActionCodeResult> checkActionCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> confirmPasswordReset(@NotNull String code, @NotNull String newPassword) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> sendSignInLinkToEmail(@NotNull String email, @NotNull ActionCodeSettings actionCodeSettings) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)actionCodeSettings, (String)"actionCodeSettings");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<String> verifyPasswordResetCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> updateCurrentUser(@NotNull FirebaseUser user2) {
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> applyActionCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final String getLanguageCode() {
        throw new NotImplementedError(null, 1, null);
    }

    public final boolean isSignInWithEmailLink(@NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> signInWithEmailLink(@NotNull String email, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Void setLanguageCode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new NotImplementedError(null, 1, null);
    }

    private static final FirebaseUserImpl signInAnonymously$lambda$4(FirebaseAuth this$0, String responseBody) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        return new FirebaseUserImpl(this$0.app, JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(responseBody)), true, null, null, null, null, 120, null);
    }

    private static final FirebaseUserImpl signInWithCustomToken$lambda$5(FirebaseAuth this$0, String responseBody) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        return new FirebaseUserImpl(this$0.app, JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(responseBody)), false, null, null, null, null, 124, null);
    }

    private static final Task signInWithCustomToken$lambda$6(FirebaseAuth this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.updateByGetAccountInfo();
    }

    private static final FirebaseUserImpl createUserWithEmailAndPassword$lambda$7(FirebaseAuth this$0, String responseBody) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        return new FirebaseUserImpl(this$0.app, JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(responseBody)), false, null, null, null, null, 124, null);
    }

    private static final FirebaseUserImpl signInWithEmailAndPassword$lambda$8(FirebaseAuth this$0, String responseBody) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        return new FirebaseUserImpl(this$0.app, JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(responseBody)), false, null, null, null, null, 124, null);
    }

    private static final Unit signOut$lambda$12(FirebaseAuth this$0) {
        Unit unit;
        Object v1;
        block3: {
            List list = this$0.client.dispatcher().runningCalls();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runningCalls(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Call it = (Call)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.request().tag(), (Object)REFRESH_TOKEN_TAG)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Call call = v1;
        if (call != null) {
            call.cancel();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final GetTokenResult getAccessToken$lambda$13(FirebaseUserImpl $user, FirebaseUserImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new GetTokenResult(it.getIdToken(), $user.getClaims());
    }

    private static final Unit refreshToken$lambda$16(TaskCompletionSource $source, Function1 $map, FirebaseUserImpl it) {
        Intrinsics.checkNotNull((Object)it);
        $source.setResult($map.invoke((Object)it));
        return Unit.INSTANCE;
    }

    private static final void refreshToken$lambda$17(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void refreshToken$lambda$18(TaskCompletionSource $source, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $source.setException(new FirebaseException(it.toString(), it));
    }

    @JvmStatic
    @NotNull
    public static final FirebaseAuth getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final FirebaseAuth getInstance(@NotNull FirebaseApp app) {
        return Companion.getInstance(app);
    }

    public static final /* synthetic */ FirebaseUserImpl access$getUser$p(FirebaseAuth $this) {
        return $this.user;
    }

    public static final /* synthetic */ void access$setUser(FirebaseAuth $this, FirebaseUserImpl value) {
        $this.setUser(value);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getAuthStateListeners$p(FirebaseAuth $this) {
        return $this.authStateListeners;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getInternalIdTokenListeners$p(FirebaseAuth $this) {
        return $this.internalIdTokenListeners;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getIdTokenListeners$p(FirebaseAuth $this) {
        return $this.idTokenListeners;
    }

    @FunctionalInterface
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$AuthStateListener;", "", "onAuthStateChanged", "", "auth", "Lcom/google/firebase/auth/FirebaseAuth;", "firebase-java-sdk"})
    public static interface AuthStateListener {
        public void onAuthStateChanged(@NotNull FirebaseAuth var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$Companion;", "", "<init>", "()V", "getInstance", "Lcom/google/firebase/auth/FirebaseAuth;", "app", "Lcom/google/firebase/FirebaseApp;", "REFRESH_TOKEN_TAG", "", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FirebaseAuth getInstance() {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)firebaseApp, (String)"getInstance(...)");
            return this.getInstance(firebaseApp);
        }

        @JvmStatic
        @NotNull
        public final FirebaseAuth getInstance(@NotNull FirebaseApp app) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            FirebaseAuth firebaseAuth = app.get(FirebaseAuth.class);
            Intrinsics.checkNotNullExpressionValue((Object)firebaseAuth, (String)"get(...)");
            return firebaseAuth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @FunctionalInterface
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$IdTokenListener;", "", "onIdTokenChanged", "", "auth", "Lcom/google/firebase/auth/FirebaseAuth;", "firebase-java-sdk"})
    public static interface IdTokenListener {
        public void onIdTokenChanged(@NotNull FirebaseAuth var1);
    }
}

