/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.Keep;
import androidx.annotation.RestrictTo;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.storage.FirebaseStorageComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class StorageRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-gcs";
    Qualified<Executor> blockingExecutor = Qualified.qualified(Blocking.class, Executor.class);
    Qualified<Executor> uiExecutor = Qualified.qualified(UiThread.class, Executor.class);

    @Override
    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder(FirebaseStorageComponent.class).name(LIBRARY_NAME).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(this.blockingExecutor)).add(Dependency.required(this.uiExecutor)).add(Dependency.optionalProvider(InternalAuthProvider.class)).add(Dependency.optionalProvider(InteropAppCheckTokenProvider.class)).factory(c -> new FirebaseStorageComponent(c.get(FirebaseApp.class), c.getProvider(InternalAuthProvider.class), c.getProvider(InteropAppCheckTokenProvider.class), c.get(this.blockingExecutor), c.get(this.uiExecutor))).build(), LibraryVersionComponent.create(LIBRARY_NAME, "20.3.0"));
    }
}

