/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.config;

import dev.jorel.commandapi.config.CommentedConfigOption;
import dev.jorel.commandapi.config.CommentedSection;
import dev.jorel.commandapi.config.ConfigurationAdapter;
import dev.jorel.commandapi.config.DefaultConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class ConfigGenerator {
    private final DefaultConfig defaultConfig;

    private ConfigGenerator(DefaultConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public static ConfigGenerator createNew(DefaultConfig defaultConfig) {
        return new ConfigGenerator(defaultConfig);
    }

    public <T> ConfigurationAdapter<T> generate(ConfigurationAdapter<T> existingConfig) {
        ConfigurationAdapter<T> updatedConfig = existingConfig.createNew();
        boolean shouldRemoveValues = this.shouldRemoveOptions(existingConfig);
        boolean wasConfigUpdated = false;
        for (Map.Entry<String, CommentedConfigOption<?>> entry : this.defaultConfig.getAllOptions().entrySet()) {
            String path = entry.getKey();
            if (existingConfig.contains(path)) {
                updatedConfig.tryCreateSection(path);
                updatedConfig.setValue(path, existingConfig.getValue(path));
            } else {
                wasConfigUpdated = true;
                updatedConfig.tryCreateSection(path);
                updatedConfig.setValue(path, entry.getValue().option());
            }
            Object[] defaultComment = entry.getValue().comment();
            Object[] configComment = existingConfig.getComment(path);
            if (!Arrays.equals(defaultComment, configComment)) {
                wasConfigUpdated = true;
            }
            updatedConfig.setComment(path, entry.getValue().comment());
        }
        for (Map.Entry<String, Record> entry : this.defaultConfig.getAllSections().entrySet()) {
            Object[] configComment;
            Object[] defaultComment = ((CommentedSection)entry.getValue()).comment();
            if (!Arrays.equals(defaultComment, configComment = existingConfig.getComment(entry.getKey()))) {
                wasConfigUpdated = true;
            }
            updatedConfig.setComment(entry.getKey(), ((CommentedSection)entry.getValue()).comment());
        }
        if (shouldRemoveValues) {
            wasConfigUpdated = true;
        }
        return wasConfigUpdated ? updatedConfig.complete() : null;
    }

    private <T> boolean shouldRemoveOptions(ConfigurationAdapter<T> config) {
        Set<String> configOptions = config.getKeys();
        Set<String> defaultConfigOptions = this.defaultConfig.getAllOptions().keySet();
        return !defaultConfigOptions.containsAll(configOptions);
    }
}

