/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@FunctionalInterface
public interface ArgumentSuggestions {
    public CompletableFuture<Suggestions> suggest(SuggestionInfo var1, SuggestionsBuilder var2) throws CommandSyntaxException;

    public static ArgumentSuggestions empty() {
        return (info, builder) -> builder.buildFuture();
    }

    public static ArgumentSuggestions strings(String ... suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.toSuggestions(builder, suggestions));
    }

    public static ArgumentSuggestions strings(Function<SuggestionInfo, String[]> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.toSuggestions(builder, (String[])suggestions.apply(info)));
    }

    public static ArgumentSuggestions stringsAsync(Function<SuggestionInfo, CompletableFuture<String[]>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(strings -> ArgumentSuggestions.toSuggestions(builder, strings));
    }

    public static ArgumentSuggestions stringsWithTooltips(IStringTooltip ... suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.toSuggestions(builder, suggestions));
    }

    public static ArgumentSuggestions stringsWithTooltips(Function<SuggestionInfo, IStringTooltip[]> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.toSuggestions(builder, (IStringTooltip[])suggestions.apply(info)));
    }

    public static ArgumentSuggestions stringsWithTooltipsAsync(Function<SuggestionInfo, CompletableFuture<IStringTooltip[]>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(stringsWithTooltips -> ArgumentSuggestions.toSuggestions(builder, stringsWithTooltips));
    }

    private static Suggestions toSuggestions(SuggestionsBuilder builder, String ... suggestions) {
        for (String suggestion : suggestions) {
            builder.suggest(suggestion);
        }
        return builder.build();
    }

    private static Suggestions toSuggestions(SuggestionsBuilder builder, IStringTooltip ... suggestions) {
        for (IStringTooltip suggestion : suggestions) {
            if (suggestion.getTooltip() == null) {
                builder.suggest(suggestion.getSuggestion());
                continue;
            }
            builder.suggest(suggestion.getSuggestion(), (Message)new LiteralMessage(suggestion.getTooltip()));
        }
        return builder.build();
    }

    private static <T> CompletableFuture<T> future(T value) {
        return CompletableFuture.completedFuture(value);
    }
}

