/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.exceptions.InvalidRangeException;
import dev.jorel.commandapi.nms.NMS;

public class IntegerArgument
extends SafeOverrideableArgument<Integer> {
    public IntegerArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer(), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer((int)min), String::valueOf);
    }

    public IntegerArgument(String nodeName, int min, int max) {
        super(nodeName, (ArgumentType<?>)IntegerArgumentType.integer((int)min, (int)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<?> getPrimitiveType() {
        return Integer.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_INTEGER;
    }

    public <CommandListenerWrapper> Object parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

