/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.Config;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public final class CommandAPI {
    private static boolean canRegister = true;
    static Config config;
    static File dispatcherFile;
    static Logger logger;
    private static boolean loaded;

    private CommandAPI() {
    }

    static Config getConfiguration() {
        if (config == null) {
            CommandAPI.logWarning("Could not find any configuration for the CommandAPI. Loading basic built-in configuration. Did you forget to call CommandAPI.onLoad(config)?");
            CommandAPI.onLoad(new CommandAPIConfig());
        }
        return config;
    }

    static File getDispatcherFile() {
        return dispatcherFile;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = new CommandAPILogger();
        }
        return logger;
    }

    public static void logInfo(String message) {
        if (config.hasVerboseOutput() && !config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message);
        }
    }

    public static void logNormal(String message) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message);
        }
    }

    public static void logWarning(String message) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().warning(message);
        }
    }

    public static void logError(String message) {
        CommandAPI.getLogger().severe(message);
    }

    @Deprecated(forRemoval=true)
    public static void onLoad(boolean verbose) {
        if (!loaded) {
            config = new Config(verbose);
            CommandAPIHandler.getInstance().checkDependencies();
            loaded = true;
        } else {
            CommandAPI.getLogger().severe("You've tried to call the CommandAPI's onLoad() method more than once!");
        }
    }

    public static void onLoad(CommandAPIConfig config) {
        if (!loaded) {
            CommandAPI.config = new Config(config);
            CommandAPIHandler.getInstance().checkDependencies();
            loaded = true;
        } else {
            CommandAPI.getLogger().severe("You've tried to call the CommandAPI's onLoad() method more than once!");
        }
    }

    public static void onEnable(Plugin plugin) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, () -> {
            canRegister = false;
            CommandAPIHandler.getInstance().fixPermissions();
            try {
                CommandAPIHandler.getInstance().getNMS().reloadDataPacks();
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            CommandAPIHandler.getInstance().updateHelpForCommands();
        }, 0L);
        Listener playerJoinListener = new Listener(){

            @EventHandler(priority=EventPriority.MONITOR)
            public void onPlayerJoin(PlayerJoinEvent e) {
                CommandAPIHandler.getInstance().getNMS().resendPackets(e.getPlayer());
            }
        };
        Bukkit.getServer().getPluginManager().registerEvents(playerJoinListener, plugin);
    }

    public static void updateRequirements(Player player) {
        CommandAPIHandler.getInstance().getNMS().resendPackets(player);
    }

    public static void reloadDatapacks() {
        try {
            CommandAPIHandler.getInstance().getNMS().reloadDataPacks();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public static WrapperCommandSyntaxException fail(String message) throws WrapperCommandSyntaxException {
        return new WrapperCommandSyntaxException(new SimpleCommandExceptionType((Message)new LiteralMessage(message)).create());
    }

    public static boolean canRegister() {
        return canRegister;
    }

    public static void unregister(String command) {
        CommandAPIHandler.getInstance().unregister(command, false);
    }

    public static void unregister(String command, boolean force) {
        if (!CommandAPI.canRegister()) {
            CommandAPI.getLogger().warning("Unexpected unregistering of /" + command + ", as server is loaded! Unregistering anyway, but this can lead to unstable results!");
        }
        CommandAPIHandler.getInstance().unregister(command, force);
    }

    public static void registerCommand(Class<?> commandClass) {
        try {
            Class.forName(commandClass.getName() + "$Command").getDeclaredMethod("register", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    static {
        loaded = false;
    }

    private static class CommandAPILogger
    extends Logger {
        protected CommandAPILogger() {
            super("CommandAPI", null);
            this.setParent(Bukkit.getServer().getLogger());
            this.setLevel(Level.ALL);
        }
    }
}

