/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.EntitySelector;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.nms.NMS_1_19_R1_ChatPreviewHandler;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentEnchantment;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentEntitySummon;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentMobEffect;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_19_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftSound;
import org.bukkit.craftbukkit.v1_19_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_19_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_19_R1
extends NMS_Common<CommandListenerWrapper> {
    private static final MinecraftServer MINECRAFT_SERVER;
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle EntityPositionSource_sourceEntity;
    private static final DynamicCommandExceptionType ERROR_BIOME_INVALID;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(MinecraftKey key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    @Override
    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public ArgumentType<?> _ArgumentEntity(EntitySelector selector) {
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> ArgumentEntity.b();
            case EntitySelector.MANY_PLAYERS -> ArgumentEntity.d();
            case EntitySelector.ONE_ENTITY -> ArgumentEntity.a();
            case EntitySelector.ONE_PLAYER -> ArgumentEntity.c();
        };
    }

    @Override
    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceOrTagLocationArgument.a((ResourceKey)IRegistry.aR);
    }

    @Override
    public void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        for (Map.Entry<String, HelpTopic> entry : helpTopicsToAdd.entrySet()) {
            helpTopics.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean canUseChatPreview() {
        return Bukkit.shouldSendChatPreviews();
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.19", "1.19.1"};
    }

    @Override
    public String convert(org.bukkit.inventory.ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is).v().e_();
    }

    @Override
    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> MINECRAFT_SERVER.aA().a(commandFunction, css);
        CustomFunction.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_19_R1.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    @Override
    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return PaperComponents.gsonSerializer().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    @Override
    public Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return PaperComponents.gsonSerializer().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public Biome getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ResourceOrTagLocationArgument.c biomeResult = ResourceOrTagLocationArgument.a(cmdCtx, (String)key, (ResourceKey)IRegistry.aR, (DynamicCommandExceptionType)ERROR_BIOME_INVALID);
        if (biomeResult.a().left().isPresent()) {
            return Biome.valueOf((String)((ResourceKey)biomeResult.a().left().get()).a().a().toUpperCase());
        }
        throw ERROR_BIOME_INVALID.create((Object)biomeResult.b());
    }

    @Override
    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).f(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        return NMS_1_19_R1.MINECRAFT_SERVER.vanillaCommandDispatcher.a();
    }

    @Override
    public ChatColor getChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        return CraftChatMessage.getColor((EnumChatFormat)ArgumentChatFormat.a(cmdCtx, (String)str));
    }

    @Override
    public CommandListenerWrapper getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    @Override
    public CommandSender getCommandSenderFromCSS(CommandListenerWrapper css) {
        try {
            return css.getBukkitSender();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        return new CraftEnchantment(ArgumentEnchantment.a(cmdCtx, (String)str));
    }

    @Override
    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, EntitySelector selector) throws CommandSyntaxException {
        net.minecraft.commands.arguments.selector.EntitySelector argument = (net.minecraft.commands.arguments.selector.EntitySelector)cmdCtx.getArgument(str, net.minecraft.commands.arguments.selector.EntitySelector.class);
        try {
            CommandAPIHandler.getInstance().getField(net.minecraft.commands.arguments.selector.EntitySelector.class, "o").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (net.minecraft.world.entity.Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case EntitySelector.MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case EntitySelector.ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
            }
            case EntitySelector.ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
        };
    }

    @Override
    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.a((EntityTypes)((EntityTypes)IRegistry.X.a(ArgumentEntitySummon.a(cmdCtx, (String)str)))).a());
    }

    @Override
    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction commandFunction : ArgumentTag.a(cmdCtx, (String)str)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return this.convertFunction((CustomFunction)MINECRAFT_SERVER.aA().a(new MinecraftKey(key.getNamespace(), key.getKey())).get());
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : MINECRAFT_SERVER.aA().e()) {
            result.add(NMS_1_19_R1.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((ItemStack)ArgumentItemStack.a(cmdCtx, (String)str).a(1, false));
    }

    @Override
    public Predicate<org.bukkit.inventory.ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item));
    }

    @Override
    public Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.c(), blockPos.d());
    }

    @Override
    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.a(cmdCtx, (String)str);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    @Override
    public Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)str).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    @Override
    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)str);
        return new CraftLootTable(NMS_1_19_R1.fromResourceLocation(resourceLocation), MINECRAFT_SERVER.aH().a(resourceLocation));
    }

    @Override
    public String getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreboardObjective.a(cmdCtx, (String)key).b();
    }

    @Override
    public String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key).d();
    }

    @Override
    public ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)str);
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).f();
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            ParticleType options = (ParticleType)particleOptions;
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options.c()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            Color toColor = Color.fromRGB((int)((int)(options.d().a() * 255.0f)), (int)((int)(options.d().b() * 255.0f)), (int)((int)(options.d().c() * 255.0f)));
            return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.f()));
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<org.bukkit.inventory.ItemStack>(particle, CraftItemStack.asBukkitCopy((ItemStack)options.c()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            Vibration.Destination.BlockDestination destination;
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).e();
            Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
            PositionSource positionSource = options.c();
            if (positionSource instanceof BlockPositionSource) {
                BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
                to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
                destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
            } else {
                to = options.c();
                if (to instanceof EntityPositionSource) {
                    EntityPositionSource positionSource3 = (EntityPositionSource)to;
                    positionSource3.a((net.minecraft.world.level.World)level);
                    Either entity = EntityPositionSource_sourceEntity.get(positionSource3);
                    if (entity.left().isPresent()) {
                        destination = new Vibration.Destination.EntityDestination((Entity)((net.minecraft.world.entity.Entity)entity.left().get()).getBukkitEntity());
                    } else {
                        Either id = (Either)entity.right().get();
                        if (id.left().isPresent()) {
                            destination = new Vibration.Destination.EntityDestination(Bukkit.getEntity((UUID)((UUID)id.left().get())));
                        } else {
                            net.minecraft.world.entity.Entity foundEntity = null;
                            for (WorldServer world : MINECRAFT_SERVER.E()) {
                                net.minecraft.world.entity.Entity entityById = world.a(((Integer)id.right().get()).intValue());
                                if (entityById == null) continue;
                                foundEntity = entityById;
                                break;
                            }
                            destination = new Vibration.Destination.EntityDestination((Entity)foundEntity.getBukkitEntity());
                        }
                    }
                } else {
                    CommandAPI.getLogger().warning("Unknown vibration destination " + options.c());
                    return new ParticleData<Object>(particle, null);
                }
            }
            return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.d()));
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.c());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    @Override
    public PotionEffectType getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        return new CraftPotionEffectType(ArgumentMobEffect.a(cmdCtx, (String)str));
    }

    public ComplexRecipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        IRecipe recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_19_R1.fromResourceLocation(recipe.f()), recipe.toBukkitRecipe());
    }

    @Override
    public CommandSender getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        Vec3D pos = css.e();
        Vec2F rot = css.l();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.i, rot.j);
        net.minecraft.world.entity.Entity proxyEntity = css.g();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    @Override
    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public Sound getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftSound.getBukkit((SoundEffect)((SoundEffect)IRegistry.S.a(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key))));
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = MINECRAFT_SERVER.aA();
                ICompletionProvider.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(MINECRAFT_SERVER.az().a().stream().map(Advancement::h), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)MINECRAFT_SERVER.aH().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = MINECRAFT_SERVER.aA().b(new MinecraftKey(key.getNamespace(), key.getKey()));
        return customFunctions.toArray(new SimpleFunctionWrapper[0]);
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : MINECRAFT_SERVER.aA().e()) {
            result.add(NMS_1_19_R1.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public String getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreboardTeam.a(cmdCtx, (String)key).b();
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.f() == null ? null : css.f().getWorld();
    }

    @Override
    public void hookChatPreview(Plugin plugin, Player player) {
        Channel playerChannel = ((CraftPlayer)player).getHandle().b.b.m;
        if (playerChannel.pipeline().get("CommandAPI_" + player.getName()) == null) {
            playerChannel.pipeline().addBefore("packet_handler", "CommandAPI_" + player.getName(), (ChannelHandler)new NMS_1_19_R1_ChatPreviewHandler(this, plugin, player));
        }
    }

    @Override
    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    @Override
    public void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = NMS_1_19_R1.MINECRAFT_SERVER.at;
        serverResources.b().d = MINECRAFT_SERVER.aC();
        try {
            CommandAPIHandler.getInstance().getField(CustomFunctionManager.class, "i").set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        ArrayList<String> packIDs = new ArrayList<String>(MINECRAFT_SERVER.aB().d());
        List disabledPacks = MINECRAFT_SERVER.aW().D().b();
        for (String availablePack : MINECRAFT_SERVER.aB().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        IRegistryCustom.Dimension registryAccess = MINECRAFT_SERVER.aX();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = MINECRAFT_SERVER.aB();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.a(packID);
                if (pack == null) continue;
                packResources.add(pack.d());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().h(), (Executor)NMS_1_19_R1.MINECRAFT_SERVER.ar, (Executor)MINECRAFT_SERVER, CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            NMS_1_19_R1.MINECRAFT_SERVER.at.close();
            NMS_1_19_R1.MINECRAFT_SERVER.at = serverResources;
            NMS_1_19_R1.MINECRAFT_SERVER.server.syncCommands();
            MINECRAFT_SERVER.aB().a(collection);
            Collection selectedIDs = MINECRAFT_SERVER.aB().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList disabledIDs = new ArrayList(MINECRAFT_SERVER.aB().b());
            ListIterator disabledIDsIterator = disabledIDs.listIterator();
            while (disabledIDsIterator.hasNext()) {
                if (!enabledIDs.contains(disabledIDsIterator.next())) continue;
                disabledIDsIterator.remove();
            }
            MINECRAFT_SERVER.aW().a(new DataPackConfiguration((List)enabledIDs, disabledIDs));
            NMS_1_19_R1.MINECRAFT_SERVER.at.b().a((IRegistryCustom)registryAccess);
            MINECRAFT_SERVER.aV().a((IResourceManager)NMS_1_19_R1.MINECRAFT_SERVER.at.a());
        });
        if (MINECRAFT_SERVER.bm()) {
            MINECRAFT_SERVER.c(((CompletableFuture)third)::isDone);
        }
        try {
            ((CompletableFuture)third).get();
            while (recipes.hasNext()) {
                Recipe recipe = (Recipe)recipes.next();
                try {
                    Bukkit.addRecipe((Recipe)recipe);
                    if (!(recipe instanceof Keyed)) continue;
                    Keyed keyedRecipe = (Keyed)recipe;
                    CommandAPI.logInfo("Re-registering recipe: " + keyedRecipe.getKey());
                }
                catch (Exception e) {}
            }
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public void resendPackets(Player player) {
        MINECRAFT_SERVER.aC().a(((CraftPlayer)player).getHandle());
    }

    @Override
    public void unhookChatPreview(Player player) {
        Channel channel = ((CraftPlayer)player).getHandle().b.b.m;
        if (channel.pipeline().get("CommandAPI_" + player.getName()) != null) {
            channel.eventLoop().submit(() -> channel.pipeline().remove("CommandAPI_" + player.getName()));
        }
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            MINECRAFT_SERVER = server2.getServer();
            COMMAND_BUILD_CONTEXT = new CommandBuildContext((IRegistryCustom)IRegistryCustom.d.get());
            COMMAND_BUILD_CONTEXT.a(CommandBuildContext.a.b);
        } else {
            MINECRAFT_SERVER = null;
            COMMAND_BUILD_CONTEXT = null;
        }
        VarHandle shm_ht = null;
        VarHandle eps_se = null;
        try {
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            eps_se = MethodHandles.privateLookupIn(EntityPositionSource.class, MethodHandles.lookup()).findVarHandle(EntityPositionSource.class, "c", Either.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        SimpleHelpMap_helpTopics = shm_ht;
        EntityPositionSource_sourceEntity = eps_se;
        ERROR_BIOME_INVALID = new DynamicCommandExceptionType(arg -> IChatBaseComponent.a((String)"commands.locate.biome.invalid", (Object[])new Object[]{arg}));
    }
}

