/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_19_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftSound;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_19_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_19_4_R3
extends NMS_Common {
    private static final MinecraftServer MINECRAFT_SERVER;
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle EntityPositionSource_sourceEntity;
    private static final DynamicCommandExceptionType ERROR_BIOME_INVALID;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(MinecraftKey key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.q);
    }

    @Override
    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceOrTagArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.an);
    }

    @Override
    public final void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        helpTopics.putAll(helpTopicsToAdd);
    }

    @Override
    public final boolean canUseChatPreview() {
        return false;
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.19.3"};
    }

    @Override
    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).v().f_();
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).a();
    }

    private final SimpleFunctionWrapper convertFunction(CustomFunction commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> MINECRAFT_SERVER.aA().a(commandFunction, css);
        CustomFunction.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_19_4_R3.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    @Override
    public final void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public final Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return PaperComponents.gsonSerializer().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public final Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        ResourceOrTagArgument.c biomeResult = ResourceOrTagArgument.a(cmdCtx, (String)key, (ResourceKey)Registries.an);
        if (biomeResult.a().left().isPresent()) {
            MinecraftKey resourceLocation = ((Holder.c)biomeResult.a().left().get()).g().a();
            return switch (subType) {
                case ArgumentSubType.BIOME_BIOME -> {
                    Biome biome = null;
                    try {
                        biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                    }
                    catch (IllegalArgumentException biomeNotFound) {
                        biome = null;
                    }
                    Biome var6_8 = biome;
                    yield var6_8;
                }
                case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                    NamespacedKey var6_9;
                    yield var6_9 = NMS_1_19_4_R3.fromResourceLocation(resourceLocation);
                }
                default -> {
                    NamespacedKey var6_10;
                    yield var6_10 = null;
                }
            };
        }
        throw ERROR_BIOME_INVALID.create((Object)biomeResult.b());
    }

    @Override
    public final Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).e(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public final BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public final CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        return NMS_1_19_4_R3.MINECRAFT_SERVER.vanillaCommandDispatcher.a();
    }

    @Override
    public final CommandListenerWrapper getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    @Override
    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    @Override
    public final World.Environment getEnvironment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld().getEnvironment();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return org.bukkit.enchantments.Enchantment.getByKey((NamespacedKey)NMS_1_19_4_R3.fromResourceLocation(BuiltInRegistries.g.b((Object)((Enchantment)ResourceArgument.g(cmdCtx, (String)key).a()))));
    }

    @Override
    public final Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            CommandAPIHandler.getInstance().getField(EntitySelector.class, "p").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (net.minecraft.world.entity.Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public final EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.a((EntityTypes)((EntityTypes)ResourceArgument.e(cmdCtx, (String)key).a())).a());
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public final ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ArgumentItemStack.a(cmdCtx, (String)key).a(1, false));
    }

    @Override
    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public final Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.c(), blockPos.d());
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public final Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.a(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    @Override
    public final Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)key).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_19_4_R3.fromResourceLocation(resourceLocation), MINECRAFT_SERVER.aH().a(resourceLocation));
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options.c()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.c()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.c());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, Particle particle, VibrationParticleOption options) {
        Vibration.Destination destination;
        Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).d();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        PositionSource positionSource = options.c();
        if (positionSource instanceof BlockPositionSource) {
            BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
            Vec3D to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
            destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        } else {
            positionSource = options.c();
            if (positionSource instanceof EntityPositionSource) {
                EntityPositionSource positionSource3 = (EntityPositionSource)positionSource;
                destination = this.getVibrationParticleOptionDestinationAsEntityPositionSource(positionSource3, (net.minecraft.world.level.World)level);
            } else {
                CommandAPI.getLogger().warning("Unknown vibration destination " + options.c());
                return new ParticleData<Object>(particle, null);
            }
        }
        return new ParticleData<Vibration>(particle, new Vibration(from, destination, options.d()));
    }

    private Vibration.Destination getVibrationParticleOptionDestinationAsEntityPositionSource(EntityPositionSource positionSource, net.minecraft.world.level.World level) {
        positionSource.a(level);
        Either entity = EntityPositionSource_sourceEntity.get(positionSource);
        if (entity.left().isPresent()) {
            return new Vibration.Destination.EntityDestination((Entity)((net.minecraft.world.entity.Entity)entity.left().get()).getBukkitEntity());
        }
        Either id = (Either)entity.right().get();
        if (id.left().isPresent()) {
            return new Vibration.Destination.EntityDestination(Bukkit.getEntity((UUID)((UUID)id.left().get())));
        }
        net.minecraft.world.entity.Entity foundEntity = null;
        for (WorldServer world : MINECRAFT_SERVER.F()) {
            net.minecraft.world.entity.Entity entityById = world.a(((Integer)id.right().get()).intValue());
            if (entityById == null) continue;
            foundEntity = entityById;
            break;
        }
        return new Vibration.Destination.EntityDestination((Entity)foundEntity.getBukkitEntity());
    }

    @Override
    public PotionEffectType getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getByKey((NamespacedKey)NMS_1_19_4_R3.fromResourceLocation(BuiltInRegistries.e.b((Object)((MobEffectList)ResourceArgument.f(cmdCtx, (String)key).a()))));
    }

    @Override
    public CommandSender getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        Vec3D pos = css.d();
        Vec2F rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.i, rot.j);
        net.minecraft.world.entity.Entity proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                SoundEffect soundEvent = (SoundEffect)BuiltInRegistries.c.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((SoundEffect)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = this.getMinecraftServer().aA();
                ICompletionProvider.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(this.getMinecraftServer().az().a().stream().map(Advancement::i), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)this.getMinecraftServer().aH().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = MINECRAFT_SERVER.aA().b(new MinecraftKey(key.getNamespace(), key.getKey()));
        return customFunctions.toArray(new SimpleFunctionWrapper[0]);
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    @Override
    public void hookChatPreview(Plugin plugin, Player player) {
    }

    @Override
    public final boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = NMS_1_19_4_R3.MINECRAFT_SERVER.au;
        serverResources.b().d = MINECRAFT_SERVER.aC();
        try {
            CommandAPIHandler.getInstance().getField(CustomFunctionManager.class, "g").set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        ArrayList<String> packIDs = new ArrayList<String>(MINECRAFT_SERVER.aB().d());
        List disabledPacks = MINECRAFT_SERVER.aW().F().a().b();
        for (String availablePack : MINECRAFT_SERVER.aB().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        IRegistryCustom.Dimension registryAccess = MINECRAFT_SERVER.aX();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = MINECRAFT_SERVER.aB();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().h(), (Executor)NMS_1_19_4_R3.MINECRAFT_SERVER.as, (Executor)MINECRAFT_SERVER, CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            NMS_1_19_4_R3.MINECRAFT_SERVER.au.close();
            NMS_1_19_4_R3.MINECRAFT_SERVER.au = serverResources;
            NMS_1_19_4_R3.MINECRAFT_SERVER.server.syncCommands();
            MINECRAFT_SERVER.aB().a(collection);
            Collection selectedIDs = MINECRAFT_SERVER.aB().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(MINECRAFT_SERVER.aB().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            MINECRAFT_SERVER.aW().a(new WorldDataConfiguration(new DataPackConfiguration((List)enabledIDs, disabledIDs), MINECRAFT_SERVER.aW().F().b()));
            NMS_1_19_4_R3.MINECRAFT_SERVER.au.b().a((IRegistryCustom)registryAccess);
            MINECRAFT_SERVER.aV().a((IResourceManager)NMS_1_19_4_R3.MINECRAFT_SERVER.au.a());
        });
        if (MINECRAFT_SERVER.bn()) {
            MINECRAFT_SERVER.c(((CompletableFuture)third)::isDone);
        }
        try {
            while (true) {
                if (!recipes.hasNext()) {
                    CommandAPI.logNormal("Finished reloading datapacks");
                    return;
                }
                Recipe recipe = (Recipe)recipes.next();
                try {
                    Bukkit.addRecipe((Recipe)recipe);
                    if (!(recipe instanceof Keyed)) continue;
                    Keyed keyedRecipe = (Keyed)recipe;
                    CommandAPI.logInfo("Re-registering recipe: " + keyedRecipe.getKey());
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public final void resendPackets(Player player) {
        MINECRAFT_SERVER.aC().a(((CraftPlayer)player).getHandle());
    }

    @Override
    public final void unhookChatPreview(Player player) {
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public final MinecraftServer getMinecraftServer() {
        return MINECRAFT_SERVER;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.N);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.r);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            MINECRAFT_SERVER = server2.getServer();
            COMMAND_BUILD_CONTEXT = CommandBuildContext.a((IRegistryCustom)MINECRAFT_SERVER.aX(), (FeatureFlagSet)MINECRAFT_SERVER.aW().F().b());
        } else {
            MINECRAFT_SERVER = null;
            COMMAND_BUILD_CONTEXT = null;
        }
        VarHandle shm_ht = null;
        VarHandle eps_se = null;
        try {
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            eps_se = MethodHandles.privateLookupIn(EntityPositionSource.class, MethodHandles.lookup()).findVarHandle(EntityPositionSource.class, "c", Either.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        SimpleHelpMap_helpTopics = shm_ht;
        EntityPositionSource_sourceEntity = eps_se;
        ERROR_BIOME_INVALID = new DynamicCommandExceptionType(arg -> IChatBaseComponent.a((String)"commands.locatebiome.invalid", (Object[])new Object[]{arg}));
    }
}

