/*
 * Decompiled with CFR 0.152.
 */
package MarcSync;

import MarcSync.classes.EntryData;
import MarcSync.classes.EntryFilterPayload;
import MarcSync.classes.EntryUpdatePayload;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class Entry {
    private final String _accessToken;
    private final String _collectionName;
    private final EntryData _entryData;
    private final ObjectMapper _mapper;

    public Entry(String accessToken, String collectionName, EntryData entryData) {
        this._accessToken = accessToken;
        this._collectionName = collectionName;
        this._entryData = entryData;
        this._mapper = new ObjectMapper();
        this._mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this._mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public EntryData getValues() {
        return this._entryData;
    }

    public Object getValue(String key) {
        return this._entryData.get(key);
    }

    public String getCollectionName() {
        return this._collectionName;
    }

    public EntryData updateValue(final String key, final Object value) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(this._mapper.writeValueAsString((Object)new EntryUpdatePayload(new EntryData(){
                {
                    this.put("_id", Entry.this._entryData.get("_id"));
                }
            }, new EntryData(){
                {
                    this.put(key, value);
                }
            })).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to update entry: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return this._entryData;
    }

    public EntryData updateValues(EntryData entryData) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(this._mapper.writeValueAsString((Object)new EntryUpdatePayload(new EntryData(){
                {
                    this.put("_id", Entry.this._entryData.get("_id"));
                }
            }, entryData)).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to update entry: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return this._entryData;
    }

    public void delete() throws IOException, URISyntaxException {
        URL url = new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(this._mapper.writeValueAsString((Object)new EntryFilterPayload(new EntryData(){
                {
                    this.put("_id", Entry.this._entryData.get("_id"));
                }
            })).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to delete entry: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }
}

