/*
 * Decompiled with CFR 0.152.
 */
package dev.postproxy.sdk.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.postproxy.sdk.PostProxyClient;
import dev.postproxy.sdk.model.ListResponse;
import dev.postproxy.sdk.model.Placement;
import dev.postproxy.sdk.model.Profile;
import dev.postproxy.sdk.model.SuccessResponse;
import java.util.LinkedHashMap;

public class ProfilesResource {
    private final PostProxyClient client;

    public ProfilesResource(PostProxyClient client) {
        this.client = client;
    }

    public ListResponse<Profile> list() {
        return this.list(null);
    }

    public ListResponse<Profile> list(String profileGroupId) {
        String pgId;
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String string = pgId = profileGroupId != null ? profileGroupId : this.client.getDefaultProfileGroupId();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.get("/api/profiles", query, new TypeReference<ListResponse<Profile>>(){});
    }

    public Profile get(String id) {
        return this.get(id, null);
    }

    public Profile get(String id, String profileGroupId) {
        String pgId;
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String string = pgId = profileGroupId != null ? profileGroupId : this.client.getDefaultProfileGroupId();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.get("/api/profiles/" + id, query, new TypeReference<Profile>(){});
    }

    public ListResponse<Placement> placements(String id) {
        return this.placements(id, null);
    }

    public ListResponse<Placement> placements(String id, String profileGroupId) {
        String pgId;
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String string = pgId = profileGroupId != null ? profileGroupId : this.client.getDefaultProfileGroupId();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.get("/api/profiles/" + id + "/placements", query, new TypeReference<ListResponse<Placement>>(){});
    }

    public SuccessResponse delete(String id) {
        return this.delete(id, null);
    }

    public SuccessResponse delete(String id, String profileGroupId) {
        String pgId;
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String string = pgId = profileGroupId != null ? profileGroupId : this.client.getDefaultProfileGroupId();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.delete("/api/profiles/" + id, query, new TypeReference<SuccessResponse>(){});
    }
}

