/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopHttpConnectionConfig;
import dev.shortloop.common.models.data.APISample;
import dev.shortloop.common.models.data.AgentConfig;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.web.util.UriComponentsBuilder;

public final class ShortloopHTTPConnection {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private URL shortloopSendSampleUrl = null;
    private URL shortloopConfigUrl = null;
    private final Map<String, String> headers;
    private final ShortloopHttpConnectionConfig httpConnectionConfig;
    private final SDKLogger sdkLogger;
    private final ObjectMapper objectMapper;
    final String userApplicationName;
    final String agentId;

    public ShortloopHTTPConnection(String shortloopUrl, String userApplicationName, String agentId, ShortloopHttpConnectionConfig shortloopHttpConnectionConfig, SDKLogger sdkLogger, String authKey) {
        String message;
        this.userApplicationName = userApplicationName;
        this.agentId = agentId;
        this.sdkLogger = sdkLogger;
        this.headers = new HashMap<String, String>();
        this.headers.put("sdk_major", "1");
        this.headers.put("sdk_minor", "2");
        if (authKey != null) {
            this.headers.put("authKey", authKey);
        }
        this.httpConnectionConfig = shortloopHttpConnectionConfig;
        this.objectMapper = new ObjectMapper();
        try {
            this.shortloopSendSampleUrl = URI.create(shortloopUrl + "/api/v1/data-ingestion/api-sample").toURL();
        }
        catch (Exception e) {
            message = String.format("Unable to create SendSampleUrl from %s. Error: %s", shortloopUrl, e.getMessage());
            System.out.println(message);
            sdkLogger.forceLog(message);
        }
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("appName", userApplicationName);
            queryParams.put("agentId", agentId);
            String configUrl = shortloopUrl + "/api/v1/agent-config" + ShortloopHTTPConnection.getQueryParams(queryParams);
            this.shortloopConfigUrl = URI.create(configUrl).toURL();
        }
        catch (Exception e) {
            message = String.format("Unable to create ConfigUrl from %s. Error: %s", shortloopUrl, e.getMessage());
            System.out.println(message);
            sdkLogger.forceLog(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void sendSamples(List<APISample> dataList) {
        block50: {
            try {
                String errorMessage;
                if (null == this.shortloopSendSampleUrl) {
                    this.sdkLogger.error("SendSampleUrl is null");
                    return;
                }
                if (null == dataList || dataList.size() == 0) {
                    this.sdkLogger.error("No Samples to send");
                    return;
                }
                String payload = null;
                try {
                    payload = this.objectMapper.writeValueAsString(dataList);
                }
                catch (Exception e) {
                    this.sdkLogger.error("Error while parsing content", e);
                    return;
                }
                if (null == payload || payload.length() == 0) {
                    this.sdkLogger.error("Content is empty");
                    return;
                }
                HttpURLConnection connection = (HttpURLConnection)this.shortloopSendSampleUrl.openConnection();
                for (Map.Entry<String, String> header : this.headers.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("Connection", "close");
                connection.setConnectTimeout(this.httpConnectionConfig.getConnectTimeout());
                connection.setReadTimeout(this.httpConnectionConfig.getReadTimeout());
                connection.connect();
                try (OutputStream outputStream = connection.getOutputStream();
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                     BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, UTF_8));){
                    writer.write(payload);
                    ((Writer)writer).flush();
                }
                try {
                    int responseCode = connection.getResponseCode();
                    if (!this.isSuccessfulResponseCode(responseCode)) {
                        this.sdkLogger.error(String.format("Send Sample Request failed, API returned %s", responseCode));
                        if (this.sdkLogger.canLogError()) {
                            errorMessage = this.getErrorMessageFromStream(connection);
                            this.sdkLogger.error(errorMessage);
                        }
                    }
                    break block50;
                }
                catch (Exception e) {
                    this.sdkLogger.error("Error reading and logging the response stream", e);
                    break block50;
                }
                finally {
                    this.closeAndDisconnect(connection);
                }
                catch (Throwable e) {
                    try {
                        this.sdkLogger.error("An exception occurred while sending Samples", e);
                    }
                    catch (Throwable throwable) {
                        try {
                            int responseCode = connection.getResponseCode();
                            if (!this.isSuccessfulResponseCode(responseCode)) {
                                this.sdkLogger.error(String.format("Send Sample Request failed, API returned %s", responseCode));
                                if (this.sdkLogger.canLogError()) {
                                    String errorMessage2 = this.getErrorMessageFromStream(connection);
                                    this.sdkLogger.error(errorMessage2);
                                }
                            }
                        }
                        catch (Exception e2) {
                            this.sdkLogger.error("Error reading and logging the response stream", e2);
                        }
                        finally {
                            this.closeAndDisconnect(connection);
                        }
                        throw throwable;
                    }
                    try {
                        int responseCode = connection.getResponseCode();
                        if (!this.isSuccessfulResponseCode(responseCode)) {
                            this.sdkLogger.error(String.format("Send Sample Request failed, API returned %s", responseCode));
                            if (this.sdkLogger.canLogError()) {
                                errorMessage = this.getErrorMessageFromStream(connection);
                                this.sdkLogger.error(errorMessage);
                            }
                        }
                    }
                    catch (Exception e3) {
                        this.sdkLogger.error("Error reading and logging the response stream", e3);
                    }
                    finally {
                        this.closeAndDisconnect(connection);
                    }
                }
            }
            catch (Exception e) {
                this.sdkLogger.error("Error ShortloopHTTPConnection::sendSamples", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public AgentConfig getSDKConfig() {
        block21: {
            try {
                if (null == this.shortloopConfigUrl) {
                    this.sdkLogger.error("SendSampleUrl is null");
                    return null;
                }
                HttpURLConnection connection = (HttpURLConnection)this.shortloopConfigUrl.openConnection();
                for (Map.Entry<String, String> header : this.headers.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
                connection.setRequestMethod("GET");
                connection.setDoOutput(false);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("Connection", "close");
                connection.setConnectTimeout(this.httpConnectionConfig.getConnectTimeout());
                connection.setReadTimeout(this.httpConnectionConfig.getReadTimeout());
                connection.connect();
                try {
                    String response;
                    BufferedReader br;
                    block20: {
                        AgentConfig agentConfig;
                        int responseCode = connection.getResponseCode();
                        if (!this.isSuccessfulResponseCode(responseCode)) {
                            String errorMessage;
                            this.sdkLogger.error(String.format("GetConfig Request failed, API returned %s", responseCode));
                            if (this.sdkLogger.canLogError()) {
                                errorMessage = this.getErrorMessageFromStream(connection);
                                this.sdkLogger.error(errorMessage);
                            }
                            errorMessage = null;
                            return errorMessage;
                        }
                        br = new BufferedReader(new InputStreamReader(connection.getInputStream(), UTF_8));
                        try {
                            StringBuilder responseBuilder = new StringBuilder();
                            String responseLine = null;
                            while ((responseLine = br.readLine()) != null) {
                                responseBuilder.append(responseLine.trim());
                            }
                            response = responseBuilder.toString();
                            if (response.length() != 0) break block20;
                            agentConfig = null;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                this.sdkLogger.error("Error reading and logging the response stream", e);
                                break block21;
                            }
                        }
                        br.close();
                        return agentConfig;
                    }
                    AgentConfig agentConfig = (AgentConfig)this.objectMapper.readValue(response, (TypeReference)new TypeReference<AgentConfig>(){});
                    br.close();
                    return agentConfig;
                }
                finally {
                    this.closeAndDisconnect(connection);
                }
            }
            catch (Exception e) {
                this.sdkLogger.error("Error ShortloopHTTPConnection::getAgentConfig", e);
            }
        }
        return null;
    }

    private void closeAndDisconnect(HttpURLConnection connection) {
        try {
            connection.getInputStream().close();
        }
        catch (IOException iOException) {
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getErrorMessageFromStream(HttpURLConnection connection) {
        try (InputStream errorStream = connection.getErrorStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                while ((line = reader.readLine()) != null) {
                    if (!first) {
                        sb.append("\n");
                    }
                    sb.append(line);
                    first = false;
                }
                string = sb.toString();
            }
            return string;
        }
        catch (IOException e) {
            return "Failed to obtain error message while analyzing send failure.";
        }
    }

    private boolean isSuccessfulResponseCode(int responseCode) {
        return responseCode == 200;
    }

    private static String getQueryParams(Map<String, String> params) throws UnsupportedEncodingException {
        if (ObjectUtils.isEmpty(params)) {
            return "";
        }
        UriComponentsBuilder componentsBuilder = UriComponentsBuilder.newInstance();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            componentsBuilder.queryParam(entry.getKey(), new Object[]{URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString())});
        }
        return componentsBuilder.build().toString();
    }
}

