package dev.shortloop.agent;

import dev.shortloop.agent.buffer.DiscoveredApiBufferManager;
import dev.shortloop.agent.buffer.RegisteredApiBufferManager;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.agent.config.SimpleConfigManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.Random;


@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(name = "shortloop.enabled", havingValue = "true")
@Import(ShortloopHttpClientConfig.class)
public class ShortloopAutoConfiguration {
    @Value("${shortloop.ctUrl:}")
    private String ctUrl;

    @Value("${shortloop.applicationName:}")
    private String userApplicationName;

    @Value("${shortloop.loggingEnabled:false}")
    private boolean loggingEnabled;

    @Value("${shortloop.logLevel:ERROR}")
    private String logLevel;


    @Bean
    @ConditionalOnProperty(prefix = "shortloop", name = {"ctUrl"})
    ShortloopSpringFilter getShortloopSpringFilter(ShortloopHttpClientConfig shortloopHttpClientConfig) {
        if (StringUtils.isEmpty(ctUrl)) {
            return null;
        }
        if (StringUtils.isEmpty(userApplicationName)) {
            return null;
        }

        SDKLogger.LogLevel logLevel = null == this.logLevel ? SDKLogger.LogLevel.ERROR : SDKLogger.LogLevel.valueOf(this.logLevel);
        SDKLogger sdkLogger = new SDKLogger(loggingEnabled, logLevel);

        ShortloopHttpClient shortloopHttpClient = new ShortloopHttpClient(shortloopHttpClientConfig);

        Random random = new Random();
        int randomId = random.nextInt(1000);
        String agentId = String.valueOf(randomId);

        ConfigManager configManager = new SimpleConfigManager(ctUrl, userApplicationName, agentId, shortloopHttpClient, sdkLogger);
        configManager.init();

        RegisteredApiBufferManager registeredApiBufferManager = new RegisteredApiBufferManager(configManager, shortloopHttpClient, ctUrl, sdkLogger);
        registeredApiBufferManager.init();

        DiscoveredApiBufferManager discoveredApiBufferManager = new DiscoveredApiBufferManager(configManager, shortloopHttpClient, ctUrl, sdkLogger);
        discoveredApiBufferManager.init();

        ShortloopApiProcessor shortloopApiProcessor = new ShortloopApiProcessor(registeredApiBufferManager, discoveredApiBufferManager, sdkLogger);
        ShortloopSpringFilter shortloopSpringFilter = new ShortloopSpringFilter(configManager, shortloopApiProcessor, userApplicationName, sdkLogger);
        shortloopSpringFilter.init();
        String message = String.format("Shortloop Initialised!\napplicationName:: %s\nctUrl:: %s\nagentId:: %s\nSDK Version:: %s.%s",
                userApplicationName, ctUrl, agentId, SDKVersion.MAJOR_VERSION, SDKVersion.MINOR_VERSION);
        System.out.println(message);
        sdkLogger.forceLog(message);
        return shortloopSpringFilter;
    }

}
