/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.buffer;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.buffer.ApiBufferKey;
import dev.shortloop.agent.buffer.BufferManagerWorker;
import dev.shortloop.agent.buffer.NoOpBufferManagerWorker;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.agent.config.ConfigUpdateListener;
import dev.shortloop.common.models.data.AgentConfig;

public abstract class AbstractBufferManager
implements ConfigUpdateListener {
    private final ConfigManager configManager;
    private BufferManagerWorker<ApiBufferKey> dummyWorker;
    private BufferManagerWorker<ApiBufferKey> worker;

    public AbstractBufferManager(ConfigManager configManager, SDKLogger logger) {
        this.configManager = configManager;
        this.dummyWorker = new NoOpBufferManagerWorker<ApiBufferKey>(logger);
        this.worker = this.dummyWorker;
    }

    public BufferManagerWorker<ApiBufferKey> getWorker() {
        return this.worker;
    }

    public String getUri() {
        return "/data-ingestion/api-sample";
    }

    abstract BufferManagerWorker<ApiBufferKey> createWorker(AgentConfig var1);

    @Override
    public synchronized void onSuccessfulConfigUpdate(AgentConfig newAgentConfig) {
        if (this.isRefreshNeeded(this.worker.getOperatingConfig(), newAgentConfig)) {
            BufferManagerWorker<ApiBufferKey> oldBufferManagerWorker = this.worker;
            this.worker = this.createWorker(newAgentConfig);
            oldBufferManagerWorker.shutdown();
        }
    }

    @Override
    public synchronized void onErroneousConfigUpdate() {
        BufferManagerWorker<ApiBufferKey> oldBuffer = this.worker;
        this.worker = this.dummyWorker;
        oldBuffer.shutdown();
    }

    public boolean init() {
        return this.configManager.subscribeToUpdates(this);
    }

    public boolean shutdown() {
        if (this.worker != null) {
            this.worker.shutdown();
            this.worker = null;
        }
        return true;
    }

    private boolean isRefreshNeeded(AgentConfig olderConfig, AgentConfig newConfig) {
        if (newConfig.getTimestamp().getTime() == 0L && olderConfig.getTimestamp().getTime() == 0L) {
            return false;
        }
        return newConfig.getTimestamp().getTime() > olderConfig.getTimestamp().getTime();
    }
}

