/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.shortloop.agent.HttpRequest;
import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopHttpClient;
import dev.shortloop.agent.config.AgentConfigUtils;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.agent.config.ConfigUpdateListener;
import dev.shortloop.common.models.data.AgentConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public final class SimpleConfigManager
implements ConfigManager {
    private final String ctUrl;
    private final ShortloopHttpClient shortloopHttpClient;
    private final String userApplicationName;
    private ScheduledExecutorService executorService;
    private SDKLogger logger;
    private final List<ConfigUpdateListener> configUpdateListeners = Collections.synchronizedList(Lists.newLinkedList());
    private final Map<String, String> configHeader = ImmutableMap.of((Object)"sdk_major", (Object)"1", (Object)"sdk_minor", (Object)"2");
    private final String agentId;

    public SimpleConfigManager(String ctUrl, String userApplicationName, String agentId, ShortloopHttpClient shortloopHttpClient, SDKLogger logger) {
        this.ctUrl = ctUrl;
        this.userApplicationName = userApplicationName;
        this.agentId = agentId;
        this.shortloopHttpClient = shortloopHttpClient;
        this.logger = logger;
    }

    @Override
    public boolean subscribeToUpdates(ConfigUpdateListener configUpdateListener) {
        this.configUpdateListeners.add(configUpdateListener);
        return true;
    }

    @Override
    public synchronized boolean shutdown() {
        this.logger.info("Shutting down SimpleConfigManager");
        if (null == this.executorService) {
            this.logger.info("Shutting down executorService");
            return true;
        }
        if (this.executorService.isShutdown()) {
            return true;
        }
        try {
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.logger.error("Still not able to shutdown SimpleConfigManager's executorService");
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Error while shutting down SimpleConfigManager's executorService", e);
        }
        return this.executorService.isShutdown();
    }

    public String getUri() {
        return "/agent-config";
    }

    @Override
    public synchronized boolean init() {
        try {
            this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new CustomizableThreadFactory("config-"));
            this.scheduleConfigRefresh(60);
        }
        catch (Exception e) {
            this.logger.error("Error in SimpleConfigManager's init()", e);
            return false;
        }
        return true;
    }

    private void scheduleConfigRefresh(int timeInSecs) {
        Runnable runnable = () -> {
            try {
                ConfigOrError configOrError = this.fetchConfig();
                if (null != configOrError.errorCode) {
                    this.scheduleConfigRefresh(60);
                    this.onUnSuccessfulConfigFetch(configOrError.errorCode);
                } else {
                    this.scheduleConfigRefresh(configOrError.getAgentConfig().getConfigFetchFreqInSec());
                    this.onSuccessfulConfigFetch(configOrError.agentConfig);
                }
            }
            catch (Exception e) {
                this.logger.error("Error in SimpleConfigManager's scheduleConfigRefresh()", e);
            }
        };
        this.executorService.schedule(runnable, (long)timeInSecs, TimeUnit.SECONDS);
    }

    private ConfigOrError fetchConfig() {
        try {
            HashMap queryParams = Maps.newHashMap();
            queryParams.put("appName", this.userApplicationName);
            queryParams.put("agentId", this.agentId);
            HttpRequest<Object, AgentConfig> httpRequest = new HttpRequest<Object, AgentConfig>(this.ctUrl + this.getUri(), null, queryParams, this.configHeader, new TypeReference<AgentConfig>(){});
            AgentConfig agentConfig = (AgentConfig)this.shortloopHttpClient.getRequest(httpRequest).getBody();
            if (null == agentConfig) {
                this.logger.error("Received null config :");
                return new ConfigOrError(null, ConfigOrError.ErrorCode.INVALID_CONFIG);
            }
            if (AgentConfigUtils.isConfigValid(agentConfig)) {
                return new ConfigOrError(agentConfig, null);
            }
            this.logger.error("Received invalid config :" + agentConfig);
            return new ConfigOrError(null, ConfigOrError.ErrorCode.INVALID_CONFIG);
        }
        catch (Exception exception) {
            this.logger.error("Error while fetching config", exception);
            return new ConfigOrError(null, ConfigOrError.ErrorCode.PARSE_ERROR);
        }
    }

    private void onSuccessfulConfigFetch(AgentConfig agentConfig) {
        for (ConfigUpdateListener configUpdateListener : this.configUpdateListeners) {
            configUpdateListener.onSuccessfulConfigUpdate(agentConfig);
        }
    }

    private void onUnSuccessfulConfigFetch(ConfigOrError.ErrorCode errorCode) {
        for (ConfigUpdateListener configUpdateListener : this.configUpdateListeners) {
            configUpdateListener.onErroneousConfigUpdate();
        }
    }

    private static class ConfigOrError {
        private final AgentConfig agentConfig;
        private final ErrorCode errorCode;

        public ConfigOrError(AgentConfig agentConfig, ErrorCode errorCode) {
            this.agentConfig = agentConfig;
            this.errorCode = errorCode;
        }

        public AgentConfig getAgentConfig() {
            return this.agentConfig;
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        private static enum ErrorCode {
            TIMEOUT,
            PARSE_ERROR,
            INVALID_CONFIG;

        }
    }
}

